/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.screen.addon.color;

import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.interfaces.ICanMouseDrag;
import com.hrznstudio.titanium.client.screen.addon.interfaces.IClickable;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Matrix4f;

public class ShadePickerAddon
extends BasicScreenAddon
implements IClickable,
ICanMouseDrag {
    private static final int S_TILES = 10;
    private static final int V_TILES = 10;
    private final Supplier<Float> hueSupplier;
    private final Consumer<Float> brightnessConsumer;
    private final Consumer<Float> saturationConsumer;
    private float brightness;
    private float saturation;

    public ShadePickerAddon(int posX, int posY, float brightness, float saturation, Supplier<Float> hueSupplier, Consumer<Float> brightnessConsumer, Consumer<Float> saturationConsumer) {
        super(posX, posY);
        this.hueSupplier = hueSupplier;
        this.brightness = brightness;
        this.saturation = saturation;
        this.brightnessConsumer = brightnessConsumer;
        this.saturationConsumer = saturationConsumer;
    }

    @Override
    public int getXSize() {
        return 100;
    }

    @Override
    public int getYSize() {
        return 80;
    }

    @Override
    public void drawBackgroundLayer(MatrixStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        this.drawTiledGradient(stack, this.getPosX() + guiX, this.getPosY() + guiY, this.getXSize(), this.getYSize());
        AssetUtil.drawAsset(stack, screen, provider.getAsset(AssetTypes.SHADE_PICKER), guiX + (int)((float)this.getPosX() + this.saturation * (float)this.getXSize()) - 4, (int)((float)(guiY + this.getPosY()) + (1.0f - this.brightness) * (float)this.getYSize()) - 4);
    }

    @Override
    public void drawForegroundLayer(MatrixStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY) {
    }

    private void drawTiledGradient(MatrixStack matrix, int x, int y, int width, int height) {
        int tileWidth = Math.round((float)width / 10.0f);
        int tileHeight = Math.round((float)height / 10.0f);
        for (int i = 0; i < 10; ++i) {
            float minV = (float)i / 10.0f;
            float maxV = (float)(i + 1) / 10.0f;
            for (int j = 0; j < 10; ++j) {
                float minS = (float)j / 10.0f;
                float maxS = (float)(j + 1) / 10.0f;
                Color tl = Color.getHSBColor(this.hueSupplier.get().floatValue(), minS, maxV);
                Color tr = Color.getHSBColor(this.hueSupplier.get().floatValue(), maxS, maxV);
                Color bl = Color.getHSBColor(this.hueSupplier.get().floatValue(), minS, minV);
                Color br = Color.getHSBColor(this.hueSupplier.get().floatValue(), maxS, minV);
                this.drawGradient(matrix, x + j * tileWidth, y + (10 - i - 1) * tileHeight, tileWidth, tileHeight, tl, tr, bl, br);
            }
        }
    }

    private void drawGradient(MatrixStack matrix, int x, int y, int width, int height, Color tl, Color tr, Color bl, Color br) {
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_227888_a_(matrix4f, (float)x, (float)(y + height), 0.0f).func_227885_a_((float)bl.getRed() / 255.0f, (float)bl.getGreen() / 255.0f, (float)bl.getBlue() / 255.0f, (float)bl.getAlpha() / 255.0f).func_181675_d();
        buffer.func_227888_a_(matrix4f, (float)(x + width), (float)(y + height), 0.0f).func_227885_a_((float)br.getRed() / 255.0f, (float)br.getGreen() / 255.0f, (float)br.getBlue() / 255.0f, (float)br.getAlpha() / 255.0f).func_181675_d();
        buffer.func_227888_a_(matrix4f, (float)(x + width), (float)y, 0.0f).func_227885_a_((float)tr.getRed() / 255.0f, (float)tr.getGreen() / 255.0f, (float)tr.getBlue() / 255.0f, (float)tr.getAlpha() / 255.0f).func_181675_d();
        buffer.func_227888_a_(matrix4f, (float)x, (float)y, 0.0f).func_227885_a_((float)tl.getRed() / 255.0f, (float)tl.getGreen() / 255.0f, (float)tl.getBlue() / 255.0f, (float)tl.getAlpha() / 255.0f).func_181675_d();
        buffer.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)buffer);
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    @Override
    public void drag(int x, int y) {
        this.saturation = ((float)x - (float)this.getPosX()) / (float)this.getXSize();
        this.brightness = 1.0f - ((float)y - (float)this.getPosY()) / (float)this.getYSize();
        this.saturationConsumer.accept(Float.valueOf(this.saturation));
        this.brightnessConsumer.accept(Float.valueOf(this.brightness));
    }

    @Override
    public void handleClick(Screen screen, int guiX, int guiY, double mouseX, double mouseY, int button) {
        this.saturation = (float)((mouseX - (double)this.getPosX() - (double)guiX) / (double)this.getXSize());
        this.brightness = 1.0f - (float)((mouseY - (double)this.getPosY() - (double)guiY) / (double)this.getYSize());
        this.saturationConsumer.accept(Float.valueOf(this.saturation));
        this.brightnessConsumer.accept(Float.valueOf(this.brightness));
    }

    public void setBrightness(float brightness) {
        this.brightness = brightness;
    }

    public void setSaturation(float saturation) {
        this.saturation = saturation;
    }
}

