/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.json;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.hrznstudio.titanium.json.IJsonProvider;
import com.hrznstudio.titanium.json.jsondirector.IJsonDirector;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
public class JsonLoader<T>
extends JsonReloadListener {
    private final IJsonDirector<T> director;
    private final String type;
    private final Logger logger;
    private final IJsonProvider<T> jsonProvider;

    public JsonLoader(String type, Logger logger, IJsonDirector<T> director, IJsonProvider<T> jsonProvider) {
        super(new Gson(), type);
        this.type = type;
        this.logger = logger;
        this.director = director;
        this.jsonProvider = jsonProvider;
    }

    private ResourceLocation transformRL(ResourceLocation resource) {
        return new ResourceLocation(resource.func_110624_b(), resource.func_110623_a().replace(this.type + "/", ""));
    }

    protected void apply(Map<ResourceLocation, JsonElement> ts, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        this.director.clear();
        ts.entrySet().parallelStream().map(entry -> new Tuple(entry.getKey(), this.jsonProvider.provide((ResourceLocation)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonObject()))).forEach(tuple -> this.director.put((ResourceLocation)tuple.func_76341_a(), tuple.func_76340_b()));
        this.logger.info("Loaded " + ts.size() + " " + this.type);
    }
}

