/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity;

import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.util.FluidQuantity;
import cam72cam.mod.entity.Entity;
import cam72cam.mod.entity.Player;
import cam72cam.mod.fluid.Fluid;
import java.util.ArrayList;
import java.util.List;

public class HandCar
extends Locomotive {
    @Override
    protected int getAvailableHP() {
        int passengers = 0;
        for (Entity passenger : this.getPassengers()) {
            if (!passenger.isPlayer()) continue;
            Player player = passenger.asPlayer();
            if (!player.isCreative()) {
                if (player.getFoodLevel() <= 0) continue;
                ++passengers;
                continue;
            }
            ++passengers;
        }
        return this.getDefinition().getHorsePower(this.gauge) * passengers;
    }

    @Override
    public void onTick() {
        super.onTick();
        if (this.getWorld().isClient) {
            return;
        }
        if (this.getThrottle() != 0.0f && this.getTickCount() % (int)(200.0 * (1.1 - (double)Math.abs(this.getThrottle()))) == 0) {
            for (Entity passenger : this.getPassengers()) {
                Player player;
                if (!passenger.isPlayer() || (player = passenger.asPlayer()).isCreative() || player.getFoodLevel() <= 0) continue;
                player.useFood(1);
            }
        }
    }

    @Override
    public FluidQuantity getTankCapacity() {
        return FluidQuantity.ZERO;
    }

    @Override
    public List<Fluid> getFluidFilter() {
        return new ArrayList<Fluid>();
    }

    @Override
    public int getInventoryWidth() {
        return 2;
    }
}

