/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render.rail;

import cam72cam.immersiverailroading.model.TrackModel;
import cam72cam.immersiverailroading.registry.DefinitionManager;
import cam72cam.immersiverailroading.render.ExpireableList;
import cam72cam.immersiverailroading.render.StockRenderCache;
import cam72cam.immersiverailroading.track.BuilderBase;
import cam72cam.immersiverailroading.util.RailInfo;
import cam72cam.mod.MinecraftClient;
import cam72cam.mod.render.OpenGL;
import cam72cam.mod.render.VBO;
import cam72cam.mod.render.obj.OBJRender;
import cam72cam.mod.render.obj.OBJVBO;
import cam72cam.mod.world.World;
import java.util.List;
import java.util.stream.Collectors;
import util.Matrix4;

public class RailBuilderRender {
    private static final ExpireableList<String, VBO> cache = new ExpireableList<String, VBO>(){

        @Override
        public void onRemove(String key, VBO value) {
            value.free();
        }
    };

    public static void renderRailBuilder(RailInfo info, World world) {
        TrackModel model = DefinitionManager.getTrack(info.settings.track, info.settings.gauge.value());
        if (model == null) {
            return;
        }
        OBJRender trackRenderer = StockRenderCache.getTrackRenderer(model);
        VBO cached = cache.get(info.uniqueID);
        if (cached == null) {
            OBJVBO.Builder builder = trackRenderer.getVBO().subModel();
            for (BuilderBase.VecYawPitch piece : info.getBuilder(world).getRenderData()) {
                Matrix4 m = new Matrix4();
                m.translate(piece.x, piece.y, piece.z);
                m.rotate(Math.toRadians(piece.getYaw()), 0.0, 1.0, 0.0);
                m.rotate(Math.toRadians(piece.getPitch()), 1.0, 0.0, 0.0);
                m.rotate(Math.toRadians(-90.0), 0.0, 1.0, 0.0);
                if (piece.getLength() != -1.0f) {
                    m.scale((double)piece.getLength() / info.settings.gauge.scale(), 1.0, 1.0);
                }
                double scale = info.settings.gauge.scale();
                m.scale(scale, scale, scale);
                if (piece.getGroups().size() != 0) {
                    List groups = trackRenderer.model.groups().stream().filter(group -> piece.getGroups().stream().anyMatch(group::contains)).collect(Collectors.toList());
                    builder.draw(groups, m);
                    continue;
                }
                builder.draw(m);
            }
            cached = builder.build();
            cache.put(info.uniqueID, cached);
        }
        MinecraftClient.startProfiler((String)"irTrackModel");
        OpenGL.With tex = trackRenderer.bindTexture();
        Object object = null;
        try (VBO.BoundVBO vbo = cached.bind();){
            vbo.draw();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (tex != null) {
                if (object != null) {
                    try {
                        tex.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    tex.close();
                }
            }
        }
        MinecraftClient.endProfiler();
    }
}

