/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render.rail;

import cam72cam.immersiverailroading.render.rail.RailBaseOverlayRender;
import cam72cam.immersiverailroading.render.rail.RailBaseRender;
import cam72cam.immersiverailroading.render.rail.RailBuilderRender;
import cam72cam.immersiverailroading.util.RailInfo;
import cam72cam.mod.MinecraftClient;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.render.OpenGL;
import cam72cam.mod.world.World;
import org.lwjgl.opengl.GL11;

public class RailRenderUtil {
    public static void render(RailInfo info, World world, Vec3i pos, boolean renderOverlay) {
        try (OpenGL.With light = OpenGL.bool((int)2896, (boolean)false);){
            if (renderOverlay) {
                try (OpenGL.With matrix = OpenGL.matrix();){
                    Vec3d off = info.placementInfo.placementPosition;
                    off = off.subtract(new Vec3d(new Vec3i(off)));
                    GL11.glTranslated((double)(-off.x), (double)(-off.y), (double)(-off.z));
                    MinecraftClient.startProfiler((String)"base");
                    RailBaseRender.draw(info, world);
                    MinecraftClient.endProfiler();
                    MinecraftClient.startProfiler((String)"overlay");
                    RailBaseOverlayRender.draw(info, world, pos);
                    MinecraftClient.endProfiler();
                }
            }
            MinecraftClient.startProfiler((String)"rail");
            RailBuilderRender.renderRailBuilder(info, world);
            MinecraftClient.endProfiler();
        }
    }
}

