/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render.tile;

import cam72cam.immersiverailroading.render.ExpireableList;
import cam72cam.immersiverailroading.render.rail.RailRenderUtil;
import cam72cam.immersiverailroading.tile.TileRailPreview;
import cam72cam.immersiverailroading.track.BuilderBase;
import cam72cam.immersiverailroading.track.IIterableTrack;
import cam72cam.immersiverailroading.util.RailInfo;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.render.GlobalRender;
import cam72cam.mod.render.OpenGL;
import cam72cam.mod.world.World;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class MultiPreviewRender {
    private static ExpireableList<Pair<World, Vec3i>, TileRailPreview> previews = new ExpireableList();

    private static void render(float partialTicks) {
        try (OpenGL.With transparency = OpenGL.transparency((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);){
            for (TileRailPreview preview : previews.values()) {
                for (BuilderBase builder : ((IIterableTrack)((Object)preview.getRailRenderInfo().getBuilder(preview.getWorld(), preview.isAboveRails() ? preview.getPos().down() : preview.getPos()))).getSubBuilders()) {
                    RailInfo info = builder.info;
                    Vec3d placementPosition = info.placementInfo.placementPosition.add(builder.pos);
                    if (!(GlobalRender.getCameraPos((float)partialTicks).distanceTo(placementPosition) < (double)(GlobalRender.getRenderDistance() + 50))) continue;
                    placementPosition = placementPosition.subtract(GlobalRender.getCameraPos((float)partialTicks));
                    OpenGL.With matrix = OpenGL.matrix();
                    Throwable throwable = null;
                    try {
                        GL11.glTranslated((double)placementPosition.x, (double)placementPosition.y, (double)placementPosition.z);
                        RailRenderUtil.render(info, preview.getWorld(), builder.pos, true);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (matrix == null) continue;
                        if (throwable != null) {
                            try {
                                matrix.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        matrix.close();
                    }
                }
            }
        }
    }

    public static void add(TileRailPreview preview) {
        previews.put((Pair<World, Vec3i>)Pair.of((Object)preview.getWorld(), (Object)preview.getPos()), preview);
    }

    public static void remove(World world, Vec3i removed) {
        previews.put((Pair<World, Vec3i>)Pair.of((Object)world, (Object)removed), null);
    }

    static {
        GlobalRender.registerRender(MultiPreviewRender::render);
    }
}

