/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part;

import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.Log;
import it.zerono.mods.extremereactors.api.IMapping;
import it.zerono.mods.extremereactors.api.reactor.Reactant;
import it.zerono.mods.extremereactors.api.reactor.ReactantMappingsRegistry;
import it.zerono.mods.extremereactors.api.reactor.ReactantType;
import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IFuelSource;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.MultiblockReactor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.ReactantHelper;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.AbstractReactorEntity;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.DebuggableHelper;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.block.INeighborChangeListener;
import it.zerono.mods.zerocore.lib.block.TileCommandDispatcher;
import it.zerono.mods.zerocore.lib.data.IIoEntity;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.data.nbt.IConditionallySyncableEntity;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.data.stack.IStackHolder;
import it.zerono.mods.zerocore.lib.fluid.FluidHelper;
import it.zerono.mods.zerocore.lib.fluid.FluidTank;
import it.zerono.mods.zerocore.lib.fluid.handler.FluidHandlerForwarder;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModTileContainer;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.LogicalSide;

public class ReactorFluidAccessPortEntity
extends AbstractReactorEntity
implements IFuelSource<FluidStack>,
IIoEntity,
INeighborChangeListener,
INamedContainerProvider,
IConditionallySyncableEntity {
    public static int TANK_CAPACITY = 8000;
    @CapabilityInject(value=IFluidHandler.class)
    private static Capability<IFluidHandler> FLUID_HANDLER_CAPABILITY = null;
    private static final ResourceLocation SYNC_DATA_ID = ExtremeReactors.newID("injector");
    private final FluidTank _fuelTank;
    private final FluidTank _wasteTank;
    private final LazyOptional<IFluidHandler> _fuelCapability;
    private final LazyOptional<IFluidHandler> _wasteCapability;
    private IoDirection _direction;
    private boolean _shouldSync;

    public ReactorFluidAccessPortEntity() {
        super((TileEntityType)Content.TileEntityTypes.REACTOR_FLUID_ACCESSPORT.get());
        this.setIoDirection(IoDirection.Input);
        this._fuelTank = (FluidTank)((FluidTank)new FluidTank(TANK_CAPACITY).setOnLoadListener(this::onTankChanged)).setOnContentsChangedListener(this::onTankChanged);
        this._wasteTank = (FluidTank)((FluidTank)new FluidTank(TANK_CAPACITY).setOnLoadListener(this::onTankChanged)).setOnContentsChangedListener(this::onTankChanged);
        this._fuelCapability = LazyOptional.of(this::createFuelCapability);
        this._wasteCapability = LazyOptional.of(this::createWasteCapability);
        this._shouldSync = false;
        this.setCommandDispatcher(TileCommandDispatcher.builder().addServerHandler(CommonConstants.COMMAND_SET_INPUT, tile -> tile.setIoDirection(IoDirection.Input)).addServerHandler(CommonConstants.COMMAND_SET_OUTPUT, tile -> tile.setIoDirection(IoDirection.Output)).addServerHandler(CommonConstants.COMMAND_DUMP_FUEL, ReactorFluidAccessPortEntity::handleCommandEjectFuel).addServerHandler(CommonConstants.COMMAND_DUMP_WASTE, ReactorFluidAccessPortEntity::handleCommandEjectWaste).build((AbstractModBlockEntity)this));
    }

    public IFluidHandler getFluidStackHandler(ReactantType type) {
        return type.isFuel() ? this._fuelTank : this._wasteTank;
    }

    public void onItemsReceived() {
        this.markChunkDirty();
    }

    public static void itemTooltipBuilder(ItemStack stack, CompoundNBT data, @Nullable IBlockReader world, NonNullConsumer<ITextComponent> appender, boolean isAdvancedTooltip) {
        FluidTank tank = new FluidTank(TANK_CAPACITY);
        if (data.func_74764_b("iodir")) {
            appender.accept((Object)new TranslationTextComponent(IoDirection.read((CompoundNBT)data, (String)"iodir", (IoDirection)IoDirection.Input).isInput() ? "gui.bigreactors.reactor.fluidaccessport.directioninput.line1" : "gui.bigreactors.reactor.fluidaccessport.directionoutput.line1").func_230530_a_(CommonConstants.STYLE_TOOLTIP_VALUE));
        }
        if (data.func_74764_b("invin")) {
            tank.syncDataFrom(data.func_74775_l("invin"), ISyncableEntity.SyncReason.FullSync);
            appender.accept((Object)ReactorFluidAccessPortEntity.getTankTooltip(tank, "gui.bigreactors.generic.fuel.label"));
        }
        if (data.func_74764_b("invout")) {
            tank.syncDataFrom(data.func_74775_l("invout"), ISyncableEntity.SyncReason.FullSync);
            appender.accept((Object)ReactorFluidAccessPortEntity.getTankTooltip(tank, "gui.bigreactors.generic.waste.label"));
        }
    }

    private static ITextComponent getTankTooltip(FluidTank tank, String labelKey) {
        TranslationTextComponent text = tank.isEmpty() ? new TranslationTextComponent("gui.bigreactors.generic.empty") : new TranslationTextComponent("gui.bigreactors.reactor.fluidaccessport.item.reactant", new Object[]{FluidHelper.getFluidName((FluidStack)tank.getFluid()), tank.getFluidAmount(), TANK_CAPACITY});
        return new TranslationTextComponent(labelKey).func_230529_a_((ITextComponent)text.func_230530_a_(CommonConstants.STYLE_TOOLTIP_VALUE));
    }

    @Override
    protected int getUpdatedModelVariantIndex() {
        int connectedOffset = this.isMachineAssembled() && this.getNeighborCapability().isPresent() ? 1 : 0;
        return this.getIoDirection().isInput() ? 2 + connectedOffset : 0 + connectedOffset;
    }

    @Override
    public FluidStack getFuelStack() {
        return this.getStack(ReactantType.Fuel);
    }

    @Override
    public FluidStack consumeFuelSource(FluidStack sourceToConsume) {
        FluidStack sourceStack = this.getStack(ReactantType.Fuel);
        if (sourceStack.isEmpty() || sourceToConsume.isEmpty()) {
            return FluidStack.EMPTY;
        }
        return this._fuelTank.drain(sourceToConsume, IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public int emitReactant(Reactant reactant, int amount) {
        int maxOutputAmount = this._wasteTank.getCapacity();
        if (amount <= 0 || maxOutputAmount <= 0) {
            return 0;
        }
        FluidStack outputStack = this.getStack(ReactantType.Waste);
        if (!outputStack.isEmpty() && outputStack.getAmount() >= maxOutputAmount) {
            return 0;
        }
        if (!outputStack.isEmpty()) {
            IMapping mapping = ReactantMappingsRegistry.getFromFluid(outputStack).orElse(null);
            if (null == mapping || !reactant.equals(mapping.getProduct())) {
                return 0;
            }
            int amountToProduce = Math.min(amount, maxOutputAmount - outputStack.getAmount());
            if (amountToProduce <= 0) {
                return 0;
            }
            int filled = this._wasteTank.fill(FluidHelper.stackFrom((FluidStack)outputStack, (int)amountToProduce), IFluidHandler.FluidAction.EXECUTE);
            this.onItemsReceived();
            return filled;
        }
        IMapping bestMapping = ReactantMappingsRegistry.getToFluid(reactant).filter(list -> !list.isEmpty()).map(list -> (IMapping)list.get(0)).orElse(null);
        if (null == bestMapping) {
            Log.LOGGER.warn(Log.REACTOR, "There are no mapped fluid types for reactant {}. Nothing to emit here.", (Object)reactant);
            return 0;
        }
        outputStack = ReactantMappingsRegistry.getFluidStackFrom(bestMapping, Math.min(amount, maxOutputAmount));
        if (outputStack.isEmpty()) {
            Log.LOGGER.warn(Log.REACTOR, "Can't create a stack from tag {}. Nothing to emit here.", bestMapping.getProduct());
            return 0;
        }
        int filled = this._wasteTank.fill(outputStack, IFluidHandler.FluidAction.EXECUTE);
        this.onItemsReceived();
        return filled;
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity player) {
        return ModTileContainer.empty((ContainerType)((ContainerType)Content.ContainerTypes.REACTOR_FLUID_ACCESSPORT.get()), (int)windowId, (AbstractModBlockEntity)this, (ServerPlayerEntity)((ServerPlayerEntity)player));
    }

    public ITextComponent func_145748_c_() {
        return super.getPartDisplayName();
    }

    public IoDirection getIoDirection() {
        return this._direction;
    }

    public void setIoDirection(IoDirection direction) {
        if (this.getIoDirection() == direction) {
            return;
        }
        this._direction = direction;
        this.notifyBlockUpdate();
        this.callOnLogicalSide(() -> {
            this.notifyOutwardNeighborsOfStateChange();
            this.func_70296_d();
        }, this::markForRenderUpdate);
        this.notifyNeighborsOfTileChange();
    }

    public void onNeighborBlockChanged(BlockState state, BlockPos neighborPosition, boolean isMoving) {
        this.requestClientRenderUpdate();
    }

    public void onNeighborTileChanged(BlockState state, BlockPos neighborPosition) {
        this.requestClientRenderUpdate();
    }

    public void syncDataFrom(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        this.setIoDirection(IoDirection.read((CompoundNBT)data, (String)"iodir", (IoDirection)IoDirection.Input));
        this.syncChildDataEntityFrom((ISyncableEntity)this._fuelTank, "invin", data, syncReason);
        this.syncChildDataEntityFrom((ISyncableEntity)this._wasteTank, "invout", data, syncReason);
        if (syncReason.isFullSync()) {
            this._shouldSync = true;
        }
    }

    public CompoundNBT syncDataTo(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        IoDirection.write((CompoundNBT)data, (String)"iodir", (IoDirection)this.getIoDirection());
        this.syncChildDataEntityTo((ISyncableEntity)this._fuelTank, "invin", data, syncReason);
        this.syncChildDataEntityTo((ISyncableEntity)this._wasteTank, "invout", data, syncReason);
        return data;
    }

    public ResourceLocation getSyncableEntityId() {
        return SYNC_DATA_ID;
    }

    public boolean shouldSyncEntity() {
        boolean result = this._shouldSync;
        this._shouldSync = false;
        return result;
    }

    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        super.getDebugMessages(side, messages);
        this.getIoDirection().getDebugMessages(side, messages);
        messages.add((Object)this.getFluidStackHandler(ReactantType.Fuel), DebuggableHelper::getDebugMessagesFor, "Fuel");
        messages.add((Object)this.getFluidStackHandler(ReactantType.Waste), DebuggableHelper::getDebugMessagesFor, "Waste");
    }

    public boolean canOpenGui(World world, BlockPos position, BlockState state) {
        return true;
    }

    @Override
    public void onPostMachineAssembled(MultiblockReactor controller) {
        super.onPostMachineAssembled(controller);
        this.listenForControllerDataUpdates();
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (!this.func_145837_r() && FLUID_HANDLER_CAPABILITY == capability) {
            if (this.getIoDirection().isInput()) {
                return this._fuelCapability.cast();
            }
            return this._wasteCapability.cast();
        }
        return super.getCapability(capability, side);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this._fuelCapability.invalidate();
        this._wasteCapability.invalidate();
    }

    private FluidStack getStack(ReactantType type) {
        return this.getFluidStackHandler(type).getFluidInTank(0);
    }

    private LazyOptional<IFluidHandler> getNeighborCapability() {
        return CodeHelper.optionalFlatMap((Optional)this.getPartWorld(), (Optional)this.getOutwardDirection(), (world, direction) -> WorldHelper.getTile((World)world, (BlockPos)this.getWorldPosition().func_177972_a(direction)).map(te -> te.getCapability(FLUID_HANDLER_CAPABILITY, direction.func_176734_d()))).orElse(LazyOptional.empty());
    }

    @Nonnull
    private IFluidHandler createFuelCapability() {
        return new FluidHandlerForwarder(this.getFluidStackHandler(ReactantType.Fuel)){

            public int fill(FluidStack stack, IFluidHandler.FluidAction action) {
                return this.isFluidValid(0, stack) ? super.fill(stack, action) : 0;
            }

            public boolean isFluidValid(int tank, FluidStack stack) {
                return ReactantHelper.isValidSource(ReactantType.Fuel, stack);
            }
        };
    }

    @Nonnull
    private IFluidHandler createWasteCapability() {
        return new FluidHandlerForwarder(this.getFluidStackHandler(ReactantType.Waste)){

            public int fill(FluidStack stack, IFluidHandler.FluidAction action) {
                return 0;
            }

            public boolean isFluidValid(int tank, FluidStack stack) {
                return false;
            }
        };
    }

    private void onTankChanged(IStackHolder.ChangeType changeType, int slot) {
        this.onTankChanged();
    }

    private void onTankChanged() {
        this.func_70296_d();
        this._shouldSync = true;
    }

    private void handleCommandEjectFuel(CompoundNBT options) {
        this.getMultiblockController().ifPresent(c -> c.ejectFuel(options.func_74764_b("void") && options.func_74767_n("void")));
    }

    private void handleCommandEjectWaste(CompoundNBT options) {
        this.getMultiblockController().ifPresent(c -> c.ejectWaste(options.func_74764_b("void") && options.func_74767_n("void")));
    }
}

