/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.rotor;

import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.rotor.RotorShaftState;
import it.zerono.mods.zerocore.lib.CodeHelper;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;

public enum RotorBladeState implements IStringSerializable
{
    HIDDEN,
    Y_X_POS,
    Y_X_NEG,
    Y_Z_POS,
    Y_Z_NEG,
    X_Y_POS,
    X_Y_NEG,
    X_Z_POS,
    X_Z_NEG,
    Z_Y_POS,
    Z_Y_NEG,
    Z_X_POS,
    Z_X_NEG;

    public static RotorBladeState[] VALUES;
    private static final Map<String, RotorBladeState> NAME_LOOKUP;
    private final String _name = CodeHelper.neutralLowercase((String)this.name());

    public static RotorBladeState getDefault() {
        return Z_X_POS;
    }

    public static RotorBladeState from(String name) {
        return NAME_LOOKUP.getOrDefault(CodeHelper.neutralLowercase((String)name), HIDDEN);
    }

    public static RotorBladeState from(RotorShaftState shaftState, Direction bladeDirection) {
        String name;
        switch (shaftState.getAxis()) {
            case X: {
                name = "x_" + bladeDirection.func_176740_k().func_176610_l() + (bladeDirection.func_176743_c() == Direction.AxisDirection.POSITIVE ? "_neg" : "_pos");
                break;
            }
            case Y: {
                name = "y_" + bladeDirection.func_176740_k().func_176610_l() + (bladeDirection.func_176743_c() == Direction.AxisDirection.POSITIVE ? "_neg" : "_pos");
                break;
            }
            case Z: {
                name = "z_" + bladeDirection.func_176740_k().func_176610_l() + (bladeDirection.func_176743_c() == Direction.AxisDirection.POSITIVE ? "_neg" : "_pos");
                break;
            }
            default: {
                name = shaftState.func_176610_l() + (bladeDirection.func_176734_d().func_176743_c() == Direction.AxisDirection.POSITIVE ? "_pos" : "_neg");
            }
        }
        return RotorBladeState.from(name);
    }

    public String func_176610_l() {
        return this._name;
    }

    public String toString() {
        return this.func_176610_l();
    }

    static {
        VALUES = RotorBladeState.values();
        NAME_LOOKUP = Arrays.stream(RotorBladeState.values()).collect(Collectors.toMap(RotorBladeState::func_176610_l, state -> state));
    }
}

