/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.multiblock.part.io.power.charging;

import it.zerono.mods.zerocore.base.multiblock.part.AbstractMultiblockEntity;
import it.zerono.mods.zerocore.base.multiblock.part.io.power.charging.AbstractChargingPortHandler;
import it.zerono.mods.zerocore.base.multiblock.part.io.power.charging.IChargingPort;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class ChargingPortHandlerForgeEnergy<Controller extends AbstractCuboidMultiblockController<Controller>, T extends AbstractMultiblockEntity<Controller> & IChargingPort>
extends AbstractChargingPortHandler<Controller, T> {
    @CapabilityInject(value=IEnergyStorage.class)
    private static Capability<IEnergyStorage> CAPAP_FORGE_ENERGYSTORAGE = null;

    public ChargingPortHandlerForgeEnergy(T part, int inputSlotsCount, int outputSlotsCount) {
        super(EnergySystem.ForgeEnergy, part, inputSlotsCount, outputSlotsCount);
    }

    @Override
    public WideAmount outputEnergy(WideAmount amount) {
        WideAmount maxTransfer = this.getChargingRate();
        if (amount.isZero() || maxTransfer.isZero()) {
            return WideAmount.ZERO;
        }
        WideAmount remaining = amount.copy();
        WideAmount accepted = WideAmount.ZERO;
        for (int idx = 0; idx < this.getInputSlotsCount(); ++idx) {
            WideAmount transfer = WideAmount.min(remaining, maxTransfer);
            LazyOptional<IEnergyStorage> cap = this.getCapabilityFromInventory(CAPAP_FORGE_ENERGYSTORAGE, idx, true);
            if (!cap.isPresent()) continue;
            int transferred = (Integer)cap.map(c -> ChargingPortHandlerForgeEnergy.recharge(c, transfer)).orElseThrow(IllegalStateException::new);
            if (0 == transferred) {
                this.eject(idx);
            }
            accepted = accepted.add(transfer);
            if ((remaining = remaining.subtract(transfer)).isZero()) break;
        }
        return accepted;
    }

    private static int recharge(IEnergyStorage cap, WideAmount energyAmount) {
        return cap.canReceive() ? cap.receiveEnergy(energyAmount.intValue(), false) : 0;
    }
}

