/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.block;

import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.block.property.BlockFacingsProperty;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

public final class BlockFacings {
    public static final BlockFacings NONE;
    public static final BlockFacings ALL;
    public static final BlockFacings DOWN;
    public static final BlockFacings UP;
    public static final BlockFacings NORTH;
    public static final BlockFacings SOUTH;
    public static final BlockFacings WEST;
    public static final BlockFacings EAST;
    public static final BlockFacings VERTICAL;
    public static final BlockFacings HORIZONTAL;
    public static final BlockFacings AXIS_X;
    public static final BlockFacings AXIS_Y;
    public static final BlockFacings AXIS_Z;
    public static final BooleanProperty FACING_DOWN;
    public static final BooleanProperty FACING_UP;
    public static final BooleanProperty FACING_WEST;
    public static final BooleanProperty FACING_EAST;
    public static final BooleanProperty FACING_NORTH;
    public static final BooleanProperty FACING_SOUTH;
    private final byte _value;
    private static final BlockFacings[] s_cache;

    public byte value() {
        return this._value;
    }

    public boolean isSet(Direction facing) {
        return 0 != (this._value & 1 << facing.func_176745_a());
    }

    public boolean except(Direction facing) {
        return this.any() && !this.isSet(facing);
    }

    public boolean none() {
        return 0 == this._value;
    }

    public boolean any() {
        return 0 != this._value;
    }

    public boolean one() {
        return 1 == this.countFacesIf(true);
    }

    public boolean some() {
        return 0 != this._value;
    }

    public boolean all() {
        return 63 == this._value;
    }

    public boolean down() {
        return this.isSet(Direction.DOWN);
    }

    public boolean up() {
        return this.isSet(Direction.UP);
    }

    public boolean north() {
        return this.isSet(Direction.NORTH);
    }

    public boolean south() {
        return this.isSet(Direction.SOUTH);
    }

    public boolean west() {
        return this.isSet(Direction.WEST);
    }

    public boolean east() {
        return this.isSet(Direction.EAST);
    }

    public void ifSet(Direction facing, Runnable task) {
        if (this.isSet(facing)) {
            task.run();
        }
    }

    public void ifNotSet(Direction facing, Runnable task) {
        if (!this.isSet(facing)) {
            task.run();
        }
    }

    public void ifSet(Direction facing, Consumer<Direction> consumer) {
        if (this.isSet(facing)) {
            consumer.accept(facing);
        }
    }

    public void ifNotSet(Direction facing, Consumer<Direction> consumer) {
        if (!this.isSet(facing)) {
            consumer.accept(facing);
        }
    }

    public BlockState toBlockState(BlockState state) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)FACING_DOWN, (Comparable)Boolean.valueOf(this.isSet(Direction.DOWN)))).func_206870_a((Property)FACING_UP, (Comparable)Boolean.valueOf(this.isSet(Direction.UP)))).func_206870_a((Property)FACING_WEST, (Comparable)Boolean.valueOf(this.isSet(Direction.WEST)))).func_206870_a((Property)FACING_EAST, (Comparable)Boolean.valueOf(this.isSet(Direction.EAST)))).func_206870_a((Property)FACING_NORTH, (Comparable)Boolean.valueOf(this.isSet(Direction.NORTH)))).func_206870_a((Property)FACING_SOUTH, (Comparable)Boolean.valueOf(this.isSet(Direction.SOUTH)));
    }

    public BlockFacings set(Direction facing, boolean value) {
        byte newHash = this._value;
        newHash = value ? (byte)(newHash | 1 << facing.func_176745_a()) : (byte)(newHash & ~(1 << facing.func_176745_a()));
        return BlockFacings.from(newHash);
    }

    public int countFacesIf(boolean areSet) {
        int checkFor = areSet ? 1 : 0;
        int mask = this._value;
        int faces = 0;
        int i = 0;
        while (i < 6) {
            if ((mask & 1) == checkFor) {
                ++faces;
            }
            ++i;
            mask >>>= 1;
        }
        return faces;
    }

    public BlockFacingsProperty toProperty() {
        for (BlockFacingsProperty value : BlockFacingsProperty.values()) {
            if (value.getHash() != this._value) continue;
            return value;
        }
        return BlockFacingsProperty.None;
    }

    public BlockPos offsetBlockPos(BlockPos originalPosition) {
        int x = 0;
        int y = 0;
        int z = 0;
        for (Direction facing : CodeHelper.DIRECTIONS) {
            if (!this.isSet(facing)) continue;
            x += facing.func_82601_c();
            y += facing.func_96559_d();
            z += facing.func_82599_e();
        }
        return originalPosition.func_177982_a(x, y, z);
    }

    public Optional<Direction> firstIf(boolean isSet) {
        for (Direction facing : CodeHelper.DIRECTIONS) {
            if (isSet != this.isSet(facing)) continue;
            return Optional.of(facing);
        }
        return Optional.empty();
    }

    public Stream<Direction> stream() {
        return Arrays.stream(CodeHelper.DIRECTIONS).filter(this::isSet);
    }

    public static BlockFacings from(boolean down, boolean up, boolean north, boolean south, boolean west, boolean east) {
        return BlockFacings.from(BlockFacings.computeHash(down, up, north, south, west, east));
    }

    public static BlockFacings from(Direction ... directions) {
        boolean[] facings = new boolean[]{false, false, false, false, false, false};
        for (Direction direction : directions) {
            facings[direction.ordinal()] = true;
        }
        return BlockFacings.from(facings);
    }

    public static BlockFacings from(boolean[] facings) {
        return BlockFacings.from(BlockFacings.computeHash(facings));
    }

    public static BlockFacings from(Direction.Axis axis) {
        switch (axis) {
            default: {
                return AXIS_X;
            }
            case Y: {
                return AXIS_Y;
            }
            case Z: 
        }
        return AXIS_Z;
    }

    public static BlockFacings from(Direction.Plane plane) {
        switch (plane) {
            default: {
                return VERTICAL;
            }
            case HORIZONTAL: 
        }
        return HORIZONTAL;
    }

    static BlockFacings from(byte hash) {
        BlockFacings facings = s_cache[hash];
        if (null == facings) {
            BlockFacings.s_cache[hash] = new BlockFacings(hash);
            return BlockFacings.s_cache[hash];
        }
        return facings;
    }

    public static byte computeHash(boolean down, boolean up, boolean north, boolean south, boolean west, boolean east) {
        byte hash = 0;
        if (down) {
            hash = (byte)(hash | 1 << Direction.DOWN.func_176745_a());
        }
        if (up) {
            hash = (byte)(hash | 1 << Direction.UP.func_176745_a());
        }
        if (north) {
            hash = (byte)(hash | 1 << Direction.NORTH.func_176745_a());
        }
        if (south) {
            hash = (byte)(hash | 1 << Direction.SOUTH.func_176745_a());
        }
        if (west) {
            hash = (byte)(hash | 1 << Direction.WEST.func_176745_a());
        }
        if (east) {
            hash = (byte)(hash | 1 << Direction.EAST.func_176745_a());
        }
        return hash;
    }

    public String toString() {
        return NONE == this ? "Facings: NONE" : String.format("Facings: %s%s%s%s%s%s", this.isSet(Direction.DOWN) ? "DOWN " : "", this.isSet(Direction.UP) ? "UP " : "", this.isSet(Direction.NORTH) ? "NORTH " : "", this.isSet(Direction.SOUTH) ? "SOUTH " : "", this.isSet(Direction.WEST) ? "WEST " : "", this.isSet(Direction.EAST) ? "EAST " : "");
    }

    public int hashCode() {
        return this._value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BlockFacings) {
            return this._value == ((BlockFacings)o)._value;
        }
        return false;
    }

    private BlockFacings(byte value) {
        this._value = value;
    }

    static byte computeHash(boolean[] facings) {
        byte hash = 0;
        int len = facings.length;
        if (len > CodeHelper.DIRECTIONS.length) {
            throw new IllegalArgumentException("Invalid length of facings array");
        }
        for (int i = 0; i < len; ++i) {
            if (!facings[i]) continue;
            hash = (byte)(hash | 1 << i);
        }
        return hash;
    }

    static {
        FACING_DOWN = BooleanProperty.func_177716_a((String)"downFacing");
        FACING_UP = BooleanProperty.func_177716_a((String)"upFacing");
        FACING_WEST = BooleanProperty.func_177716_a((String)"westFacing");
        FACING_EAST = BooleanProperty.func_177716_a((String)"eastFacing");
        FACING_NORTH = BooleanProperty.func_177716_a((String)"northFacing");
        FACING_SOUTH = BooleanProperty.func_177716_a((String)"southFacing");
        s_cache = new BlockFacings[256];
        byte hash = BlockFacings.computeHash(false, false, false, false, false, false);
        BlockFacings.s_cache[hash] = NONE = new BlockFacings(hash);
        hash = BlockFacings.computeHash(true, true, true, true, true, true);
        BlockFacings.s_cache[hash] = ALL = new BlockFacings(hash);
        hash = BlockFacings.computeHash(true, false, false, false, false, false);
        BlockFacings.s_cache[hash] = DOWN = new BlockFacings(hash);
        hash = BlockFacings.computeHash(false, true, false, false, false, false);
        BlockFacings.s_cache[hash] = UP = new BlockFacings(hash);
        hash = BlockFacings.computeHash(false, false, true, false, false, false);
        BlockFacings.s_cache[hash] = NORTH = new BlockFacings(hash);
        hash = BlockFacings.computeHash(false, false, false, true, false, false);
        BlockFacings.s_cache[hash] = SOUTH = new BlockFacings(hash);
        hash = BlockFacings.computeHash(false, false, false, false, true, false);
        BlockFacings.s_cache[hash] = WEST = new BlockFacings(hash);
        hash = BlockFacings.computeHash(false, false, false, false, false, true);
        BlockFacings.s_cache[hash] = EAST = new BlockFacings(hash);
        hash = BlockFacings.computeHash(true, true, false, false, false, false);
        BlockFacings.s_cache[hash] = VERTICAL = new BlockFacings(hash);
        hash = BlockFacings.computeHash(false, false, true, true, true, true);
        BlockFacings.s_cache[hash] = HORIZONTAL = new BlockFacings(hash);
        hash = BlockFacings.computeHash(false, false, false, false, true, true);
        BlockFacings.s_cache[hash] = AXIS_X = new BlockFacings(hash);
        hash = BlockFacings.computeHash(false, false, true, true, false, false);
        BlockFacings.s_cache[hash] = AXIS_Z = new BlockFacings(hash);
        AXIS_Y = VERTICAL;
    }
}

