/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.compat.patchouli.component.standardpage;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.zerono.mods.zerocore.lib.compat.patchouli.Patchouli;
import it.zerono.mods.zerocore.lib.compat.patchouli.component.standardpage.AbstractStandardPageComponent;
import java.util.Random;
import java.util.function.UnaryOperator;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.IModelData;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.BookPage;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.page.PageEmpty;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.multiblock.AbstractMultiblock;
import vazkii.patchouli.common.multiblock.MultiblockRegistry;

public class Multiblock
extends AbstractStandardPageComponent<PageEmpty> {
    String name = "";
    @SerializedName(value="multiblock_id")
    String multiblockId;
    private transient Book book;
    private transient GuiBookEntry parent;
    private transient AbstractMultiblock multiblockObj;
    public transient Minecraft mc;
    private static final Random RAND = new Random();

    protected Multiblock() {
        super(new PageEmpty());
    }

    public void onVariablesAvailable(UnaryOperator<IVariable> lookup) {
        super.onVariablesAvailable(lookup);
        this.multiblockId = ((IVariable)lookup.apply(IVariable.wrap((String)this.multiblockId))).asString();
    }

    @Override
    public void build(BookPage page, BookEntry entry, int pageNum) {
        IMultiblock mb;
        this.book = page.book;
        if (this.multiblockId != null && (mb = (IMultiblock)MultiblockRegistry.MULTIBLOCKS.get(new ResourceLocation(this.multiblockId))) instanceof AbstractMultiblock) {
            this.multiblockObj = (AbstractMultiblock)mb;
        }
        if (this.multiblockObj == null) {
            throw new IllegalArgumentException("No multiblock located for " + this.multiblockId);
        }
    }

    @Override
    public void onDisplayed(BookPage page, GuiBookEntry parent, int left, int top) {
        this.parent = parent;
        this.mc = parent.getMinecraft();
    }

    @Override
    public boolean mouseScrolled(BookPage page, double mouseX, double mouseY, int mouseButton) {
        return false;
    }

    @Override
    protected void renderPage(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        int x = 5;
        int y = 7;
        RenderSystem.enableBlend();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        GuiBook.drawFromTexture((MatrixStack)ms, (Book)this.book, (int)x, (int)y, (int)405, (int)149, (int)106, (int)106);
        this.parent.drawCenteredStringNoShadow(ms, this.name, 58, 0, this.book.headerColor);
        if (this.multiblockObj != null) {
            this.renderMultiblock(ms);
        }
    }

    private void renderMultiblock(MatrixStack ms) {
        this.multiblockObj.setWorld((World)this.mc.field_71441_e);
        Vector3i size = this.multiblockObj.getSize();
        int sizeX = size.func_177958_n();
        int sizeY = size.func_177956_o();
        int sizeZ = size.func_177952_p();
        float maxX = 90.0f;
        float maxY = 90.0f;
        float diag = (float)Math.sqrt(sizeX * sizeX + sizeZ * sizeZ);
        float scaleX = maxX / diag;
        float scaleY = maxY / (float)sizeY;
        float scale = -Math.min(scaleX, scaleY);
        int xPos = 58;
        int yPos = 60;
        ms.func_227860_a_();
        ms.func_227861_a_((double)xPos, (double)yPos, 100.0);
        ms.func_227862_a_(scale, scale, scale);
        ms.func_227861_a_((double)(-((float)sizeX) / 2.0f), (double)(-((float)sizeY) / 2.0f), 0.0);
        Vector4f eye = new Vector4f(0.0f, 0.0f, -100.0f, 1.0f);
        Matrix4f rotMat = new Matrix4f();
        rotMat.func_226591_a_();
        ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-30.0f));
        rotMat.func_226596_a_(Vector3f.field_229179_b_.func_229187_a_(30.0f));
        float offX = (float)(-sizeX) / 2.0f;
        float offZ = (float)(-sizeZ) / 2.0f + 1.0f;
        float time = (float)this.parent.ticksInBook * 0.5f;
        if (!Screen.func_231173_s_()) {
            time += ClientTicker.partialTicks;
        }
        ms.func_227861_a_((double)(-offX), 0.0, (double)(-offZ));
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(time));
        rotMat.func_226596_a_(Vector3f.field_229181_d_.func_229187_a_(-time));
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(45.0f));
        rotMat.func_226596_a_(Vector3f.field_229181_d_.func_229187_a_(-45.0f));
        ms.func_227861_a_((double)offX, 0.0, (double)offZ);
        eye.func_229372_a_(rotMat);
        eye.func_229374_e_();
        this.renderElements(ms, this.multiblockObj, BlockPos.func_218278_a((BlockPos)BlockPos.field_177992_a, (BlockPos)new BlockPos(sizeX - 1, sizeY - 1, sizeZ - 1)), eye);
        ms.func_227865_b_();
    }

    private void renderElements(MatrixStack ms, AbstractMultiblock mb, Iterable<? extends BlockPos> blocks, Vector4f eye) {
        ms.func_227860_a_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ms.func_227861_a_(0.0, 0.0, -1.0);
        IRenderTypeBuffer.Impl buffers = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        this.doWorldRenderPass(ms, mb, blocks, buffers, eye);
        buffers.func_228461_a_();
        ms.func_227865_b_();
    }

    private void doWorldRenderPass(MatrixStack ms, AbstractMultiblock mb, Iterable<? extends BlockPos> blocks, IRenderTypeBuffer.Impl buffers, Vector4f eye) {
        for (BlockPos blockPos : blocks) {
            BlockState bs = mb.func_180495_p(blockPos);
            BlockState renderBlockState = Patchouli.getRenderBlockStateFor((IMultiblock)mb, bs);
            IModelData renderModelData = Patchouli.getModelDataFor((IMultiblock)mb, bs);
            ms.func_227860_a_();
            ms.func_227861_a_((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p());
            for (RenderType layer : RenderType.func_228661_n_()) {
                if (!RenderTypeLookup.canRenderInLayer((BlockState)renderBlockState, (RenderType)layer)) continue;
                ForgeHooksClient.setRenderLayer((RenderType)layer);
                IVertexBuilder buffer = buffers.getBuffer(layer);
                Minecraft.func_71410_x().func_175602_ab().renderModel(renderBlockState, blockPos, (IBlockDisplayReader)mb, ms, buffer, false, RAND, renderModelData);
                ForgeHooksClient.setRenderLayer(null);
            }
            ms.func_227865_b_();
        }
    }
}

