/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory;

import it.zerono.mods.zerocore.lib.DebuggableHelper;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.IDebuggable;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.data.stack.AbstractStackHolder;
import it.zerono.mods.zerocore.lib.data.stack.IStackHolder;
import it.zerono.mods.zerocore.lib.data.stack.IStackHolderAccess;
import it.zerono.mods.zerocore.lib.data.stack.StackAdapters;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemStackHolder
extends AbstractStackHolder<ItemStackHolder, ItemStack>
implements IStackHolderAccess<ItemStackHolder, ItemStack>,
IItemHandler,
IItemHandlerModifiable,
INBTSerializable<CompoundNBT>,
ISyncableEntity,
IDebuggable {
    protected NonNullList<ItemStack> _stacks;

    public ItemStackHolder(int size) {
        this((NonNullList<ItemStack>)NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a));
    }

    public ItemStackHolder(int size, BiPredicate<Integer, ItemStack> stackValidator) {
        this((NonNullList<ItemStack>)NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a), stackValidator);
    }

    public ItemStackHolder(NonNullList<ItemStack> stacks) {
        this._stacks = stacks;
        this.setMaxCapacity(this::getSlotMaxCapacityFromStack);
    }

    public ItemStackHolder(NonNullList<ItemStack> stacks, BiPredicate<Integer, ItemStack> stackValidator) {
        super(stackValidator);
        this._stacks = stacks;
        this.setMaxCapacity(this::getSlotMaxCapacityFromStack);
    }

    public void setSize(int size) {
        this._stacks = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
    }

    @Override
    public boolean isEmpty(int index) {
        return this.getStackInSlot(index).func_190926_b();
    }

    @Override
    public int getAmount(int index) {
        return this.getStackInSlot(index).func_190916_E();
    }

    @Override
    public ItemStack getStackAt(int index) {
        return this.getStackInSlot(index);
    }

    @Override
    public void setStackAt(int index, ItemStack stack) {
        this.setStackInSlot(index, stack);
    }

    public int getSlots() {
        return this._stacks.size();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return (ItemStack)this._stacks.get(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this._stacks.get(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing.func_190926_b()) {
                this._stacks.set(slot, (Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack));
                this.onChange(IStackHolder.ChangeType.Added, slot);
            } else {
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
                this.onChange(IStackHolder.ChangeType.Grown, slot);
            }
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (0 == amount) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this._stacks.get(slot);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                this._stacks.set(slot, (Object)ItemStack.field_190927_a);
                this.onChange(IStackHolder.ChangeType.Removed, slot);
                return existing;
            }
            return existing.func_77946_l();
        }
        if (!simulate) {
            this._stacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)));
            this.onChange(IStackHolder.ChangeType.Shrunk, slot);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public int getSlotLimit(int slot) {
        return this.getMaxCapacity(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.isStackValid(slot, stack);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.validateSlotIndex(slot);
        boolean wasEmpty = this.isEmpty(slot);
        boolean isNowEmpty = stack.func_190926_b();
        if (wasEmpty && isNowEmpty) {
            return;
        }
        this._stacks.set(slot, (Object)stack);
        this.onChange(wasEmpty ? IStackHolder.ChangeType.Added : (isNowEmpty ? IStackHolder.ChangeType.Removed : IStackHolder.ChangeType.Replaced), slot);
    }

    public CompoundNBT serializeNBT() {
        return this.syncDataTo(new CompoundNBT(), ISyncableEntity.SyncReason.FullSync);
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.syncDataFrom(nbt, ISyncableEntity.SyncReason.FullSync);
    }

    @Override
    public void syncDataFrom(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        this.syncFrom(data, StackAdapters.ITEMSTACK, size -> {
            if (size > 0) {
                this.setSize(size);
            }
            return this._stacks;
        });
    }

    @Override
    public CompoundNBT syncDataTo(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        return this.syncTo(data, this._stacks, StackAdapters.ITEMSTACK);
    }

    @Override
    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        DebuggableHelper.getDebugMessagesFor(messages, this);
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this._stacks.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this._stacks.size() + ")");
        }
    }

    protected int getStackLimit(int slot, ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.func_77976_d());
    }

    private int getSlotMaxCapacityFromStack(int slot) {
        return this.getStackAt(slot).func_77976_d();
    }
}

