/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.internal.network.Network;
import it.zerono.mods.zerocore.lib.data.nbt.IConditionallySyncableEntity;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.event.Event;
import it.zerono.mods.zerocore.lib.event.IEvent;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import it.zerono.mods.zerocore.lib.item.inventory.PlayerInventoryUsage;
import it.zerono.mods.zerocore.lib.item.inventory.container.ContainerFactory;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import it.zerono.mods.zerocore.lib.item.inventory.container.slot.SlotFactory;
import it.zerono.mods.zerocore.lib.item.inventory.container.slot.SlotIndexSet;
import it.zerono.mods.zerocore.lib.item.inventory.container.slot.SlotTemplate;
import it.zerono.mods.zerocore.lib.item.inventory.container.slot.type.SlotGeneric;
import it.zerono.mods.zerocore.lib.item.inventory.container.slot.type.SlotType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;

public class ModContainer
extends Container
implements IContainerData {
    public static final String INVENTORYNAME_PLAYER_INVENTORY = "playerinventory";
    public static final String INVENTORY_CONTAINER = "container";
    public static final String SLOTGROUPNAME_PLAYER_INVENTORY = "playerinventory_main";
    public static final String SLOTGROUPNAME_PLAYER_HOTBAR = "playerinventory_hotbar";
    private final ContainerFactory _factory;
    private final Map<String, IItemHandler> _registeredInventories;
    private final Map<String, List<Slot>> _inventorySlotsGroups;
    private IEvent<Runnable> _dataUpdateEvent;
    private IConditionallySyncableEntity _syncableEntity;
    private List<ServerPlayerEntity> _dataUpdateListeners;
    private ObjectList<IContainerData> _dataToSync;

    public ModContainer(ContainerFactory factory, ContainerType<?> type, int windowId) {
        super(type, windowId);
        this._factory = factory;
        this._registeredInventories = Maps.newHashMap();
        this._inventorySlotsGroups = Maps.newHashMap();
    }

    public static ModContainer empty(ContainerType<?> type, int windowId) {
        return new ModContainer(ContainerFactory.EMPTY, (ContainerType)type, windowId){

            public void func_75141_a(int slotID, ItemStack stack) {
            }
        };
    }

    public Optional<IItemHandler> getInventory(String name) {
        return Optional.ofNullable(this._registeredInventories.get(name));
    }

    public void addInventory(String name, IItemHandler inventory) {
        this._registeredInventories.put(name, inventory);
    }

    public void addInventory(String name, IInventory inventory) {
        this.addInventory(name, (IItemHandler)new InvWrapper(inventory));
    }

    public void addInventory(String name, PlayerInventory inventory) {
        this.addInventory(name, (IItemHandler)new PlayerInvWrapper(inventory));
    }

    public void addContainerData(IContainerData data) {
        if (null == this._dataToSync) {
            this._dataToSync = new ObjectArrayList(4);
        }
        if (Short.MAX_VALUE == this._dataToSync.size()) {
            throw new IllegalStateException("Too many container data object added!");
        }
        this._dataToSync.add((Object)data);
    }

    public Runnable subscribeContainerDataUpdate(Runnable handler) {
        if (null == this._dataUpdateEvent) {
            this._dataUpdateEvent = new Event<Runnable>();
        }
        return this._dataUpdateEvent.subscribe(handler);
    }

    public void unsubscribeContainerDataUpdate(Runnable handler) {
        if (null != this._dataUpdateEvent) {
            this._dataUpdateEvent.unsubscribe(handler);
        }
    }

    public void createSlots() {
        for (SlotFactory slotFactory : this._factory.getSlots()) {
            String inventoryName = slotFactory.getInventoryName();
            this.getInventory(inventoryName).ifPresent(inventory -> this.addSlotFor(slotFactory, (IItemHandler)inventory));
        }
    }

    public List<Slot> getInventorySlotsGroup(String inventoryGroupName) {
        if (this._inventorySlotsGroups.containsKey(inventoryGroupName)) {
            return Collections.unmodifiableList(this._inventorySlotsGroups.get(inventoryGroupName));
        }
        return Collections.emptyList();
    }

    public PlayerInventoryUsage getPlayPlayerInventoryUsage() {
        return this._factory.getPlayPlayerInventoryUsage();
    }

    public void syncFrom(@Nullable IConditionallySyncableEntity entity) {
        this._syncableEntity = entity;
    }

    public void onContainerDataSync(CompoundNBT data) {
        if (null != this._syncableEntity && this._syncableEntity.getSyncableEntityId().equals((Object)new ResourceLocation(data.func_74779_i("id")))) {
            this._syncableEntity.syncDataFrom(data.func_74775_l("payload"), ISyncableEntity.SyncReason.NetworkUpdate);
        }
    }

    @Override
    @Nullable
    public NonNullConsumer<PacketBuffer> getContainerDataWriter() {
        return buffer -> {
            buffer.writeInt(this.field_75152_c);
            if (null != this._dataToSync && !this._dataToSync.isEmpty()) {
                for (int idx = 0; idx < this._dataToSync.size(); ++idx) {
                    NonNullConsumer<PacketBuffer> writer = ((IContainerData)this._dataToSync.get(idx)).getContainerDataWriter();
                    if (null == writer) continue;
                    buffer.writeShort(idx);
                    writer.accept(buffer);
                }
            }
            buffer.writeShort(-1);
        };
    }

    @Override
    public void readContainerData(PacketBuffer dataSource) {
        if (this.field_75152_c == dataSource.readInt() && null != this._dataToSync && !this._dataToSync.isEmpty()) {
            short idx;
            while (-1 != (idx = dataSource.readShort())) {
                ((IContainerData)this._dataToSync.get((int)idx)).readContainerData(dataSource);
            }
            if (null != this._dataUpdateEvent) {
                this._dataUpdateEvent.raise(Runnable::run);
            }
        }
    }

    public boolean func_75145_c(PlayerEntity player) {
        return true;
    }

    protected boolean func_75135_a(ItemStack sourceStack, int startIndex, int endIndex, boolean reverseDirection) {
        Slot targetSlot;
        int targetSlotIndex;
        if (sourceStack.func_190926_b() || !this._factory.isIndexValid(startIndex) || !this._factory.isIndexValid(endIndex - 1)) {
            return false;
        }
        int targetSlotIndexModifier = reverseDirection ? -1 : 1;
        int n = targetSlotIndex = reverseDirection ? endIndex - 1 : startIndex;
        if (sourceStack.func_77985_e()) {
            while (sourceStack.func_190916_E() > 0 && (!reverseDirection && targetSlotIndex < endIndex || reverseDirection && targetSlotIndex >= startIndex)) {
                targetSlot = this.func_75139_a(targetSlotIndex);
                ItemStack targetItemStack = targetSlot.func_75211_c();
                if (!targetItemStack.func_190926_b() && ItemHelper.stackMatch(targetItemStack, sourceStack, ItemHelper.MatchOption.MATCH_EXISTING_STACK) && targetSlot.func_75214_a(sourceStack)) {
                    int maxStackSize;
                    int mergedSize = targetItemStack.func_190916_E() + sourceStack.func_190916_E();
                    if (mergedSize <= (maxStackSize = Math.min(targetSlot.func_75219_a(), sourceStack.func_77976_d()))) {
                        ItemHelper.stackSetSize(sourceStack, 0);
                        ItemHelper.stackSetSize(targetItemStack, mergedSize);
                        targetSlot.func_75218_e();
                        return true;
                    }
                    if (targetItemStack.func_190916_E() < maxStackSize) {
                        sourceStack.func_190917_f(-(maxStackSize - targetItemStack.func_190916_E()));
                        ItemHelper.stackSetSize(targetItemStack, maxStackSize);
                        targetSlot.func_75218_e();
                        return true;
                    }
                }
                targetSlotIndex += targetSlotIndexModifier;
            }
        }
        if (sourceStack.func_190916_E() > 0) {
            int n2 = targetSlotIndex = reverseDirection ? endIndex - 1 : startIndex;
            while (!reverseDirection && targetSlotIndex < endIndex || reverseDirection && targetSlotIndex >= startIndex) {
                targetSlot = this.func_75139_a(targetSlotIndex);
                if (!targetSlot.func_75216_d() && targetSlot.func_75214_a(sourceStack)) {
                    targetSlot.func_75215_d(ItemHelper.stackFrom(sourceStack));
                    targetSlot.func_75218_e();
                    ItemHelper.stackSetSize(sourceStack, 0);
                    return true;
                }
                targetSlotIndex += targetSlotIndexModifier;
            }
        }
        return false;
    }

    public ItemStack func_184996_a(int clickedSlotIndex, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        Slot slot;
        if (this._factory.isSlotOfType(clickedSlotIndex, SlotType.GhostInput) && (slot = this.func_75139_a(clickedSlotIndex)).func_75216_d()) {
            slot.func_75215_d(ItemStack.field_190927_a);
        }
        SlotType slotType = this._factory.getSlotType(clickedSlotIndex);
        switch (slotType) {
            case GhostOutput: 
            case Static: 
            case Unknown: {
                return ItemStack.field_190927_a;
            }
        }
        return super.func_184996_a(clickedSlotIndex, dragType, clickTypeIn, player);
    }

    public ItemStack func_82846_b(PlayerEntity player, int clickedSlotIndex) {
        Optional<SlotTemplate> clickedTemplate = this._factory.getSlotTemplate(clickedSlotIndex);
        if (!clickedTemplate.isPresent()) {
            Log.LOGGER.warn("Unknown slot clicked in a ModContainer at index " + clickedSlotIndex);
            return ItemStack.field_190927_a;
        }
        SlotGeneric clickedSlot = (SlotGeneric)this.func_75139_a(clickedSlotIndex);
        if (!clickedSlot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack clickedStack = clickedSlot.func_75211_c();
        ItemStack resultStack = ItemHelper.stackFrom(clickedStack);
        switch (clickedTemplate.map(SlotTemplate::getType).orElse(SlotType.Unknown)) {
            case Static: 
            case Input: 
            case Output: {
                if (!(this.addStackToTargetSlots(clickedStack, SlotType.Special, false) || this.addStackToTargetSlots(clickedStack, SlotType.PlayerInventory, true) || this.addStackToTargetSlots(clickedStack, SlotType.PlayerHotbar, false))) {
                    return ItemStack.field_190927_a;
                }
                clickedSlot.func_75220_a(clickedStack, resultStack);
                break;
            }
            case GhostOutput: 
            case GhostInput: {
                return ItemStack.field_190927_a;
            }
            case PlayerInventory: {
                if (this.addStackToTargetSlots(clickedStack, SlotType.Special, false) || this.addStackToTargetSlots(clickedStack, SlotType.Input, false) || this.addStackToTargetSlots(clickedStack, SlotType.PlayerHotbar, false)) break;
                return ItemStack.field_190927_a;
            }
            case PlayerHotbar: {
                if (this.addStackToTargetSlots(clickedStack, SlotType.Special, false) || this.addStackToTargetSlots(clickedStack, SlotType.Input, false) || this.addStackToTargetSlots(clickedStack, SlotType.PlayerInventory, false)) break;
                return ItemStack.field_190927_a;
            }
            case Special: {
                if (!this.addStackToTargetSlots(clickedStack, SlotType.PlayerInventory, true) && !this.addStackToTargetSlots(clickedStack, SlotType.PlayerHotbar, false)) {
                    return ItemStack.field_190927_a;
                }
                clickedSlot.func_75220_a(clickedStack, resultStack);
            }
        }
        if (clickedStack.func_190916_E() == 0) {
            clickedSlot.func_75215_d(ItemStack.field_190927_a);
        } else {
            clickedSlot.func_75218_e();
        }
        if (clickedStack.func_190916_E() == resultStack.func_190916_E()) {
            return ItemStack.field_190927_a;
        }
        clickedSlot.func_190901_a(player, clickedStack);
        return resultStack;
    }

    protected Slot func_75146_a(Slot slotIn) {
        if (!(slotIn instanceof SlotGeneric)) {
            throw new RuntimeException("Do not call Container.addSlot() directly! Use the ContainerFactory to add your slots to a ModContainer");
        }
        return super.func_75146_a(slotIn);
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        if (listener instanceof ServerPlayerEntity) {
            if (null == this._dataUpdateListeners) {
                this._dataUpdateListeners = new ObjectArrayList(4);
            }
            this._dataUpdateListeners.add((ServerPlayerEntity)listener);
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (null != this._dataUpdateListeners && !this._dataUpdateListeners.isEmpty()) {
            if (null != this._syncableEntity && this._syncableEntity.shouldSyncEntity()) {
                CompoundNBT envelope = new CompoundNBT();
                envelope.func_74778_a("id", this._syncableEntity.getSyncableEntityId().toString());
                envelope.func_218657_a("payload", (INBT)this._syncableEntity.syncDataTo(new CompoundNBT(), ISyncableEntity.SyncReason.NetworkUpdate));
                Network.sendServerContainerDataSync(this._dataUpdateListeners, envelope);
            }
            if (null != this._dataToSync && !this._dataToSync.isEmpty()) {
                Network.sendServerContainerData(this._dataUpdateListeners, this);
            }
        }
    }

    private void addSlotFor(SlotFactory slotFactory, IItemHandler inventory) {
        Slot slot = slotFactory.createSlot(inventory);
        super.func_75146_a(slot);
        this.addSlotToGroup(slotFactory.getInventoryName(), slot);
        switch (slotFactory.getTemplate().getType()) {
            case PlayerInventory: {
                this.addSlotToGroup(SLOTGROUPNAME_PLAYER_INVENTORY, slot);
                break;
            }
            case PlayerHotbar: {
                this.addSlotToGroup(SLOTGROUPNAME_PLAYER_HOTBAR, slot);
            }
        }
    }

    private void addSlotToGroup(String inventoryName, Slot slot) {
        this._inventorySlotsGroups.computeIfAbsent(inventoryName, name -> Lists.newArrayList()).add(slot);
    }

    private boolean addStackToTargetSlots(ItemStack stack, SlotType targetSlotsType, boolean reverseDirection) {
        List<SlotIndexSet> targetIndices = this._factory.getIndicesForType(targetSlotsType);
        if (targetIndices.isEmpty()) {
            return false;
        }
        for (SlotIndexSet indexSet : targetIndices) {
            for (Range<Integer> range : indexSet.asRanges()) {
                if (!this.func_75135_a(stack, (Integer)range.lowerEndpoint(), (Integer)range.upperEndpoint(), reverseDirection)) continue;
                return true;
            }
        }
        return false;
    }
}

