/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.slot.type;

import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.data.geometry.Point;
import it.zerono.mods.zerocore.lib.item.inventory.IInventorySlot;
import it.zerono.mods.zerocore.lib.item.inventory.container.slot.ISlotNotify;
import it.zerono.mods.zerocore.lib.item.inventory.container.slot.SlotFactory;
import it.zerono.mods.zerocore.lib.item.inventory.container.slot.SlotTemplate;
import java.lang.reflect.Field;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;

public class SlotGeneric
extends SlotItemHandler
implements IInventorySlot {
    private final SlotTemplate _template;
    private final SlotFactory _factory;
    private static final Field s_xPosField = SlotGeneric.getPosField("field_75223_e");
    private static final Field s_yPosField = SlotGeneric.getPosField("field_75221_f");

    public SlotGeneric(IItemHandler itemHandler, SlotFactory slotFactory) {
        super(itemHandler, slotFactory.getIndex(), slotFactory.getX(), slotFactory.getY());
        this._template = slotFactory.getTemplate();
        this._factory = slotFactory;
    }

    public SlotTemplate getTemplate() {
        return this._template;
    }

    public SlotFactory getFactory() {
        return this._factory;
    }

    public void translate(BiFunction<Integer, Integer, Point> mapper) {
        SlotGeneric.setPos(this, mapper.apply(this.getFactory().getX(), this.getFactory().getY()));
    }

    public boolean func_75214_a(ItemStack stack) {
        return this.getTemplate().match(this.getSlotIndex(), stack);
    }

    public void func_75215_d(ItemStack stack) {
        IItemHandler itemHandler = this.getItemHandler();
        if (itemHandler instanceof IItemHandlerModifiable) {
            ((IItemHandlerModifiable)itemHandler).setStackInSlot(this.getSlotIndex(), stack);
            this.func_75218_e();
            if (itemHandler instanceof ISlotNotify) {
                ((ISlotNotify)itemHandler).onSlotChanged(itemHandler, this.getSlotIndex(), stack);
            }
        }
    }

    @Override
    public int getIndex() {
        return this.getSlotIndex();
    }

    @Override
    public ItemStack getStackInSlot() {
        return this.func_75211_c();
    }

    @Override
    public void setStackInSlot(ItemStack stack) {
        this.func_75215_d(stack);
    }

    @Override
    public boolean canInsertStack(ItemStack stack) {
        ItemStack remainder = this.getItemHandler().insertItem(this.getIndex(), stack, true);
        return remainder.func_190926_b() || remainder.func_190916_E() < stack.func_190916_E();
    }

    @Override
    public boolean canExtractStack(int amount) {
        ItemStack remainder = this.getItemHandler().extractItem(this.getIndex(), amount, true);
        return !remainder.func_190926_b() && amount == remainder.func_190916_E();
    }

    @Override
    public int getSlotLimit(ItemStack stack) {
        return stack.func_190926_b() ? this.func_75219_a() : Math.min(this.func_75219_a(), stack.func_77976_d());
    }

    private static void setPos(SlotGeneric slot, Point pos) {
        try {
            s_xPosField.setInt(slot, pos.X);
        }
        catch (IllegalAccessException e) {
            Log.LOGGER.warn(Log.CORE, "Unable to set field xPos for a SlotGeneric");
        }
        try {
            s_yPosField.setInt(slot, pos.Y);
        }
        catch (IllegalAccessException e) {
            Log.LOGGER.warn(Log.CORE, "Unable to set field yPos for a SlotGeneric");
        }
    }

    @Nullable
    private static Field getPosField(String name) {
        try {
            return ObfuscationReflectionHelper.findField(Slot.class, (String)name);
        }
        catch (ObfuscationReflectionHelper.UnableToFindFieldException ex) {
            Log.LOGGER.error(Log.CORE, "SlotGeneric - Unable to get field {} : {}", (Object)name, (Object)ex);
            return null;
        }
    }
}

