/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.multiblock;

import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.ItemTier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public interface IMultiblockPart<Controller extends IMultiblockController<Controller>> {
    public boolean isConnected();

    default public boolean isConnectedTo(Controller controller) {
        return this.evalOnController(c -> c == controller, false);
    }

    public boolean isMachineAssembled();

    public boolean isMachineDisassembled();

    public boolean isMachinePaused();

    public Optional<Controller> getMultiblockController();

    default public void executeOnController(Consumer<Controller> code) {
        this.getMultiblockController().ifPresent(code);
    }

    default public <R> R evalOnController(Function<Controller, R> code, R defaultValue) {
        return this.getMultiblockController().map(code).orElse(defaultValue);
    }

    default public boolean testOnController(Predicate<Controller> test) {
        return this.getMultiblockController().filter(test).isPresent();
    }

    @Deprecated
    public Optional<World> getPartWorld();

    default public <T> T mapPartWorld(Function<World, T> mapper, T defaultValue) {
        return this.getPartWorld().map(mapper).orElse(defaultValue);
    }

    default public void forPartWorld(Consumer<World> consumer) {
        this.getPartWorld().ifPresent(consumer);
    }

    default public World getCurrentWorld() {
        return Objects.requireNonNull(this.getPartWorld().orElse(null));
    }

    public BlockPos getWorldPosition();

    default public long getWorldPositionHash() {
        return this.getWorldPosition().func_218275_a();
    }

    public boolean isPartInvalid();

    public void onAttached(Controller var1);

    public void onDetached(Controller var1);

    public void onOrphaned(Controller var1, int var2, int var3);

    public Controller createController();

    public Class<Controller> getControllerType();

    public void onAssimilated(Controller var1);

    public void setVisited();

    public void setUnvisited();

    public boolean isVisited();

    default public boolean isNotVisited() {
        return !this.isVisited();
    }

    public void becomeMultiblockSaveDelegate();

    public void forfeitMultiblockSaveDelegate();

    public boolean isMultiblockSaveDelegate();

    public List<IMultiblockPart<Controller>> getNeighboringParts();

    public void onPreMachineAssembled(Controller var1);

    public void onPostMachineAssembled(Controller var1);

    public void onPreMachineBroken();

    public void onPostMachineBroken();

    public void onMachineActivated();

    public void onMachineDeactivated();

    @Deprecated
    default public Set<Controller> attachToNeighbors() {
        return Collections.emptySet();
    }

    public Set<Controller> attachToNeighbors(Function<IMultiblockPart<Controller>, Set<Controller>> var1);

    public void assertDetached();

    public boolean hasMultiblockSaveData();

    public Optional<CompoundNBT> getMultiblockSaveData();

    default public <T> T mapMultiblockSaveData(Function<CompoundNBT, T> mapper, T defaultValue) {
        return this.getMultiblockSaveData().map(mapper).orElse(defaultValue);
    }

    default public void forMultiblockSaveData(Consumer<CompoundNBT> consumer) {
        this.getMultiblockSaveData().ifPresent(consumer);
    }

    public void onMultiblockDataAssimilated();

    public void listenForControllerDataUpdates();

    public static AbstractBlock.Properties getDefaultBlockProperties() {
        return AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151668_h).func_200947_a(SoundType.field_185852_e).func_200948_a(5.0f, 6.0f).harvestLevel(ItemTier.IRON.func_200925_d()).harvestTool(ToolType.PICKAXE).func_235861_h_().func_235838_a_(blockState -> 0).func_235827_a_((blockState, blockReader, pos, entity) -> false).func_235847_c_((blockState, blockReader, pos) -> true);
    }
}

