/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.recipe;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.zerono.mods.zerocore.lib.recipe.ISerializableRecipe;
import it.zerono.mods.zerocore.lib.recipe.ModRecipe;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResult;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public abstract class AbstractManyToOneRecipe<IngredientT, Result, RecipeIngredient extends IRecipeIngredient<IngredientT>, RecipeResult extends IRecipeResult<Result>>
extends ModRecipe
implements Predicate<List<IngredientT>>,
ISerializableRecipe {
    private final List<RecipeIngredient> _ingredients;
    private final RecipeResult _result;
    private final IntFunction<String> _jsonIngredientsLabelsSupplier;

    protected AbstractManyToOneRecipe(ResourceLocation id, List<RecipeIngredient> ingredients, RecipeResult result, IntFunction<String> jsonIngredientsLabelsSupplier) {
        super(id);
        Preconditions.checkArgument((!ingredients.isEmpty() ? 1 : 0) != 0, (Object)"Trying to create a recipe without ingredients");
        ObjectArrayList copy = ingredients.size() == 1 ? ObjectLists.singleton(ingredients.get(0)) : new ObjectArrayList(ingredients);
        this._ingredients = ObjectLists.unmodifiable((ObjectList)copy);
        this._result = result;
        this._jsonIngredientsLabelsSupplier = jsonIngredientsLabelsSupplier;
    }

    public int getRecipeIngredientsCount() {
        return this._ingredients.size();
    }

    public List<RecipeIngredient> getRecipeIngredients() {
        return this._ingredients;
    }

    public RecipeResult getResult() {
        return this._result;
    }

    @Override
    public boolean test(List<IngredientT> stacks) {
        ObjectArrayList ingredients = this.getRecipeIngredients();
        int ingredientsCount = ingredients.size();
        if (ingredientsCount != stacks.size()) {
            return false;
        }
        if (1 == ingredientsCount) {
            return ((IRecipeIngredient)ingredients.get(0)).test(stacks.get(0));
        }
        ingredients = new ObjectArrayList(ingredients);
        ingredientsCount = ingredients.size();
        for (IngredientT stack : stacks) {
            boolean found = false;
            for (int idx = 0; idx < ingredientsCount; ++idx) {
                if (!((IRecipeIngredient)ingredients.get(idx)).test(stack)) continue;
                ingredients.remove(idx);
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return AbstractManyToOneRecipe.buildVanillaIngredientsList(this.getRecipeIngredients().stream().flatMap(i -> i.asVanillaIngredients().stream()).collect(Collectors.toList()));
    }

    @Override
    public void serializeTo(PacketBuffer buffer) {
        List<RecipeIngredient> ingredients = this.getRecipeIngredients();
        int count = ingredients.size();
        buffer.writeInt(count);
        for (int idx = 0; idx < count; ++idx) {
            ((IRecipeIngredient)ingredients.get(idx)).serializeTo(buffer);
        }
        this._result.serializeTo(buffer);
    }

    @Override
    public JsonElement serializeTo() {
        JsonObject json = new JsonObject();
        List<RecipeIngredient> ingredients = this.getRecipeIngredients();
        int count = ingredients.size();
        for (int idx = 0; idx < count; ++idx) {
            json.add(this._jsonIngredientsLabelsSupplier.apply(idx), ((IRecipeIngredient)ingredients.get(idx)).serializeTo());
        }
        json.add("result", this._result.serializeTo());
        return json;
    }

    @FunctionalInterface
    public static interface IRecipeFactory<IngredientT, Result, RecipeIngredient extends IRecipeIngredient<IngredientT>, RecipeResult extends IRecipeResult<Result>, Recipe extends AbstractManyToOneRecipe<IngredientT, Result, RecipeIngredient, RecipeResult>> {
        public Recipe create(ResourceLocation var1, List<RecipeIngredient> var2, RecipeResult var3);
    }
}

