/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.emojiful.util;

import com.hrznstudio.emojiful.api.Emoji;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.math.vector.Matrix4f;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;
import org.w3c.dom.Node;

public class EmojiUtil {
    public static RenderType createRenderType(Emoji emoji) {
        RenderType.State state = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(emoji.getResourceLocationForBinding(), false, false)).func_228726_a_(new RenderState.TransparencyState("translucent_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        }, () -> {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        })).func_228713_a_(new RenderState.AlphaState(0.003921569f)).func_228719_a_(new RenderState.LightmapState(true)).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"portal_render", (VertexFormat)DefaultVertexFormats.field_227852_q_, (int)7, (int)256, (boolean)false, (boolean)true, (RenderType.State)state);
    }

    public static float renderEmoji(Emoji emoji, float x, float y, Matrix4f matrix, IRenderTypeBuffer buffer, int packedLight) {
        float textureSize = 16.0f;
        float textureX = 0.0f / textureSize;
        float textureY = 0.0f / textureSize;
        float textureOffset = 16.0f / textureSize;
        float size = 10.0f;
        float offsetY = 1.0f;
        float offsetX = 0.0f;
        IVertexBuilder builder = buffer.getBuffer(EmojiUtil.createRenderType(emoji));
        builder.func_227888_a_(matrix, x - offsetX, y - offsetY, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(textureX, textureY).func_227886_a_(packedLight).func_181675_d();
        builder.func_227888_a_(matrix, x - offsetX, y + size - offsetY, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(textureX, textureY + textureOffset).func_227886_a_(packedLight).func_181675_d();
        builder.func_227888_a_(matrix, x - offsetX + size, y + size - offsetY, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(textureX + textureOffset, textureY + textureOffset).func_227886_a_(packedLight).func_181675_d();
        builder.func_227888_a_(matrix, x - offsetX + size, y - offsetY, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(textureX + textureOffset, textureY / textureSize).func_227886_a_(packedLight).func_181675_d();
        return 10.0f;
    }

    public static String cleanStringForRegex(String string) {
        return string.replaceAll("\\)", "\\\\)").replaceAll("\\(", "\\\\(").replaceAll("\\|", "\\\\|").replaceAll("\\*", "\\\\*");
    }

    public static List<Pair<BufferedImage, Integer>> splitGif(File file) throws IOException {
        ArrayList<Pair<BufferedImage, Integer>> images = new ArrayList<Pair<BufferedImage, Integer>>();
        ImageReader reader = ImageIO.getImageReadersBySuffix("gif").next();
        reader.setInput(ImageIO.createImageInputStream(new FileInputStream(file)), false);
        IIOMetadata metadata = reader.getImageMetadata(0);
        String metaFormatName = metadata.getNativeMetadataFormatName();
        for (int i = 0; i < reader.getNumImages(true); ++i) {
            int frameLength = 1;
            BufferedImage image = reader.read(i);
            BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), 6);
            newImage.getGraphics().drawImage(image, 0, 0, null);
            IIOMetadataNode root = (IIOMetadataNode)reader.getImageMetadata(i).getAsTree(metaFormatName);
            int nNodes = root.getLength();
            for (int j = 0; j < nNodes; ++j) {
                Node node = root.item(j);
                if (!node.getNodeName().equalsIgnoreCase("GraphicControlExtension")) continue;
                frameLength = Integer.parseInt(((IIOMetadataNode)node).getAttribute("delayTime"));
                break;
            }
            images.add((Pair<BufferedImage, Integer>)Pair.of((Object)newImage, (Object)frameLength));
        }
        return images;
    }
}

