/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj;

import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;

public class MaterialSpriteGetter<T>
implements BiFunction<String, RenderMaterial, TextureAtlasSprite> {
    private final Function<RenderMaterial, TextureAtlasSprite> getter;
    private final String groupName;
    private final IOBJModelCallback<T> callback;
    private final T callbackObject;
    private final ShaderCase shaderCase;
    private int renderPass = 0;

    public MaterialSpriteGetter(Function<RenderMaterial, TextureAtlasSprite> getter, String groupName, IOBJModelCallback<T> callback, T callbackObject, ShaderCase shaderCase) {
        this.getter = getter;
        this.groupName = groupName;
        this.callback = callback;
        this.callbackObject = callbackObject;
        this.shaderCase = shaderCase;
    }

    public void setRenderPass(int pass) {
        this.renderPass = pass;
    }

    @Override
    public TextureAtlasSprite apply(String material, RenderMaterial resourceLocation) {
        ResourceLocation rl;
        TextureAtlasSprite sprite = null;
        if (this.callback != null) {
            sprite = this.callback.getTextureReplacement(this.callbackObject, this.groupName, material);
        }
        if (this.shaderCase != null && (rl = this.shaderCase.getTextureReplacement(this.groupName, this.renderPass)) != null) {
            sprite = this.getter.apply(new RenderMaterial(PlayerContainer.field_226615_c_, rl));
        }
        if (sprite == null) {
            sprite = this.getter.apply(resourceLocation);
        }
        return sprite;
    }
}

