/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.utils;

import blusunrize.immersiveengineering.api.crafting.ClocheRecipe;
import blusunrize.immersiveengineering.api.crafting.ClocheRenderFunction;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.plant.EnumHempGrowth;
import blusunrize.immersiveengineering.common.blocks.plant.HempBlock;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collection;
import net.minecraft.block.AttachedStemBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChorusPlantBlock;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.StemBlock;
import net.minecraft.block.StemGrownBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3f;
import org.apache.commons.lang3.tuple.Pair;

public class ClocheRenderFunctions {
    public static void init() {
        ClocheRecipe.registerSoilTexture(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_221582_j), new ItemStack((IItemProvider)Items.field_221583_k), new ItemStack((IItemProvider)Items.field_221581_i), new ItemStack((IItemProvider)Items.field_221906_fk)}), new ResourceLocation("block/farmland_moist"));
        ClocheRenderFunction.RENDER_FUNCTION_FACTORIES.put("crop", RenderFunctionCrop::new);
        ClocheRenderFunction.RENDER_FUNCTION_FACTORIES.put("stacking", RenderFunctionStacking::new);
        ClocheRenderFunction.RENDER_FUNCTION_FACTORIES.put("stem", RenderFunctionStem::new);
        ClocheRenderFunction.RENDER_FUNCTION_FACTORIES.put("generic", RenderFunctionGeneric::new);
        ClocheRenderFunction.RENDER_FUNCTION_FACTORIES.put("hemp", block -> new RenderFunctionHemp());
        ClocheRenderFunction.RENDER_FUNCTION_FACTORIES.put("chorus", block -> new RenderFunctionChorus());
    }

    public static class RenderFunctionChorus
    implements ClocheRenderFunction {
        @Override
        public float getScale(ItemStack seed, float growth) {
            return 0.5f;
        }

        @Override
        public Collection<Pair<BlockState, TransformationMatrix>> getBlocks(ItemStack stack, float growth) {
            TransformationMatrix bottom = new TransformationMatrix(new Vector3f(0.0f, (growth *= 2.0f) - 2.0f, 0.0f), null, null, null);
            TransformationMatrix middle = new TransformationMatrix(new Vector3f(0.0f, growth - 1.0f, 0.0f), null, null, null);
            TransformationMatrix top = new TransformationMatrix(new Vector3f(0.0f, growth, 0.0f), null, null, null);
            BlockState stem = (BlockState)((BlockState)Blocks.field_185765_cR.func_176223_P().func_206870_a((Property)ChorusPlantBlock.field_196489_A, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)ChorusPlantBlock.field_196496_z, (Comparable)Boolean.valueOf(true));
            return ImmutableList.of((Object)Pair.of((Object)stem, (Object)bottom), (Object)Pair.of((Object)stem, (Object)middle), (Object)Pair.of((Object)Blocks.field_185766_cS.func_176223_P(), (Object)top));
        }
    }

    public static class RenderFunctionHemp
    implements ClocheRenderFunction {
        @Override
        public float getScale(ItemStack seed, float growth) {
            return 0.6875f;
        }

        @Override
        public Collection<Pair<BlockState, TransformationMatrix>> getBlocks(ItemStack stack, float growth) {
            int age = Math.min(4, Math.round(growth * 4.0f));
            if (age == 4) {
                TransformationMatrix top = new TransformationMatrix(new Vector3f(0.0f, 1.0f, 0.0f), null, null, null);
                return ImmutableList.of((Object)Pair.of((Object)((BlockState)IEBlocks.Misc.hempPlant.func_176223_P().func_206870_a(HempBlock.GROWTH, (Comparable)((Object)EnumHempGrowth.BOTTOM4))), (Object)new TransformationMatrix(null)), (Object)Pair.of((Object)((BlockState)IEBlocks.Misc.hempPlant.func_176223_P().func_206870_a(HempBlock.GROWTH, (Comparable)((Object)EnumHempGrowth.TOP0))), (Object)top));
            }
            return ImmutableList.of((Object)Pair.of((Object)((BlockState)IEBlocks.Misc.hempPlant.func_176223_P().func_206870_a(HempBlock.GROWTH, (Comparable)((Object)EnumHempGrowth.values()[age]))), (Object)new TransformationMatrix(null)));
        }
    }

    public static class RenderFunctionGeneric
    implements ClocheRenderFunction {
        final Block cropBlock;

        public RenderFunctionGeneric(Block cropBlock) {
            this.cropBlock = cropBlock;
        }

        @Override
        public float getScale(ItemStack seed, float growth) {
            return 0.75f;
        }

        @Override
        public Collection<Pair<BlockState, TransformationMatrix>> getBlocks(ItemStack stack, float growth) {
            Vector3f transl = new Vector3f(0.5f - growth / 2.0f, 0.0f, 0.5f - growth / 2.0f);
            Vector3f scale = new Vector3f(growth, growth, growth);
            return ImmutableList.of((Object)Pair.of((Object)this.cropBlock.func_176223_P(), (Object)new TransformationMatrix(transl, null, scale, null)));
        }
    }

    public static class RenderFunctionStem
    implements ClocheRenderFunction {
        final StemGrownBlock cropBlock;
        final StemBlock stemBlock;
        final AttachedStemBlock attachedStemBlock;

        public RenderFunctionStem(Block cropBlock) {
            Preconditions.checkArgument((boolean)(cropBlock instanceof StemGrownBlock));
            this.cropBlock = (StemGrownBlock)cropBlock;
            this.stemBlock = this.cropBlock.func_196524_d();
            this.attachedStemBlock = this.cropBlock.func_196523_e();
        }

        @Override
        public float getScale(ItemStack seed, float growth) {
            return 1.0f;
        }

        @Override
        public Collection<Pair<BlockState, TransformationMatrix>> getBlocks(ItemStack stack, float growth) {
            MatrixStack transform = new MatrixStack();
            transform.func_227861_a_(0.0, 0.0625, 0.25);
            if ((double)growth < 0.375) {
                int age = Math.round(7.0f * growth / 0.375f);
                return ImmutableList.of((Object)Pair.of((Object)((BlockState)this.stemBlock.func_176223_P().func_206870_a((Property)StemBlock.field_176484_a, (Comparable)Integer.valueOf(age))), (Object)new TransformationMatrix(transform.func_227866_c_().func_227870_a_())));
            }
            float scale = (growth - 0.375f) / 0.625f * 0.3125f;
            TransformationMatrix cropMatrix = new TransformationMatrix(new Vector3f(0.5f - scale / 2.0f, 0.5625f - scale, 0.25f - scale / 2.0f), null, new Vector3f(scale, scale, scale), null);
            return ImmutableList.of((Object)Pair.of((Object)this.attachedStemBlock.func_176223_P(), (Object)new TransformationMatrix(transform.func_227866_c_().func_227870_a_())), (Object)Pair.of((Object)this.cropBlock.func_176223_P(), (Object)cropMatrix));
        }
    }

    public static class RenderFunctionStacking
    implements ClocheRenderFunction {
        final Block cropBlock;

        public RenderFunctionStacking(Block cropBlock) {
            this.cropBlock = cropBlock;
        }

        @Override
        public float getScale(ItemStack seed, float growth) {
            return 0.6875f;
        }

        @Override
        public Collection<Pair<BlockState, TransformationMatrix>> getBlocks(ItemStack stack, float growth) {
            TransformationMatrix bottom = new TransformationMatrix(new Vector3f(0.0f, growth - 1.0f, 0.0f), null, null, null);
            TransformationMatrix top = new TransformationMatrix(new Vector3f(0.0f, growth, 0.0f), null, null, null);
            return ImmutableList.of((Object)Pair.of((Object)this.cropBlock.func_176223_P(), (Object)bottom), (Object)Pair.of((Object)this.cropBlock.func_176223_P(), (Object)top));
        }
    }

    public static class RenderFunctionCrop
    implements ClocheRenderFunction {
        final Block cropBlock;
        int maxAge;
        IntegerProperty ageProperty;

        public RenderFunctionCrop(Block cropBlock) {
            this.cropBlock = cropBlock;
            if (cropBlock instanceof CropsBlock) {
                this.maxAge = ((CropsBlock)cropBlock).func_185526_g();
                this.ageProperty = ((CropsBlock)cropBlock).func_185524_e();
            } else {
                for (Property prop : cropBlock.func_176223_P().func_235904_r_()) {
                    if (!"age".equals(prop.func_177701_a()) || !(prop instanceof IntegerProperty)) continue;
                    int tmp = -1;
                    for (Integer allowed : ((IntegerProperty)prop).func_177700_c()) {
                        if (allowed == null || allowed <= tmp) continue;
                        tmp = allowed;
                    }
                    if (tmp <= 0) continue;
                    this.maxAge = tmp;
                    this.ageProperty = (IntegerProperty)prop;
                    break;
                }
            }
            if (this.ageProperty == null || this.maxAge <= 0) {
                throw new IllegalArgumentException("Block " + cropBlock.func_149739_a() + " is not a valid crop block");
            }
        }

        @Override
        public float getScale(ItemStack seed, float growth) {
            return 0.875f;
        }

        @Override
        public Collection<Pair<BlockState, TransformationMatrix>> getBlocks(ItemStack stack, float growth) {
            int age = Math.min(this.maxAge, Math.round((float)this.maxAge * growth));
            return ImmutableList.of((Object)Pair.of((Object)((BlockState)this.cropBlock.func_176223_P().func_206870_a((Property)this.ageProperty, (Comparable)Integer.valueOf(age))), (Object)new TransformationMatrix(null)));
        }
    }
}

