/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.utils;

import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.utils.BatchingRenderTypeBuffer;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.client.utils.TransformingVertexBuilder;
import blusunrize.immersiveengineering.common.util.fluids.IEFluid;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class GuiHelper {
    public static void drawColouredRect(int x, int y, int w, int h, int colour, IRenderTypeBuffer buffers, MatrixStack transform) {
        Matrix4f mat = transform.func_227866_c_().func_227870_a_();
        IVertexBuilder worldrenderer = buffers.getBuffer(IERenderTypes.TRANSLUCENT_POSITION_COLOR);
        worldrenderer.func_227888_a_(mat, (float)x, (float)(y + h), 0.0f).func_225586_a_(colour >> 16 & 0xFF, colour >> 8 & 0xFF, colour & 0xFF, colour >> 24 & 0xFF).func_181675_d();
        worldrenderer.func_227888_a_(mat, (float)(x + w), (float)(y + h), 0.0f).func_225586_a_(colour >> 16 & 0xFF, colour >> 8 & 0xFF, colour & 0xFF, colour >> 24 & 0xFF).func_181675_d();
        worldrenderer.func_227888_a_(mat, (float)(x + w), (float)y, 0.0f).func_225586_a_(colour >> 16 & 0xFF, colour >> 8 & 0xFF, colour & 0xFF, colour >> 24 & 0xFF).func_181675_d();
        worldrenderer.func_227888_a_(mat, (float)x, (float)y, 0.0f).func_225586_a_(colour >> 16 & 0xFF, colour >> 8 & 0xFF, colour & 0xFF, colour >> 24 & 0xFF).func_181675_d();
    }

    public static void drawTexturedColoredRect(IVertexBuilder builder, MatrixStack transform, float x, float y, float w, float h, float r, float g, float b, float alpha, float u0, float u1, float v0, float v1) {
        TransformingVertexBuilder innerBuilder = new TransformingVertexBuilder(builder, transform);
        innerBuilder.setColor(r, g, b, alpha);
        innerBuilder.setLight(LightTexture.func_228451_a_((int)15, (int)15));
        innerBuilder.setOverlay(OverlayTexture.field_229196_a_);
        innerBuilder.setNormal(1.0f, 1.0f, 1.0f);
        innerBuilder.func_225582_a_(x, y + h, 0.0).func_225583_a_(u0, v1).func_181675_d();
        innerBuilder.func_225582_a_(x + w, y + h, 0.0).func_225583_a_(u1, v1).func_181675_d();
        innerBuilder.func_225582_a_(x + w, y, 0.0).func_225583_a_(u1, v0).func_181675_d();
        innerBuilder.func_225582_a_(x, y, 0.0).func_225583_a_(u0, v0).func_181675_d();
    }

    public static void drawTexturedRect(IVertexBuilder builder, MatrixStack transform, int x, int y, int w, int h, float picSize, int u0, int u1, int v0, int v1) {
        GuiHelper.drawTexturedColoredRect(builder, transform, x, y, w, h, 1.0f, 1.0f, 1.0f, 1.0f, (float)u0 / picSize, (float)u1 / picSize, (float)v0 / picSize, (float)v1 / picSize);
    }

    public static void drawRepeatedFluidSpriteGui(IRenderTypeBuffer buffer, MatrixStack transform, FluidStack fluid, float x, float y, float w, float h) {
        RenderType renderType = IERenderTypes.getGui(PlayerContainer.field_226615_c_);
        IVertexBuilder builder = buffer.getBuffer(renderType);
        GuiHelper.drawRepeatedFluidSprite(builder, transform, fluid, x, y, w, h);
    }

    public static void drawRepeatedFluidSprite(IVertexBuilder builder, MatrixStack transform, FluidStack fluid, float x, float y, float w, float h) {
        TextureAtlasSprite sprite = ClientUtils.getSprite(fluid.getFluid().getAttributes().getStillTexture(fluid));
        int col = fluid.getFluid().getAttributes().getColor(fluid);
        int iW = sprite.func_94211_a();
        int iH = sprite.func_94216_b();
        if (iW > 0 && iH > 0) {
            GuiHelper.drawRepeatedSprite(builder, transform, x, y, w, h, iW, iH, sprite.func_94209_e(), sprite.func_94212_f(), sprite.func_94206_g(), sprite.func_94210_h(), (float)(col >> 16 & 0xFF) / 255.0f, (float)(col >> 8 & 0xFF) / 255.0f, (float)(col & 0xFF) / 255.0f, 1.0f);
        }
    }

    public static void drawRepeatedSprite(IVertexBuilder builder, MatrixStack transform, float x, float y, float w, float h, int iconWidth, int iconHeight, float uMin, float uMax, float vMin, float vMax, float r, float g, float b, float alpha) {
        int iterMaxW = (int)(w / (float)iconWidth);
        int iterMaxH = (int)(h / (float)iconHeight);
        float leftoverW = w % (float)iconWidth;
        float leftoverH = h % (float)iconHeight;
        float leftoverWf = leftoverW / (float)iconWidth;
        float leftoverHf = leftoverH / (float)iconHeight;
        float iconUDif = uMax - uMin;
        float iconVDif = vMax - vMin;
        for (int ww = 0; ww < iterMaxW; ++ww) {
            for (int hh = 0; hh < iterMaxH; ++hh) {
                GuiHelper.drawTexturedColoredRect(builder, transform, x + (float)(ww * iconWidth), y + (float)(hh * iconHeight), iconWidth, iconHeight, r, g, b, alpha, uMin, uMax, vMin, vMax);
            }
            GuiHelper.drawTexturedColoredRect(builder, transform, x + (float)(ww * iconWidth), y + (float)(iterMaxH * iconHeight), iconWidth, leftoverH, r, g, b, alpha, uMin, uMax, vMin, vMin + iconVDif * leftoverHf);
        }
        if (leftoverW > 0.0f) {
            for (int hh = 0; hh < iterMaxH; ++hh) {
                GuiHelper.drawTexturedColoredRect(builder, transform, x + (float)(iterMaxW * iconWidth), y + (float)(hh * iconHeight), leftoverW, iconHeight, r, g, b, alpha, uMin, uMin + iconUDif * leftoverWf, vMin, vMax);
            }
            GuiHelper.drawTexturedColoredRect(builder, transform, x + (float)(iterMaxW * iconWidth), y + (float)(iterMaxH * iconHeight), leftoverW, leftoverH, r, g, b, alpha, uMin, uMin + iconUDif * leftoverWf, vMin, vMin + iconVDif * leftoverHf);
        }
    }

    public static void drawSlot(int x, int y, int w, int h, MatrixStack transform) {
        GuiHelper.drawSlot(x, y, w, h, 255, transform);
    }

    public static void drawSlot(MatrixStack transform, int x, int y, int w, int h, int dark, int main, int light) {
        int minX = x + 8 - w / 2;
        int minY = y + 8 - h / 2;
        int maxX = minX + w;
        int maxY = minY + h;
        AbstractGui.func_238467_a_((MatrixStack)transform, (int)minX, (int)(minY - 1), (int)maxX, (int)minY, (int)dark);
        AbstractGui.func_238467_a_((MatrixStack)transform, (int)(minX - 1), (int)(minY - 1), (int)minX, (int)maxY, (int)dark);
        AbstractGui.func_238467_a_((MatrixStack)transform, (int)minX, (int)minY, (int)maxX, (int)maxY, (int)main);
        AbstractGui.func_238467_a_((MatrixStack)transform, (int)minX, (int)maxY, (int)(maxX + 1), (int)(maxY + 1), (int)light);
        AbstractGui.func_238467_a_((MatrixStack)transform, (int)maxX, (int)minY, (int)(maxX + 1), (int)maxY, (int)light);
    }

    public static void drawSlot(int x, int y, int w, int h, int alpha, MatrixStack transform) {
        GuiHelper.drawSlot(transform, x, y, w, h, alpha << 24 | 0x373737, alpha << 24 | 0x8B8B8B, alpha << 24 | 0xFFFFFF);
    }

    public static void drawDarkSlot(MatrixStack transform, int x, int y, int w, int h) {
        GuiHelper.drawSlot(transform, x, y, w, h, 0x77222222, 0x77111111, 0x77999999);
    }

    public static void handleGuiTank(MatrixStack transform, IFluidTank tank, int x, int y, int w, int h, int oX, int oY, int oW, int oH, int mX, int mY, ResourceLocation originalTexture, List<ITextComponent> tooltip) {
        GuiHelper.handleGuiTank(transform, tank.getFluid(), tank.getCapacity(), x, y, w, h, oX, oY, oW, oH, mX, mY, originalTexture, tooltip);
    }

    public static void handleGuiTank(MatrixStack transform, FluidStack fluid, int capacity, int x, int y, int w, int h, int oX, int oY, int oW, int oH, int mX, int mY, ResourceLocation originalTexture, List<ITextComponent> tooltip) {
        if (tooltip == null) {
            transform.func_227860_a_();
            IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            if (fluid != null && fluid.getFluid() != null) {
                int fluidHeight = (int)((float)h * ((float)fluid.getAmount() / (float)capacity));
                GuiHelper.drawRepeatedFluidSpriteGui((IRenderTypeBuffer)buffer, transform, fluid, x, y + h - fluidHeight, w, fluidHeight);
                RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            }
            int xOff = (w - oW) / 2;
            int yOff = (h - oH) / 2;
            RenderType renderType = IERenderTypes.getGui(originalTexture);
            GuiHelper.drawTexturedRect(buffer.getBuffer(renderType), transform, x + xOff, y + yOff, oW, oH, 256.0f, oX, oX + oW, oY, oY + oH);
            buffer.func_228462_a_(renderType);
            transform.func_227865_b_();
        } else if (mX >= x && mX < x + w && mY >= y && mY < y + h) {
            GuiHelper.addFluidTooltip(fluid, tooltip, capacity);
        }
    }

    public static void addFluidTooltip(FluidStack fluid, List<ITextComponent> tooltip, int tankCapacity) {
        if (!fluid.isEmpty()) {
            tooltip.add((ITextComponent)TextUtils.applyFormat(fluid.getDisplayName(), fluid.getFluid().getAttributes().getRarity((FluidStack)fluid).field_77937_e));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("gui.immersiveengineering.empty"));
        }
        if (fluid.getFluid() instanceof IEFluid) {
            ((IEFluid)fluid.getFluid()).addTooltipInfo(fluid, null, tooltip);
        }
        if (ClientUtils.mc().field_71474_y.field_82882_x && !fluid.isEmpty()) {
            if (!Screen.func_231173_s_()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.holdShiftForInfo"));
            } else {
                tooltip.add((ITextComponent)TextUtils.applyFormat((ITextComponent)new StringTextComponent("Fluid Registry: " + fluid.getFluid().getRegistryName()), TextFormatting.DARK_GRAY));
                tooltip.add((ITextComponent)TextUtils.applyFormat((ITextComponent)new StringTextComponent("Density: " + fluid.getFluid().getAttributes().getDensity(fluid)), TextFormatting.DARK_GRAY));
                tooltip.add((ITextComponent)TextUtils.applyFormat((ITextComponent)new StringTextComponent("Temperature: " + fluid.getFluid().getAttributes().getTemperature(fluid)), TextFormatting.DARK_GRAY));
                tooltip.add((ITextComponent)TextUtils.applyFormat((ITextComponent)new StringTextComponent("Viscosity: " + fluid.getFluid().getAttributes().getViscosity(fluid)), TextFormatting.DARK_GRAY));
                tooltip.add((ITextComponent)TextUtils.applyFormat((ITextComponent)new StringTextComponent("NBT Data: " + fluid.getTag()), TextFormatting.DARK_GRAY));
            }
        }
        if (tankCapacity > 0) {
            tooltip.add((ITextComponent)TextUtils.applyFormat((ITextComponent)new StringTextComponent(fluid.getAmount() + "/" + tankCapacity + "mB"), TextFormatting.GRAY));
        } else {
            tooltip.add((ITextComponent)TextUtils.applyFormat((ITextComponent)new StringTextComponent(fluid.getAmount() + "mB"), TextFormatting.GRAY));
        }
    }

    public static void renderItemWithOverlayIntoGUI(IRenderTypeBuffer buffer, MatrixStack transform, ItemStack stack, int x, int y) {
        buffer = IERenderTypes.disableLighting(buffer);
        transform.func_227860_a_();
        transform.func_227861_a_((double)x, (double)y, 100.0);
        transform.func_227860_a_();
        transform.func_227861_a_(8.0, 8.0, 0.0);
        transform.func_227862_a_(1.0f, -1.0f, 1.0f);
        transform.func_227862_a_(16.0f, 16.0f, 16.0f);
        BatchingRenderTypeBuffer batchBuffer = new BatchingRenderTypeBuffer();
        ClientUtils.mc().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.GUI, 0xF000F0, OverlayTexture.field_229196_a_, transform, (IRenderTypeBuffer)batchBuffer);
        batchBuffer.pipe(buffer);
        transform.func_227865_b_();
        GuiHelper.renderDurabilityBar(stack, buffer, transform);
        transform.func_227865_b_();
    }

    public static void renderDurabilityBar(ItemStack stack, IRenderTypeBuffer buffer, MatrixStack transform) {
        if (!stack.func_190926_b() && stack.func_77973_b().showDurabilityBar(stack)) {
            double health = stack.func_77973_b().getDurabilityForDisplay(stack);
            int i = Math.round(13.0f - (float)health * 13.0f);
            int j = stack.func_77973_b().getRGBDurabilityForDisplay(stack);
            GuiHelper.draw(transform, buffer, 2, 13, 13, 2, 0, 0, 0);
            GuiHelper.draw(transform, buffer, 2, 13, i, 1, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF);
        }
    }

    private static void draw(MatrixStack transform, IRenderTypeBuffer buffer, int x, int y, int width, int height, int red, int green, int blue) {
        IVertexBuilder builder = buffer.getBuffer(IERenderTypes.ITEM_DAMAGE_BAR);
        transform.func_227860_a_();
        transform.func_227861_a_((double)x, (double)y, 0.0);
        Matrix4f mat = transform.func_227866_c_().func_227870_a_();
        builder.func_227888_a_(mat, 0.0f, 0.0f, 0.0f).func_225586_a_(red, green, blue, 255).func_181675_d();
        builder.func_227888_a_(mat, 0.0f, (float)height, 0.0f).func_225586_a_(red, green, blue, 255).func_181675_d();
        builder.func_227888_a_(mat, (float)width, (float)height, 0.0f).func_225586_a_(red, green, blue, 255).func_181675_d();
        builder.func_227888_a_(mat, (float)width, 0.0f, 0.0f).func_225586_a_(red, green, blue, 255).func_181675_d();
        transform.func_227865_b_();
    }
}

