/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.AlloyRecipe;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceFuel;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.api.crafting.ClocheFertilizer;
import blusunrize.immersiveengineering.api.crafting.ClocheRecipe;
import blusunrize.immersiveengineering.api.crafting.CokeOvenRecipe;
import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.crafting.FermenterRecipe;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.api.crafting.RefineryRecipe;
import blusunrize.immersiveengineering.api.crafting.SawmillRecipe;
import blusunrize.immersiveengineering.api.crafting.SqueezerRecipe;
import blusunrize.immersiveengineering.api.energy.GeneratorFuel;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.api.utils.TagUtils;
import blusunrize.immersiveengineering.common.blocks.multiblocks.StaticTemplateManager;
import blusunrize.immersiveengineering.common.crafting.ArcRecyclingCalculator;
import blusunrize.immersiveengineering.common.crafting.GeneratedListRecipe;
import blusunrize.immersiveengineering.common.crafting.MetalPressPackingRecipes;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class RecipeReloadListener
implements IResourceManagerReloadListener {
    private final DataPackRegistries dataPackRegistries;
    RecipeManager clientRecipeManager;

    public RecipeReloadListener(DataPackRegistries dataPackRegistries) {
        this.dataPackRegistries = dataPackRegistries;
    }

    public void func_195410_a(@Nonnull IResourceManager resourceManager) {
        if (this.dataPackRegistries != null) {
            Iterator it;
            RecipeManager recipeManager = this.dataPackRegistries.func_240967_e_();
            this.startArcRecyclingRecipeGen(recipeManager);
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null && (it = server.func_212370_w().iterator()).hasNext()) {
                ApiUtils.addFutureServerTask((World)it.next(), () -> StaticTemplateManager.syncMultiblockTemplates(PacketDistributor.ALL.noArg(), true));
            }
        }
    }

    @SubscribeEvent
    public void onTagsUpdated(TagsUpdatedEvent event) {
        if (this.clientRecipeManager != null) {
            TagUtils.setTagCollectionGetters(ItemTags::func_199903_a, BlockTags::func_199896_a);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRecipesUpdated(RecipesUpdatedEvent event) {
        this.clientRecipeManager = event.getRecipeManager();
        if (!Minecraft.func_71410_x().func_71356_B()) {
            RecipeReloadListener.buildRecipeLists(this.clientRecipeManager);
        }
    }

    public static void buildRecipeLists(RecipeManager recipeManager) {
        Collection recipes = recipeManager.func_199510_b();
        if (recipes.size() == 0) {
            return;
        }
        AlloyRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, AlloyRecipe.class, AlloyRecipe.TYPE);
        BlastFurnaceRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, BlastFurnaceRecipe.class, BlastFurnaceRecipe.TYPE);
        BlastFurnaceFuel.blastFuels = RecipeReloadListener.filterRecipes(recipes, BlastFurnaceFuel.class, BlastFurnaceFuel.TYPE);
        CokeOvenRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, CokeOvenRecipe.class, CokeOvenRecipe.TYPE);
        ClocheRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, ClocheRecipe.class, ClocheRecipe.TYPE);
        ClocheFertilizer.fertilizerList = RecipeReloadListener.filterRecipes(recipes, ClocheFertilizer.class, ClocheFertilizer.TYPE);
        BlueprintCraftingRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, BlueprintCraftingRecipe.class, BlueprintCraftingRecipe.TYPE);
        BlueprintCraftingRecipe.updateRecipeCategories();
        MetalPressRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, MetalPressRecipe.class, MetalPressRecipe.TYPE);
        MetalPressRecipe unpackingRecipe = MetalPressPackingRecipes.getUnpackingContainer();
        MetalPressRecipe packingRecipe2x2 = MetalPressPackingRecipes.get2x2PackingContainer();
        MetalPressRecipe packingRecipe3x3 = MetalPressPackingRecipes.get3x3PackingContainer();
        MetalPressRecipe.recipeList.put(unpackingRecipe.func_199560_c(), unpackingRecipe);
        MetalPressRecipe.recipeList.put(packingRecipe2x2.func_199560_c(), packingRecipe2x2);
        MetalPressRecipe.recipeList.put(packingRecipe3x3.func_199560_c(), packingRecipe3x3);
        MetalPressPackingRecipes.CRAFTING_RECIPE_MAP = RecipeReloadListener.filterRecipes(recipes, ICraftingRecipe.class, IRecipeType.field_222149_a);
        MetalPressRecipe.updateRecipesByMold();
        BottlingMachineRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, BottlingMachineRecipe.class, BottlingMachineRecipe.TYPE);
        CrusherRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, CrusherRecipe.class, CrusherRecipe.TYPE);
        SawmillRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, SawmillRecipe.class, SawmillRecipe.TYPE);
        FermenterRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, FermenterRecipe.class, FermenterRecipe.TYPE);
        SqueezerRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, SqueezerRecipe.class, SqueezerRecipe.TYPE);
        RefineryRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, RefineryRecipe.class, RefineryRecipe.TYPE);
        MixerRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, MixerRecipe.class, MixerRecipe.TYPE);
        MineralMix.mineralList = RecipeReloadListener.filterRecipes(recipes, MineralMix.class, MineralMix.TYPE);
        GeneratorFuel.ALL_FUELS = RecipeReloadListener.filterRecipes(recipes, GeneratorFuel.class, GeneratorFuel.TYPE).values();
        ArcFurnaceRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, ArcFurnaceRecipe.class, ArcFurnaceRecipe.TYPE);
    }

    private void startArcRecyclingRecipeGen(RecipeManager recipeManager) {
        Collection recipes = recipeManager.func_199510_b();
        new ArcRecyclingCalculator(recipes).run();
    }

    static <R extends IRecipe<?>> Map<ResourceLocation, R> filterRecipes(Collection<IRecipe<?>> recipes, Class<R> recipeClass, IRecipeType<R> recipeType) {
        return recipes.stream().filter(iRecipe -> iRecipe.func_222127_g() == recipeType).flatMap(r -> {
            if (r instanceof GeneratedListRecipe) {
                return ((GeneratedListRecipe)r).getSubRecipes().stream();
            }
            return Stream.of(r);
        }).map(recipeClass::cast).collect(Collectors.toMap(recipe -> recipe.func_199560_c(), recipe -> recipe));
    }
}

