/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.utils.PlayerUtils;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.common.entities.CapabilitySkyhookData;
import blusunrize.immersiveengineering.common.items.IEItems;
import blusunrize.immersiveengineering.common.network.MessageSkyhookSync;
import blusunrize.immersiveengineering.common.util.IEStats;
import blusunrize.immersiveengineering.common.util.SkylineHelper;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;

public class SkylineHookEntity
extends Entity {
    public static final EntityType<SkylineHookEntity> TYPE = EntityType.Builder.func_220322_a(SkylineHookEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.125f, 0.125f).func_206830_a("immersiveengineering:skyline_hook");
    public static final double GRAVITY = 10.0;
    private static final double MAX_SPEED = 2.5;
    private static final double LIMIT_SPEED = 0.25;
    public static final double MOVE_SPEED_HOR = 0.25;
    public static final double MOVE_SPEED_VERT = 0.1;
    private Connection connection;
    public ConnectionPoint start;
    public double linePos;
    public double horizontalSpeed;
    private double angle;
    public double friction = 0.99;
    public Hand hand;
    private boolean limitSpeed;
    private final Set<BlockPos> ignoreCollisions = new HashSet<BlockPos>();

    public SkylineHookEntity(EntityType<SkylineHookEntity> type, World world) {
        super(type, world);
    }

    public SkylineHookEntity(World world, Connection connection, ConnectionPoint start, double linePos, Hand hand, double horSpeed, boolean limitSpeed) {
        this(TYPE, world);
        this.hand = hand;
        this.limitSpeed = limitSpeed;
        this.setConnectionAndPos(connection, start, linePos, horSpeed);
        Vector3d motion = this.func_213322_ci();
        float f1 = MathHelper.func_76133_a((double)(motion.field_72450_a * motion.field_72450_a + motion.field_72449_c * motion.field_72449_c));
        this.field_70177_z = (float)(Math.atan2(motion.field_72449_c, motion.field_72450_a) * 180.0 / Math.PI) + 90.0f;
        this.field_70125_A = (float)(Math.atan2(f1, motion.field_72448_b) * 180.0 / Math.PI) - 90.0f;
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
    }

    public void setConnectionAndPos(Connection c, ConnectionPoint start, double linePos, double speed) {
        c.generateCatenaryData(this.field_70170_p);
        this.linePos = linePos;
        this.horizontalSpeed = speed;
        this.connection = c;
        this.start = start;
        Vector3d pos = this.connection.getPoint(this.linePos, start).func_178787_e(Vector3d.func_237491_b_((Vector3i)start.getPosition()));
        this.func_70012_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, this.field_70177_z, this.field_70125_A);
        if (!this.connection.getCatenaryData().isVertical()) {
            this.angle = Math.atan2(this.connection.getCatenaryData().getDeltaZ(), this.connection.getCatenaryData().getDeltaX());
        }
        this.ignoreCollisions.clear();
        LocalWireNetwork net = GlobalWireNetwork.getNetwork(this.field_70170_p).getLocalNet(start);
        IImmersiveConnectable iicStart = net.getConnector(start);
        IImmersiveConnectable iicEnd = net.getConnector(c.getOtherEnd(start));
        if (iicStart != null && iicEnd != null) {
            this.ignoreCollisions.addAll(iicStart.getIgnored(iicEnd));
            this.ignoreCollisions.addAll(iicEnd.getIgnored(iicStart));
        }
    }

    protected void func_70088_a() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d1 = this.func_174813_aQ().func_72320_b() * 4.0;
        return distance < (d1 *= 64.0) * d1;
    }

    public void func_70071_h_() {
        double dz;
        double dy;
        double dx;
        int distTrvl;
        double inLineDirection;
        if (this.field_70173_aa == 1) {
            ImmersiveEngineering.proxy.startSkyhookSound(this);
        }
        PlayerEntity player = null;
        List list = this.func_184188_bt();
        if (!list.isEmpty() && list.get(0) instanceof PlayerEntity) {
            player = (PlayerEntity)list.get(0);
        }
        if (this.connection == null || player == null || this.hand != null && player.func_184586_b(this.hand).func_77973_b() != IEItems.Misc.skyhook) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
            return;
        }
        if (this.field_70173_aa % 5 == 0 && !this.field_70170_p.field_72995_K) {
            this.sendUpdatePacketTo(player);
        }
        PlayerUtils.resetFloatingState((Entity)player);
        boolean moved = false;
        if (this.connection.getCatenaryData().isVertical()) {
            inLineDirection = (double)(-player.field_191988_bg) * Math.sin(Math.toRadians(player.field_70125_A)) * Math.signum(this.connection.getCatenaryData().getDeltaY()) * this.getStartSignum();
        } else {
            float forward = player.field_191988_bg;
            double strafing = player.field_70702_br;
            double playerAngle = Math.toRadians(player.field_70177_z) + 1.5707963267948966;
            double angleToLine = playerAngle - this.angle;
            inLineDirection = (Math.cos(angleToLine) * (double)forward + Math.sin(angleToLine) * strafing) * this.getStartSignum();
        }
        if (inLineDirection != 0.0) {
            double slope = this.connection.getSlope(this.linePos, this.start);
            double slopeInDirection = Math.signum(inLineDirection) * slope;
            double speed = 0.1;
            double slopeFactor = 1.0;
            if (!this.connection.getCatenaryData().isVertical()) {
                double lambda = Math.atan(slopeInDirection) / 1.5707963267948966;
                speed = lambda * 0.1 + (1.0 - lambda) * 0.25;
                slopeFactor = 1.0 / Math.sqrt(1.0 + slope * slope);
            }
            if (slopeInDirection > -0.1) {
                this.horizontalSpeed = (3.0 * this.horizontalSpeed + inLineDirection * speed * slopeFactor) / 4.0;
                moved = true;
            }
        }
        ConnectionPoint switchingAtPos = null;
        if (!moved) {
            double deltaVHor;
            if (this.connection.getCatenaryData().isVertical()) {
                deltaVHor = -10.0 * Math.signum(this.connection.getCatenaryData().getDeltaY() * this.getStartSignum());
            } else {
                double realLinePos = this.connection.transformPosition(this.linePos, this.start);
                double param = (realLinePos * this.getHorizontalLength() - this.connection.getCatenaryData().getOffsetX()) / this.connection.getCatenaryData().getScale();
                double pos = Math.exp(param);
                double neg = 1.0 / pos;
                double cosh = (pos + neg) / 2.0;
                double sinh = (pos - neg) / 2.0;
                double vSquared = this.horizontalSpeed * this.horizontalSpeed * cosh * cosh * 20.0 * 20.0;
                deltaVHor = -sinh / (cosh * cosh) * (10.0 + vSquared / (this.connection.getCatenaryData().getScale() * cosh));
                if (this.connection.getEndB().equals(this.start)) {
                    deltaVHor *= -1.0;
                }
            }
            this.horizontalSpeed += deltaVHor / 400.0;
        }
        if (this.limitSpeed) {
            double max;
            double totSpeed = this.getSpeed();
            double d = max = this.limitSpeed ? 0.25 : 2.5;
            if (totSpeed > max) {
                this.horizontalSpeed *= max / totSpeed;
            }
        }
        double horSpeedToUse = this.horizontalSpeed;
        if (this.horizontalSpeed > 0.0) {
            double distToEnd = this.getHorizontalLength() * (1.0 - this.linePos);
            if (this.horizontalSpeed > distToEnd) {
                switchingAtPos = this.connection.getOtherEnd(this.start);
                horSpeedToUse = distToEnd;
            }
        } else {
            double distToStart = -this.getHorizontalLength() * this.linePos;
            if (this.horizontalSpeed < distToStart) {
                switchingAtPos = this.start;
                horSpeedToUse = distToStart;
            }
        }
        this.horizontalSpeed *= this.friction;
        this.linePos += horSpeedToUse / this.getHorizontalLength();
        Vector3d pos = this.connection.getPoint(this.linePos, this.start).func_178787_e(Vector3d.func_237491_b_((Vector3i)this.start.getPosition()));
        this.func_213293_j(pos.field_72450_a - this.func_226277_ct_(), pos.field_72449_c - this.func_226281_cx_(), pos.field_72448_b - this.func_226278_cu_());
        if (!this.isValidPosition(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, (LivingEntity)player)) {
            this.func_70106_y();
            return;
        }
        this.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        super.func_70071_h_();
        Vector3d motion = this.func_213322_ci();
        float f1 = MathHelper.func_76133_a((double)(motion.field_72450_a * motion.field_72450_a + motion.field_72449_c * motion.field_72449_c));
        this.field_70177_z = (float)(Math.atan2(motion.field_72449_c, motion.field_72450_a) * 180.0 / Math.PI) + 90.0f;
        this.field_70125_A = (float)(Math.atan2(f1, motion.field_72448_b) * 180.0 / Math.PI) - 90.0f;
        this.field_70127_C = this.field_70125_A - MathHelper.func_76142_g((float)(this.field_70125_A - this.field_70127_C));
        this.field_70126_B = this.field_70177_z - MathHelper.func_76142_g((float)(this.field_70177_z - this.field_70126_B));
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        if (this.func_70090_H()) {
            for (int j = 0; j < 4; ++j) {
                float f3 = 0.25f;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_() - motion.field_72450_a * (double)f3, this.func_226278_cu_() - motion.field_72448_b * (double)f3, this.func_226281_cx_() - motion.field_72449_c * (double)f3, motion.field_72450_a, motion.field_72448_b, motion.field_72449_c);
            }
        }
        if ((distTrvl = Math.round(MathHelper.func_76133_a((double)((dx = this.func_226277_ct_() - this.field_70169_q) * dx + (dy = this.func_226278_cu_() - this.field_70167_r) * dy + (dz = this.func_226281_cx_() - this.field_70166_s) * dz)) * 100.0f)) > 0) {
            player.func_195067_a(IEStats.SKYHOOK_DISTANCE, distTrvl);
        }
        this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        if (switchingAtPos != null) {
            this.switchConnection(switchingAtPos, player, horSpeedToUse);
        }
    }

    private void sendUpdatePacketTo(PlayerEntity player) {
        if (player instanceof ServerPlayerEntity) {
            ImmersiveEngineering.packetHandler.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageSkyhookSync(this));
        }
    }

    public void switchConnection(ConnectionPoint posForSwitch, PlayerEntity player, double lastHorSpeed) {
        Optional<Object> line = Optional.empty();
        LocalWireNetwork net = GlobalWireNetwork.getNetwork(this.field_70170_p).getLocalNet(posForSwitch);
        Collection<Connection> possible = net.getConnections(posForSwitch);
        if (possible != null) {
            Vector3d look = player.func_70040_Z();
            line = possible.stream().filter(c -> !c.equals(this.connection) && !c.isInternal()).max(Comparator.comparingDouble(c -> {
                c.generateCatenaryData(this.field_70170_p);
                double factor = posForSwitch.equals(c.getEndA()) ? 1.0 : -1.0;
                return c.getCatenaryData().getDelta().func_72432_b().func_72430_b(look) * factor;
            }));
        }
        if (line.isPresent()) {
            Connection newCon = (Connection)line.get();
            double oldSpeedPerHor = SkylineHookEntity.getSpeedPerHor(this.connection, posForSwitch, 0.0);
            double newSpeedPerHor = SkylineHookEntity.getSpeedPerHor(newCon, posForSwitch, 0.0);
            double horConversionFactor = oldSpeedPerHor / newSpeedPerHor;
            this.setConnectionAndPos(newCon, posForSwitch, Math.abs(this.horizontalSpeed - lastHorSpeed) * horConversionFactor, Math.abs(this.horizontalSpeed) * horConversionFactor);
            this.sendUpdatePacketTo(player);
        } else {
            this.func_70106_y();
        }
    }

    private static double getSpeedPerHor(Connection connection, ConnectionPoint start, double pos) {
        if (connection.getCatenaryData().isVertical()) {
            return 1.0;
        }
        double slope = connection.getSlope(pos, start);
        return Math.sqrt(slope * slope + 1.0);
    }

    public boolean isValidPosition(double x, double y, double z, @Nonnull LivingEntity player) {
        double tolerance = this.connection.getCatenaryData().isVertical() ? 5.0 : 10.0;
        double radius = player.func_213311_cf() / 2.0f;
        double height = player.func_213302_cg();
        double yOffset = this.func_70042_X() + player.func_70033_W();
        AxisAlignedBB playerBB = new AxisAlignedBB(x - radius, y + yOffset, z - radius, x + radius, y + yOffset + height, z + radius);
        double playerHeight = playerBB.field_72337_e - playerBB.field_72338_b;
        AxisAlignedBB feet = new AxisAlignedBB(playerBB.field_72340_a, playerBB.field_72338_b, playerBB.field_72339_c, playerBB.field_72336_d, playerBB.field_72338_b + 0.05 * playerHeight, playerBB.field_72334_f);
        List<VoxelShape> shapes = SkylineHelper.getCollisionBoxes((Entity)player, playerBB, this.field_70170_p, this.ignoreCollisions);
        double totalCollisionVolume = 0.0;
        double totalCollisionArea = 0.0;
        VoxelShape playerShape = VoxelShapes.func_197881_a((AxisAlignedBB)playerBB);
        double playerVolume = this.getVolume(playerShape);
        double playerArea = playerVolume / playerHeight;
        VoxelShape feetShape = VoxelShapes.func_197881_a((AxisAlignedBB)feet);
        for (VoxelShape shape : shapes) {
            VoxelShape intersection = VoxelShapes.func_197882_b((VoxelShape)playerShape, (VoxelShape)shape, (IBooleanFunction)IBooleanFunction.field_223238_i_);
            if ((totalCollisionVolume += this.getVolume(intersection)) * tolerance > playerVolume) {
                return false;
            }
            if (this.connection.getCatenaryData().isVertical() || !VoxelShapes.func_197879_c((VoxelShape)feetShape, (VoxelShape)shape, (IBooleanFunction)IBooleanFunction.field_223238_i_)) continue;
            VoxelShape feetIntersectShape = VoxelShapes.func_197882_b((VoxelShape)feetShape, (VoxelShape)shape, (IBooleanFunction)IBooleanFunction.field_223238_i_);
            for (AxisAlignedBB feetIntersect : feetIntersectShape.func_197756_d()) {
                totalCollisionArea += (feetIntersect.field_72336_d - feetIntersect.field_72340_a) * (feetIntersect.field_72334_f - feetIntersect.field_72339_c);
            }
            if (!(totalCollisionArea > 0.5 * playerArea)) continue;
            return false;
        }
        return true;
    }

    private double getVolume(VoxelShape shape) {
        return shape.func_197756_d().stream().mapToDouble(box -> (box.field_72336_d - box.field_72340_a) * (box.field_72337_e - box.field_72338_b) * (box.field_72334_f - box.field_72339_c)).sum();
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean func_82150_aj() {
        return true;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public double func_70042_X() {
        return -2.0;
    }

    protected void func_213281_b(CompoundNBT nbt) {
    }

    protected void func_70037_a(CompoundNBT nbt) {
    }

    public float func_70111_Y() {
        return 0.0f;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        this.func_70106_y();
        return true;
    }

    public boolean func_184186_bw() {
        return false;
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private void handleDismount(Entity passenger) {
        ItemStack held;
        passenger.func_70634_a(this.func_226277_ct_(), this.func_226278_cu_() + this.func_70042_X() + passenger.func_70033_W(), this.func_226281_cx_());
        passenger.func_213317_d(this.func_213322_ci());
        if (this.func_213322_ci().field_72448_b < 0.0) {
            passenger.field_70143_R = SkylineHelper.fallDistanceFromSpeed(this.func_213322_ci().field_72448_b);
            passenger.func_230245_c_(false);
        }
        passenger.getCapability(CapabilitySkyhookData.SKYHOOK_USER_DATA, Direction.UP).ifPresent(CapabilitySkyhookData.SkyhookUserData::release);
        if (this.hand != null && passenger instanceof PlayerEntity && (held = ((PlayerEntity)passenger).func_184586_b(this.hand)).func_77973_b() == IEItems.Misc.skyhook) {
            ((PlayerEntity)passenger).func_184811_cZ().func_185145_a(IEItems.Misc.skyhook, 10);
        }
    }

    protected void func_184225_p(Entity passenger) {
        super.func_184225_p(passenger);
        if (!this.field_70170_p.field_72995_K) {
            ApiUtils.addFutureServerTask(this.field_70170_p, () -> this.handleDismount(passenger));
        } else {
            ApiUtils.addFutureServerTask(this.field_70170_p, () -> this.handleDismount(passenger), true);
        }
    }

    public void func_70080_a(double x, double y, double z, float yaw, float pitch) {
    }

    public Connection getConnection() {
        return this.connection;
    }

    public double getSpeed() {
        if (this.connection == null) {
            return 0.0;
        }
        if (this.connection.getCatenaryData().isVertical()) {
            return Math.abs(this.horizontalSpeed);
        }
        double slope = this.connection.getSlope(this.linePos, this.start);
        return Math.abs(this.horizontalSpeed) * Math.sqrt(1.0 + slope * slope);
    }

    private double getHorizontalLength() {
        if (this.connection.getCatenaryData().isVertical()) {
            return Math.abs(this.connection.getCatenaryData().getDeltaY());
        }
        return this.connection.getCatenaryData().getHorLength();
    }

    private double getStartSignum() {
        if (this.start.equals(this.connection.getEndA())) {
            return 1.0;
        }
        return -1.0;
    }

    static {
        TYPE.setRegistryName("immersiveengineering", "skyline_hook");
    }
}

