/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.wires;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IConnectionTemplate;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.NetHandlerCapability;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.server.ServerWorld;

public class WireTemplateHelper {
    private static final String CONNECTIONS_KEY = "immersiveengineering:connections";

    public static void fillConnectionsInArea(World worldIn, BlockPos startPos, BlockPos size, IConnectionTemplate template) {
        template.getStoredConnections().clear();
        GlobalWireNetwork net = WireTemplateHelper.getNetwork(worldIn);
        if (net == null) {
            return;
        }
        BlockPos endPos = startPos.func_177971_a((Vector3i)size).func_177982_a(-1, -1, -1);
        MutableBoundingBox box = new MutableBoundingBox((Vector3i)startPos, (Vector3i)endPos);
        Vector3i offset = new Vector3i(box.field_78897_a, box.field_78895_b, box.field_78896_c);
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)startPos, (BlockPos)endPos)) {
            TileEntity te = worldIn.func_175625_s(pos);
            if (!(te instanceof IImmersiveConnectable)) continue;
            for (ConnectionPoint cp : ((IImmersiveConnectable)te).getConnectionPoints()) {
                for (Connection conn : net.getLocalNet(cp).getConnections(cp)) {
                    ConnectionPoint otherEnd;
                    if (conn.isInternal() || (otherEnd = conn.getOtherEnd(cp)).compareTo(cp) < 0 || !box.func_175898_b((Vector3i)otherEnd.getPosition())) continue;
                    template.getStoredConnections().add(new Connection(conn.type, new ConnectionPoint(pos.func_177973_b(offset), cp.getIndex()), new ConnectionPoint(otherEnd.getPosition().func_177973_b(offset), otherEnd.getIndex())));
                }
            }
        }
    }

    public static void addConnectionsFromTemplate(IServerWorld iworld, IConnectionTemplate template, PlacementSettings orientation, BlockPos startPos) {
        if (template.getStoredConnections().isEmpty()) {
            return;
        }
        ServerWorld world = iworld.func_201672_e();
        GlobalWireNetwork net = WireTemplateHelper.getNetwork((World)world);
        if (net == null) {
            return;
        }
        for (Connection relative : template.getStoredConnections()) {
            ConnectionPoint endA = WireTemplateHelper.getAbsolutePoint(relative.getEndA(), orientation, (World)world, startPos);
            ConnectionPoint endB = WireTemplateHelper.getAbsolutePoint(relative.getEndB(), orientation, (World)world, startPos);
            if (endA == null || endB == null) continue;
            net.addConnection(new Connection(relative.type, endA, endB));
        }
    }

    public static void addConnectionsToNBT(IConnectionTemplate template, CompoundNBT out) {
        if (template.getStoredConnections().isEmpty()) {
            return;
        }
        ListNBT connectionsNBT = new ListNBT();
        for (Connection c : template.getStoredConnections()) {
            connectionsNBT.add((Object)c.toNBT());
        }
        out.func_218657_a(CONNECTIONS_KEY, (INBT)connectionsNBT);
    }

    public static void readConnectionsFromNBT(CompoundNBT compound, IConnectionTemplate template) {
        ListNBT connectionsNBT = compound.func_150295_c(CONNECTIONS_KEY, 10);
        template.getStoredConnections().clear();
        for (int i = 0; i < connectionsNBT.size(); ++i) {
            template.getStoredConnections().add(new Connection(connectionsNBT.func_150305_b(i)));
        }
    }

    @Nullable
    private static ConnectionPoint getAbsolutePoint(ConnectionPoint relative, PlacementSettings orientation, World world, BlockPos base) {
        BlockPos absolutePos = Template.func_186266_a((PlacementSettings)orientation, (BlockPos)relative.getPosition()).func_177971_a((Vector3i)base);
        TileEntity connector = world.func_175625_s(absolutePos);
        if (!(connector instanceof IImmersiveConnectable)) {
            return null;
        }
        ConnectionPoint point = new ConnectionPoint(absolutePos, relative.getIndex());
        if (!((IImmersiveConnectable)connector).getConnectionPoints().contains(point)) {
            return null;
        }
        return point;
    }

    @Nullable
    private static GlobalWireNetwork getNetwork(World world) {
        return world.getCapability(NetHandlerCapability.NET_CAPABILITY).resolve().orElse(null);
    }
}

