/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tools.module;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.JukeboxTileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.handler.QuarkSounds;
import vazkii.quark.base.item.QuarkMusicDiscItem;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;

@LoadModule(category=ModuleCategory.TOOLS, hasSubscriptions=true)
public class AmbientDiscsModule
extends QuarkModule {
    @Config
    public static boolean dropOnSpiderKill = true;
    List<Item> discs = new ArrayList<Item>();

    @Override
    public void construct() {
        this.disc(QuarkSounds.AMBIENT_DRIPS);
        this.disc(QuarkSounds.AMBIENT_OCEAN);
        this.disc(QuarkSounds.AMBIENT_RAIN);
        this.disc(QuarkSounds.AMBIENT_WIND);
        this.disc(QuarkSounds.AMBIENT_FIRE);
        this.disc(QuarkSounds.AMBIENT_CLOCK);
        this.disc(QuarkSounds.AMBIENT_CRICKETS);
        this.disc(QuarkSounds.AMBIENT_CHATTER);
    }

    void disc(SoundEvent sound) {
        String name = sound.getRegistryName().func_110623_a().replaceAll(".+\\.", "");
        this.discs.add((Item)new QuarkMusicDiscItem(15, () -> sound, name, this, true));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onMobDeath(LivingDeathEvent event) {
        if (dropOnSpiderKill && event.getEntity() instanceof SpiderEntity && event.getSource().func_76346_g() instanceof SkeletonEntity) {
            Item item = this.discs.get(event.getEntity().field_70170_p.field_73012_v.nextInt(this.discs.size()));
            event.getEntity().func_199702_a((IItemProvider)item, 0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onJukeboxLoad(JukeboxTileEntity tile) {
        Minecraft mc = Minecraft.func_71410_x();
        WorldRenderer render = mc.field_71438_f;
        BlockPos pos = tile.func_174877_v();
        ISound sound = (ISound)render.field_147593_P.get(pos);
        SoundHandler soundEngine = mc.func_147118_V();
        if (sound == null || !soundEngine.func_215294_c(sound)) {
            if (sound != null) {
                soundEngine.func_147682_a(sound);
            } else {
                ItemStack stack = tile.func_195537_c();
                if (stack.func_77973_b() instanceof QuarkMusicDiscItem) {
                    ((QuarkMusicDiscItem)stack.func_77973_b()).playAmbientSound(pos);
                }
            }
        }
    }
}

