/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterstrongholds.world.processor;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.betterstrongholds.config.BSConfig;
import com.yungnickyoung.minecraft.betterstrongholds.init.BSModProcessors;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;

@MethodsReturnNonnullByDefault
public class TorchProcessor
extends StructureProcessor {
    public static final TorchProcessor INSTANCE = new TorchProcessor();
    public static final Codec<TorchProcessor> CODEC = Codec.unit(() -> INSTANCE);

    @ParametersAreNonnullByDefault
    public Template.BlockInfo process(IWorldReader worldReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, Template.BlockInfo blockInfoLocal, Template.BlockInfo blockInfoGlobal, PlacementSettings structurePlacementData, @Nullable Template template) {
        if (blockInfoGlobal.field_186243_b.func_203425_a(Blocks.field_150478_aa) || blockInfoGlobal.field_186243_b.func_203425_a(Blocks.field_196591_bQ)) {
            Random random = structurePlacementData.func_189947_a(blockInfoGlobal.field_186242_a);
            float replacementChance = this.getReplacementChance();
            if (random.nextFloat() > replacementChance) {
                blockInfoGlobal = new Template.BlockInfo(blockInfoGlobal.field_186242_a, Blocks.field_150350_a.func_176223_P(), blockInfoGlobal.field_186244_c);
            }
        }
        return blockInfoGlobal;
    }

    protected IStructureProcessorType<?> func_215192_a() {
        return BSModProcessors.TORCH_PROCESSOR;
    }

    private float getReplacementChance() {
        return ((Double)BSConfig.general.torchSpawnRate.get()).floatValue();
    }
}

