/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.core.metrics.Metrics;
import dan200.computercraft.shared.command.CommandUtils;
import dan200.computercraft.shared.command.Exceptions;
import dan200.computercraft.shared.command.UserLevel;
import dan200.computercraft.shared.command.arguments.ComputerArgumentType;
import dan200.computercraft.shared.command.arguments.ComputersArgumentType;
import dan200.computercraft.shared.command.arguments.TrackingFieldArgumentType;
import dan200.computercraft.shared.command.builder.CommandBuilder;
import dan200.computercraft.shared.command.builder.HelpingArgumentBuilder;
import dan200.computercraft.shared.command.text.ChatHelpers;
import dan200.computercraft.shared.command.text.TableBuilder;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.computer.inventory.ContainerViewComputer;
import dan200.computercraft.shared.computer.metrics.basic.Aggregate;
import dan200.computercraft.shared.computer.metrics.basic.AggregatedMetric;
import dan200.computercraft.shared.computer.metrics.basic.BasicComputerMetricsObserver;
import dan200.computercraft.shared.computer.metrics.basic.ComputerMetrics;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.server.SPlayerPositionLookPacket;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public final class CommandComputerCraft {
    public static final UUID SYSTEM_UUID = new UUID(0L, 0L);
    private static final int DUMP_LIST_ID = 0x520000;
    private static final int DUMP_SINGLE_ID = 1844510720;
    private static final int TRACK_ID = 373882880;
    private static final List<AggregatedMetric> DEFAULT_FIELDS = Arrays.asList(new AggregatedMetric(Metrics.COMPUTER_TASKS, Aggregate.COUNT), new AggregatedMetric(Metrics.COMPUTER_TASKS, Aggregate.NONE), new AggregatedMetric(Metrics.COMPUTER_TASKS, Aggregate.AVG));

    private CommandComputerCraft() {
    }

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)HelpingArgumentBuilder.choice("computercraft").then((ArgumentBuilder<CommandSource, ?>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"dump").requires((Predicate)UserLevel.OWNER_OP)).executes(context -> {
            TableBuilder table = new TableBuilder(0x520000, "Computer", "On", "Position");
            CommandSource source = (CommandSource)context.getSource();
            ArrayList<ServerComputer> computers = new ArrayList<ServerComputer>(ServerContext.get(source.func_197028_i()).registry().getComputers());
            ServerWorld world = source.func_197023_e();
            BlockPos pos = new BlockPos(source.func_197036_d());
            computers.sort((arg_0, arg_1) -> CommandComputerCraft.lambda$null$0((World)world, pos, arg_0, arg_1));
            for (ServerComputer computer : computers) {
                table.row(new ITextComponent[]{CommandComputerCraft.linkComputer(source, computer, computer.getID()), ChatHelpers.bool(computer.isOn()), CommandComputerCraft.linkPosition(source, computer)});
            }
            table.display((CommandSource)context.getSource());
            return computers.size();
        })).then(CommandBuilder.args().arg("computer", ComputerArgumentType.oneComputer()).executes((Command<CommandSource>)((Command)context -> {
            ServerComputer computer = ComputerArgumentType.getComputerArgument((CommandContext<CommandSource>)context, "computer");
            TableBuilder table = new TableBuilder(1844510720);
            table.row(new ITextComponent[]{ChatHelpers.header("Instance"), ChatHelpers.text(Integer.toString(computer.getInstanceID()))});
            table.row(new ITextComponent[]{ChatHelpers.header("Id"), ChatHelpers.text(Integer.toString(computer.getID()))});
            table.row(new ITextComponent[]{ChatHelpers.header("Label"), ChatHelpers.text(computer.getLabel())});
            table.row(new ITextComponent[]{ChatHelpers.header("On"), ChatHelpers.bool(computer.isOn())});
            table.row(new ITextComponent[]{ChatHelpers.header("Position"), CommandComputerCraft.linkPosition((CommandSource)context.getSource(), computer)});
            table.row(new ITextComponent[]{ChatHelpers.header("Family"), ChatHelpers.text(computer.getFamily().toString())});
            for (ComputerSide side : ComputerSide.values()) {
                IPeripheral peripheral = computer.getPeripheral(side);
                if (peripheral == null) continue;
                table.row(new ITextComponent[]{ChatHelpers.header("Peripheral " + side.getName()), ChatHelpers.text(peripheral.getType())});
            }
            table.display((CommandSource)context.getSource());
            return 1;
        })))).then(CommandBuilder.command("shutdown").requires(UserLevel.OWNER_OP).argManyValue("computers", ComputersArgumentType.manyComputers(), s -> ServerContext.get(s.func_197028_i()).registry().getComputers()).executes((context, computerSelectors) -> {
            int shutdown = 0;
            Set<ServerComputer> computers = ComputersArgumentType.unwrap((CommandSource)context.getSource(), computerSelectors);
            for (ServerComputer computer : computers) {
                if (computer.isOn()) {
                    ++shutdown;
                }
                computer.shutdown();
            }
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)ChatHelpers.translate("commands.computercraft.shutdown.done", shutdown, computers.size()), false);
            return shutdown;
        }))).then(CommandBuilder.command("turn-on").requires(UserLevel.OWNER_OP).argManyValue("computers", ComputersArgumentType.manyComputers(), s -> ServerContext.get(s.func_197028_i()).registry().getComputers()).executes((context, computerSelectors) -> {
            int on = 0;
            Set<ServerComputer> computers = ComputersArgumentType.unwrap((CommandSource)context.getSource(), computerSelectors);
            for (ServerComputer computer : computers) {
                if (!computer.isOn()) {
                    ++on;
                }
                computer.turnOn();
            }
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)ChatHelpers.translate("commands.computercraft.turn_on.done", on, computers.size()), false);
            return on;
        }))).then(CommandBuilder.command("tp").requires(UserLevel.OP).arg("computer", ComputerArgumentType.oneComputer()).executes((Command<CommandSource>)((Command)context -> {
            ServerComputer computer = ComputerArgumentType.getComputerArgument((CommandContext<CommandSource>)context, "computer");
            ServerWorld world = computer.getWorld();
            BlockPos pos = computer.getPosition();
            if (world == null || pos == null) {
                throw Exceptions.TP_NOT_THERE.create();
            }
            Entity entity = ((CommandSource)context.getSource()).func_197027_g();
            if (!(entity instanceof ServerPlayerEntity)) {
                throw Exceptions.TP_NOT_PLAYER.create();
            }
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            if (player.func_130014_f_() == world) {
                player.field_71135_a.func_175089_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f, EnumSet.noneOf(SPlayerPositionLookPacket.Flags.class));
            } else {
                player.func_200619_a(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
            }
            return 1;
        })))).then(CommandBuilder.command("queue").requires(UserLevel.ANYONE).arg("computer", ComputersArgumentType.manyComputers()).argManyValue("args", StringArgumentType.string(), Collections.emptyList()).executes((ctx, args) -> {
            Collection<ServerComputer> computers = ComputersArgumentType.getComputersArgument((CommandContext<CommandSource>)ctx, "computer");
            Object[] rest = args.toArray();
            int queued = 0;
            for (ServerComputer computer : computers) {
                if (computer.getFamily() != ComputerFamily.COMMAND || !computer.isOn()) continue;
                computer.queueEvent("computer_command", rest);
                ++queued;
            }
            return queued;
        }))).then(CommandBuilder.command("view").requires(UserLevel.OP).arg("computer", ComputerArgumentType.oneComputer()).executes((Command<CommandSource>)((Command)context -> {
            ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
            final ServerComputer computer = ComputerArgumentType.getComputerArgument((CommandContext<CommandSource>)context, "computer");
            new ComputerContainerData(computer, ItemStack.field_190927_a).open((PlayerEntity)player, new INamedContainerProvider(){

                @Nonnull
                public ITextComponent func_145748_c_() {
                    return new TranslationTextComponent("gui.computercraft.view_computer");
                }

                @Nonnull
                public Container createMenu(int id, @Nonnull PlayerInventory player, @Nonnull PlayerEntity entity) {
                    return new ContainerViewComputer(id, player, computer);
                }
            });
            return 1;
        })))).then(((LiteralArgumentBuilder)HelpingArgumentBuilder.choice("track").then(CommandBuilder.command("start").requires(UserLevel.OWNER_OP).executes((Command<CommandSource>)((Command)context -> {
            CommandComputerCraft.getMetricsInstance((CommandSource)context.getSource()).start();
            String stopCommand = "/computercraft track stop";
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)ChatHelpers.translate("commands.computercraft.track.start.stop", ChatHelpers.link(ChatHelpers.text(stopCommand), stopCommand, (ITextComponent)ChatHelpers.translate("commands.computercraft.track.stop.action"))), false);
            return 1;
        }))).then(CommandBuilder.command("stop").requires(UserLevel.OWNER_OP).executes((Command<CommandSource>)((Command)context -> {
            BasicComputerMetricsObserver timings = CommandComputerCraft.getMetricsInstance((CommandSource)context.getSource());
            if (!timings.stop()) {
                throw Exceptions.NOT_TRACKING_EXCEPTION.create();
            }
            CommandComputerCraft.displayTimings((CommandSource)context.getSource(), timings.getSnapshot(), new AggregatedMetric(Metrics.COMPUTER_TASKS, Aggregate.AVG), DEFAULT_FIELDS);
            return 1;
        })))).then(CommandBuilder.command("dump").requires(UserLevel.OWNER_OP).argManyValue("fields", TrackingFieldArgumentType.metric(), DEFAULT_FIELDS).executes((context, fields) -> {
            AggregatedMetric sort;
            if (fields.size() == 1 && DEFAULT_FIELDS.contains(fields.get(0))) {
                sort = (AggregatedMetric)fields.get(0);
                fields = DEFAULT_FIELDS;
            } else {
                sort = (AggregatedMetric)fields.get(0);
            }
            return CommandComputerCraft.displayTimings((CommandSource)context.getSource(), sort, fields);
        }))));
    }

    private static ITextComponent linkComputer(CommandSource source, ServerComputer serverComputer, int computerId) {
        ITextComponent linkPath;
        StringTextComponent out = new StringTextComponent("");
        if (serverComputer == null) {
            out.func_230529_a_((ITextComponent)ChatHelpers.text("?"));
        } else {
            out.func_230529_a_(ChatHelpers.link(ChatHelpers.text(Integer.toString(serverComputer.getInstanceID())), "/computercraft dump " + serverComputer.getInstanceID(), (ITextComponent)ChatHelpers.translate("commands.computercraft.dump.action")));
        }
        out.func_240702_b_(" (id " + computerId + ")");
        if (serverComputer != null && UserLevel.OP.test(source) && CommandUtils.isPlayer(source)) {
            out.func_240702_b_(" ").func_230529_a_(ChatHelpers.link(ChatHelpers.text("\u261b"), "/computercraft tp " + serverComputer.getInstanceID(), (ITextComponent)ChatHelpers.translate("commands.computercraft.tp.action"))).func_240702_b_(" ").func_230529_a_(ChatHelpers.link(ChatHelpers.text("\u20e2"), "/computercraft view " + serverComputer.getInstanceID(), (ITextComponent)ChatHelpers.translate("commands.computercraft.view.action")));
        }
        if (UserLevel.OWNER.test(source) && CommandUtils.isPlayer(source) && (linkPath = CommandComputerCraft.linkStorage(source, computerId)) != null) {
            out.func_240702_b_(" ").func_230529_a_(linkPath);
        }
        return out;
    }

    private static ITextComponent linkPosition(CommandSource context, ServerComputer computer) {
        if (UserLevel.OP.test(context)) {
            return ChatHelpers.link(ChatHelpers.position(computer.getPosition()), "/computercraft tp " + computer.getInstanceID(), (ITextComponent)ChatHelpers.translate("commands.computercraft.tp.action"));
        }
        return ChatHelpers.position(computer.getPosition());
    }

    private static ITextComponent linkStorage(CommandSource source, int id) {
        File file = new File(ServerContext.get(source.func_197028_i()).storageDir().toFile(), "computer/" + id);
        if (!file.isDirectory()) {
            return null;
        }
        return ChatHelpers.link(ChatHelpers.text("\u270e"), "/computercraft open-computer " + id, (ITextComponent)ChatHelpers.translate("commands.computercraft.dump.open_path"));
    }

    @Nonnull
    private static BasicComputerMetricsObserver getMetricsInstance(CommandSource source) {
        Entity entity = source.func_197022_f();
        return ServerContext.get(source.func_197028_i()).metrics().getMetricsInstance(entity instanceof PlayerEntity ? entity.func_110124_au() : SYSTEM_UUID);
    }

    private static int displayTimings(CommandSource source, AggregatedMetric sortField, List<AggregatedMetric> fields) throws CommandSyntaxException {
        return CommandComputerCraft.displayTimings(source, CommandComputerCraft.getMetricsInstance(source).getTimings(), sortField, fields);
    }

    private static int displayTimings(CommandSource source, List<ComputerMetrics> timings, AggregatedMetric sortField, List<AggregatedMetric> fields) throws CommandSyntaxException {
        if (timings.isEmpty()) {
            throw Exceptions.NO_TIMINGS_EXCEPTION.create();
        }
        timings.sort(Comparator.comparing(x -> x.get(sortField.metric(), sortField.aggregate())).reversed());
        ITextComponent[] headers = new ITextComponent[1 + fields.size()];
        headers[0] = ChatHelpers.translate("commands.computercraft.track.dump.computer");
        for (int i = 0; i < fields.size(); ++i) {
            headers[i + 1] = fields.get(i).displayName();
        }
        TableBuilder table = new TableBuilder(373882880, headers);
        for (ComputerMetrics entry : timings) {
            ServerComputer serverComputer = entry.computer();
            ITextComponent computerComponent = CommandComputerCraft.linkComputer(source, serverComputer, entry.computerId());
            ITextComponent[] row = new ITextComponent[1 + fields.size()];
            row[0] = computerComponent;
            for (int i = 0; i < fields.size(); ++i) {
                AggregatedMetric metric = fields.get(i);
                row[i + 1] = ChatHelpers.text(entry.getFormatted(metric.metric(), metric.aggregate()));
            }
            table.row(row);
        }
        table.display(source);
        return timings.size();
    }

    private static /* synthetic */ int lambda$null$0(World world, BlockPos pos, ServerComputer a, ServerComputer b) {
        if (a.getWorld() == b.getWorld() && a.getWorld() == world) {
            return Double.compare(a.getPosition().func_177951_i((Vector3i)pos), b.getPosition().func_177951_i((Vector3i)pos));
        }
        if (a.getWorld() == world) {
            return -1;
        }
        if (b.getWorld() == world) {
            return 1;
        }
        return Integer.compare(a.getInstanceID(), b.getInstanceID());
    }
}

