/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.surfacebuilders;

import biomesoplenty.common.world.AlphaOctavePerlinNoise;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class OriginValleySurfaceBuilder
extends SurfaceBuilder<SurfaceBuilderConfig> {
    protected long seed;
    protected AlphaOctavePerlinNoise sandNoise;
    protected AlphaOctavePerlinNoise gravelNoise;

    public OriginValleySurfaceBuilder(Codec<SurfaceBuilderConfig> p_i232124_1_) {
        super(p_i232124_1_);
    }

    public void apply(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        this.apply(random, chunkIn, biomeIn, x, z, startHeight, noise, defaultBlock, defaultFluid, config.func_204108_a(), config.func_204109_b(), config.func_204110_c(), seaLevel);
    }

    protected void apply(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, BlockState top, BlockState middle, BlockState bottom, int sealevel) {
        BlockState topState = top;
        BlockState middleState = middle;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        int placedDepth = -1;
        int grassDepth = (int)(noise / 3.0 + 3.0 + random.nextDouble() * 0.25);
        int localX = x & 0xF;
        int localZ = z & 0xF;
        boolean gravelGen = this.gravelNoise.sample(x, 109.0134, z, 0.03125, 1.0, 0.03125) + random.nextDouble() * 0.2 > 3.0;
        boolean sandGen = this.sandNoise.sample(x, z, 0.0, 0.03125, 0.03125, 1.0) + random.nextDouble() * 0.2 > 0.0;
        for (int y = startHeight; y >= 0; --y) {
            mutable.func_181079_c(localX, y, localZ);
            BlockState blockstate2 = chunkIn.func_180495_p((BlockPos)mutable);
            if (blockstate2.func_196958_f()) {
                placedDepth = -1;
                continue;
            }
            if (!blockstate2.func_203425_a(defaultBlock.func_177230_c())) continue;
            if (placedDepth == -1) {
                if (grassDepth <= 0) {
                    topState = Blocks.field_150350_a.func_176223_P();
                    middleState = defaultBlock;
                } else if (y >= sealevel - 4 && y <= sealevel + 1) {
                    topState = top;
                    middleState = middle;
                    if (gravelGen) {
                        topState = Blocks.field_150350_a.func_176223_P();
                        middleState = Blocks.field_150351_n.func_176223_P();
                    }
                    if (sandGen) {
                        topState = Blocks.field_150354_m.func_176223_P();
                        middleState = Blocks.field_150354_m.func_176223_P();
                    }
                }
                if (y < sealevel && (topState == null || topState.func_196958_f())) {
                    topState = biomeIn.func_225486_c((BlockPos)mutable.func_181079_c(x, y, z)) < 0.15f ? Blocks.field_150432_aD.func_176223_P() : defaultFluid;
                    mutable.func_181079_c(localX, y, localZ);
                }
                placedDepth = grassDepth;
                if (y >= sealevel - 1) {
                    chunkIn.func_177436_a((BlockPos)mutable, topState, false);
                    continue;
                }
                chunkIn.func_177436_a((BlockPos)mutable, middleState, false);
                continue;
            }
            if (placedDepth <= 0) continue;
            --placedDepth;
            chunkIn.func_177436_a((BlockPos)mutable, middleState, false);
        }
    }

    public void func_205548_a(long seed) {
        if (this.seed != seed || this.sandNoise == null || this.gravelNoise == null) {
            SharedSeedRandom random = new SharedSeedRandom(seed);
            this.sandNoise = new AlphaOctavePerlinNoise((Random)random, 4);
            this.gravelNoise = new AlphaOctavePerlinNoise((Random)random, 4);
        }
        this.seed = seed;
    }
}

