/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.inventory.container;

import cofh.core.inventory.container.TileContainer;
import cofh.core.network.packet.server.ContainerPacket;
import cofh.core.util.filter.AbstractItemFilter;
import cofh.lib.inventory.container.slot.SlotFalseCopy;
import cofh.lib.inventory.wrapper.InvWrapperGeneric;
import cofh.lib.util.filter.IFilterOptions;
import cofh.lib.util.filter.IFilterableTile;
import cofh.lib.util.helpers.FilterHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.references.CoreReferences;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileItemFilterContainer
extends TileContainer
implements IFilterOptions {
    protected final IFilterableTile filterable;
    protected AbstractItemFilter filter;
    protected InvWrapperGeneric filterInventory;

    public TileItemFilterContainer(int windowId, World world, BlockPos pos, PlayerInventory inventory, PlayerEntity player) {
        super(CoreReferences.TILE_ITEM_FILTER_CONTAINER, windowId, world, pos, inventory, player);
        this.allowSwap = false;
        this.filterable = (IFilterableTile)world.func_175625_s(pos);
        this.filter = (AbstractItemFilter)this.filterable.getFilter();
        int slots = this.filter.size();
        this.filterInventory = new InvWrapperGeneric(this, this.filter.getItems(), slots);
        int rows = MathHelper.clamp(slots / 3, 1, 3);
        int rowSize = slots / rows;
        int xOffset = 62 - 9 * rowSize;
        int yOffset = 44 - 9 * rows;
        for (int i = 0; i < this.filter.size(); ++i) {
            this.func_75146_a(new SlotFalseCopy(this.filterInventory, i, xOffset + i % rowSize * 18, yOffset + i / rowSize * 18));
        }
        this.bindPlayerInventory(inventory);
    }

    public IFilterableTile getFilterableTile() {
        return this.filterable;
    }

    public int getFilterSize() {
        return this.filter.size();
    }

    @Override
    protected int getMergeableSlotCount() {
        return this.filterInventory.func_70302_i_();
    }

    @Override
    public boolean func_75145_c(PlayerEntity player) {
        if (!FilterHelper.hasFilter(this.filterable)) {
            return false;
        }
        return super.func_75145_c(player);
    }

    @Override
    public void func_75134_a(PlayerEntity playerIn) {
        this.filter.setItems(this.filterInventory.getStacks());
        this.filterable.onFilterChanged();
        super.func_75134_a(playerIn);
    }

    @Override
    public PacketBuffer getContainerPacket(PacketBuffer buffer) {
        buffer.writeBoolean(this.getAllowList());
        buffer.writeBoolean(this.getCheckNBT());
        return buffer;
    }

    @Override
    public void handleContainerPacket(PacketBuffer buffer) {
        this.filter.setAllowList(buffer.readBoolean());
        this.filter.setCheckNBT(buffer.readBoolean());
    }

    @Override
    public boolean getAllowList() {
        return this.filter.getAllowList();
    }

    @Override
    public boolean setAllowList(boolean allowList) {
        boolean ret = this.filter.setAllowList(allowList);
        ContainerPacket.sendToServer(this);
        return ret;
    }

    @Override
    public boolean getCheckNBT() {
        return this.filter.getCheckNBT();
    }

    @Override
    public boolean setCheckNBT(boolean checkNBT) {
        boolean ret = this.filter.setCheckNBT(checkNBT);
        ContainerPacket.sendToServer(this);
        return ret;
    }
}

