/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.crafting;

import cofh.core.CoFHCore;
import cofh.lib.util.control.ISecurable;
import cofh.lib.util.helpers.SecurityHelper;
import cofh.lib.util.references.ItemTagsCoFH;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class SecureRecipe
extends SpecialRecipe {
    public SecureRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        Ingredient ingredientSecure = Ingredient.func_199805_a(ItemTagsCoFH.LOCKS);
        Ingredient ingredientSecurable = Ingredient.func_199805_a(ItemTagsCoFH.SECURABLE);
        boolean lockItem = false;
        boolean securableItem = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (ingredientSecure.test(stack)) {
                lockItem = true;
                continue;
            }
            if (!ingredientSecurable.test(stack) || SecurityHelper.hasSecurity(stack)) continue;
            securableItem = true;
        }
        return lockItem && securableItem;
    }

    public ItemStack assemble(CraftingInventory inv) {
        Ingredient ingredientSecurable = Ingredient.func_199805_a(ItemTagsCoFH.SECURABLE);
        ItemStack result = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !ingredientSecurable.test(stack)) continue;
            result = stack.func_77946_l();
            break;
        }
        if (!result.func_190926_b()) {
            SecurityHelper.createSecurityTag(result);
            SecurityHelper.setAccess(result, ISecurable.AccessMode.PUBLIC);
        }
        return result;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return CoFHCore.RECIPE_SERIALIZERS.get("crafting_securable");
    }
}

