/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.fluid;

import cofh.lib.item.ContainerType;
import cofh.lib.item.IContainerItem;
import cofh.lib.util.helpers.MathHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public interface IFluidContainerItem
extends IContainerItem {
    default public CompoundNBT getOrCreateTankTag(ItemStack container) {
        return container.func_196082_o();
    }

    default public int getSpace(ItemStack container) {
        return this.getCapacity(container) - this.getFluidAmount(container);
    }

    default public int getScaledFluidStored(ItemStack container, int scale) {
        return MathHelper.round((double)this.getFluidAmount(container) * (double)scale / (double)this.getCapacity(container));
    }

    default public int getFluidAmount(ItemStack container) {
        return this.getFluid(container).getAmount();
    }

    default public FluidStack getFluid(ItemStack container) {
        CompoundNBT tag = this.getOrCreateTankTag(container);
        if (!tag.func_74764_b("Fluid")) {
            return FluidStack.EMPTY;
        }
        return FluidStack.loadFluidStackFromNBT((CompoundNBT)tag.func_74775_l("Fluid"));
    }

    default public boolean isFluidValid(ItemStack container, FluidStack resource) {
        return true;
    }

    public int getCapacity(ItemStack var1);

    default public int fill(ItemStack container, FluidStack resource, IFluidHandler.FluidAction action) {
        CompoundNBT containerTag = this.getOrCreateTankTag(container);
        if (resource.isEmpty() || !this.isFluidValid(container, resource)) {
            return 0;
        }
        int capacity = this.getCapacity(container);
        if (this.isCreative(container, ContainerType.FLUID)) {
            if (action.execute()) {
                CompoundNBT fluidTag = resource.writeToNBT(new CompoundNBT());
                fluidTag.func_74768_a("Amount", capacity);
                containerTag.func_218657_a("Fluid", (INBT)fluidTag);
            }
            return resource.getAmount();
        }
        if (action.simulate()) {
            if (!containerTag.func_74764_b("Fluid")) {
                return Math.min(capacity, resource.getAmount());
            }
            FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundNBT)containerTag.func_74775_l("Fluid"));
            if (stack.isEmpty()) {
                return Math.min(capacity, resource.getAmount());
            }
            if (!stack.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(capacity - stack.getAmount(), resource.getAmount());
        }
        if (!containerTag.func_74764_b("Fluid")) {
            CompoundNBT fluidTag = resource.writeToNBT(new CompoundNBT());
            if (capacity < resource.getAmount()) {
                fluidTag.func_74768_a("Amount", capacity);
                containerTag.func_218657_a("Fluid", (INBT)fluidTag);
                return capacity;
            }
            fluidTag.func_74768_a("Amount", resource.getAmount());
            containerTag.func_218657_a("Fluid", (INBT)fluidTag);
            return resource.getAmount();
        }
        CompoundNBT fluidTag = containerTag.func_74775_l("Fluid");
        FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundNBT)fluidTag);
        if (stack.isEmpty() || !stack.isFluidEqual(resource)) {
            return 0;
        }
        int filled = capacity - stack.getAmount();
        if (resource.getAmount() < filled) {
            stack.grow(resource.getAmount());
            filled = resource.getAmount();
        } else {
            stack.setAmount(capacity);
        }
        containerTag.func_218657_a("Fluid", (INBT)stack.writeToNBT(fluidTag));
        return filled;
    }

    default public FluidStack drain(ItemStack container, int maxDrain, IFluidHandler.FluidAction action) {
        int drained;
        CompoundNBT containerTag = this.getOrCreateTankTag(container);
        if (maxDrain <= 0 || !containerTag.func_74764_b("Fluid")) {
            return FluidStack.EMPTY;
        }
        FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundNBT)containerTag.func_74775_l("Fluid"));
        if (stack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        boolean creative = this.isCreative(container, ContainerType.FLUID);
        int n = drained = creative ? maxDrain : Math.min(stack.getAmount(), maxDrain);
        if (action.execute() && !creative) {
            if (maxDrain >= stack.getAmount()) {
                containerTag.func_82580_o("Fluid");
                return stack;
            }
            CompoundNBT fluidTag = containerTag.func_74775_l("Fluid");
            fluidTag.func_74768_a("Amount", fluidTag.func_74762_e("Amount") - drained);
            containerTag.func_218657_a("Fluid", (INBT)fluidTag);
        }
        stack.setAmount(drained);
        return stack;
    }
}

