/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;

public class ColorHelper {
    private ColorHelper() {
    }

    public static int getColorFrom(ResourceLocation location) {
        AtlasTexture textureMap = Minecraft.func_71410_x().func_209506_al().func_229356_a_(AtlasTexture.field_110575_b);
        TextureAtlasSprite sprite = textureMap.func_195424_a(location);
        return ColorHelper.getColorFrom(sprite);
    }

    public static int getColorFrom(TextureAtlasSprite sprite) {
        if (sprite == null) {
            return -1;
        }
        if (sprite.func_110970_k() == 0) {
            return -1;
        }
        int[][] pixelMatrix = new int[][]{{0}};
        int total = 0;
        int red = 0;
        int blue = 0;
        int green = 0;
        for (int pixel : pixelMatrix[pixelMatrix.length - 1]) {
            Color color = new Color(pixel);
            if (color.getAlpha() < 255) continue;
            ++total;
            red += color.getRed();
            green += color.getGreen();
            blue += color.getBlue();
        }
        if (total > 0) {
            return new Color(red / total, green / total, blue / total, 255).getRGB();
        }
        return -1;
    }

    public static int getColorFrom(TextureAtlasSprite sprite, Color filter) {
        if (sprite == null) {
            return -1;
        }
        if (sprite.func_110970_k() == 0) {
            return -1;
        }
        int[][] pixelMatrix = new int[][]{{0}};
        int total = 0;
        int red = 0;
        int blue = 0;
        int green = 0;
        for (int pixel : pixelMatrix[pixelMatrix.length - 1]) {
            Color color = new Color(pixel);
            if (color.getAlpha() < 255 || color.getRGB() - filter.getRGB() < 100 && color.getRGB() - filter.getRGB() > 100) continue;
            ++total;
            red += color.getRed();
            green += color.getGreen();
            blue += color.getBlue();
        }
        if (total > 0) {
            return new Color(red / total, green / total, blue / total, 255).brighter().getRGB();
        }
        return -1;
    }
}

