/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.common.advancement.modification;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.minecraftabnormals.abnormals_core.common.advancement.modification.ConfiguredAdvancementModifier;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.advancements.Advancement;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.util.JSONUtils;

public abstract class AdvancementModifier<C> {
    private final Deserializer<C> deserializer;

    protected AdvancementModifier(Deserializer<C> deserializer) {
        this.deserializer = deserializer;
    }

    public Deserializer<C> getDeserializer() {
        return this.deserializer;
    }

    public final ConfiguredAdvancementModifier<C, AdvancementModifier<C>> deserialize(JsonElement config, ConditionArrayParser conditionArrayParser) throws JsonParseException {
        return new ConfiguredAdvancementModifier<C, AdvancementModifier>(this, this.deserializer.deserialize(config, conditionArrayParser));
    }

    public abstract void modify(Advancement.Builder var1, C var2);

    @FunctionalInterface
    protected static interface Deserializer<C> {
        public C deserialize(JsonElement var1, ConditionArrayParser var2) throws JsonParseException;
    }

    public static enum Mode {
        MODIFY("modify"),
        REPLACE("replace");

        private static final Map<String, Mode> VALUES_MAP;
        private final String name;

        private Mode(String name) {
            this.name = name;
        }

        public static Mode deserialize(JsonObject object) throws JsonParseException {
            String string = JSONUtils.func_151200_h((JsonObject)object, (String)"mode");
            Mode mode = VALUES_MAP.get(string);
            if (mode == null) {
                throw new JsonParseException("Unknown mode type: " + string);
            }
            return mode;
        }

        public String getName() {
            return this.name;
        }

        static {
            VALUES_MAP = Arrays.stream(Mode.values()).collect(Collectors.toMap(Mode::getName, mode -> mode));
        }
    }
}

