/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.endimator.entity;

import com.minecraftabnormals.abnormals_core.core.endimator.Endimation;
import com.minecraftabnormals.abnormals_core.core.endimator.entity.IEndimatedEntity;
import com.minecraftabnormals.abnormals_core.core.util.NetworkUtil;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public abstract class EndimatedEntity
extends CreatureEntity
implements IEndimatedEntity {
    private Endimation endimation = BLANK_ANIMATION;
    private int animationTick;

    public EndimatedEntity(EntityType<? extends CreatureEntity> type, World world) {
        super(type, world);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.endimateTick();
        if (this.func_110143_aJ() <= 0.0f) {
            Endimation deathEndimation = this.getDeathAnimation();
            if (deathEndimation != null) {
                if (this.func_70613_aW() && !this.isEndimationPlaying(deathEndimation)) {
                    NetworkUtil.setPlayingAnimationMessage(this, deathEndimation);
                }
                this.onEndimatedDeathUpdate(deathEndimation.getAnimationTickDuration());
            } else {
                this.onEndimatedDeathUpdate(20);
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.isWorldRemote() && this.getHurtAnimation() != null && this.isNoEndimationPlaying()) {
            NetworkUtil.setPlayingAnimationMessage(this, this.getHurtAnimation());
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_70609_aI() {
    }

    private void onEndimatedDeathUpdate(int deathAnimationDuration) {
        if (this.field_70725_aQ++ >= deathAnimationDuration - 1) {
            this.func_70106_y();
            this.addDeathEffects();
        }
    }

    protected void addDeathEffects() {
        for (int i = 0; i < 20; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, this.func_226282_d_(1.0), this.func_226279_cv_(), this.func_226287_g_(1.0), this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02);
        }
    }

    @Override
    public void setPlayingEndimation(Endimation endimationToPlay) {
        this.onEndimationEnd(this.endimation);
        this.endimation = endimationToPlay;
        this.setAnimationTick(0);
    }

    @Override
    public Endimation getPlayingEndimation() {
        return this.endimation;
    }

    @Override
    public boolean isEndimationPlaying(Endimation endimation) {
        return this.getPlayingEndimation() == endimation;
    }

    public boolean isWorldRemote() {
        return this.func_130014_f_().field_72995_K;
    }

    @Override
    public int getAnimationTick() {
        return this.animationTick;
    }

    @Override
    public void setAnimationTick(int animationTick) {
        this.animationTick = animationTick;
    }

    @Override
    public void resetEndimation() {
        this.setPlayingEndimation(BLANK_ANIMATION);
    }

    @Nullable
    public Endimation getHurtAnimation() {
        return null;
    }

    @Nullable
    public Endimation getDeathAnimation() {
        return null;
    }

    public Vector3d getMoveControllerPathDistance(double pathX, double pathY, double pathZ) {
        return new Vector3d(pathX - this.func_226277_ct_(), pathY - this.func_226278_cu_(), pathY - this.func_226278_cu_());
    }

    public float getTargetAngleForPathDistance(Vector3d Vector3d2) {
        return (float)(MathHelper.func_181159_b((double)Vector3d2.field_72449_c, (double)Vector3d2.field_72450_a) * 57.2957763671875) - 90.0f;
    }
}

