/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.minecraftabnormals.abnormals_core.common.world.gen.EdgeBiomeProvider;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.INoiseRandom;

public final class BiomeUtil {
    private static final Map<RegistryKey<Biome>, WeightedNoiseList<RegistryKey<Biome>>> HILL_BIOME_MAP = new HashMap<RegistryKey<Biome>, WeightedNoiseList<RegistryKey<Biome>>>();
    private static final Map<OceanType, WeightedNoiseList<RegistryKey<Biome>>> OCEAN_BIOME_MAP = new HashMap<OceanType, WeightedNoiseList<RegistryKey<Biome>>>();
    private static final Map<RegistryKey<Biome>, RegistryKey<Biome>> DEEP_OCEAN_BIOME_MAP = new HashMap<RegistryKey<Biome>, RegistryKey<Biome>>();
    private static final Set<RegistryKey<Biome>> OCEAN_SET = new HashSet<RegistryKey<Biome>>();
    private static final Set<RegistryKey<Biome>> SHALLOW_OCEAN_SET = new HashSet<RegistryKey<Biome>>();
    private static final Map<RegistryKey<Biome>, PrioritizedNoiseList<EdgeBiomeProvider>> EDGE_BIOME_PROVIDER_MAP = new HashMap<RegistryKey<Biome>, PrioritizedNoiseList<EdgeBiomeProvider>>();
    private static final WeightedNoiseList<RegistryKey<Biome>> END_BIOMES = new WeightedNoiseList();
    private static final List<Pair<Biome.Attributes, RegistryKey<Biome>>> NETHER_BIOMES = new ArrayList<Pair<Biome.Attributes, RegistryKey<Biome>>>();
    private static final Set<ResourceLocation> CUSTOM_END_MUSIC_BIOMES = new HashSet<ResourceLocation>();

    @SafeVarargs
    public static synchronized void addHillBiome(RegistryKey<Biome> biome, Pair<RegistryKey<Biome>, Integer> ... hills) {
        WeightedNoiseList list = HILL_BIOME_MAP.computeIfAbsent(biome, key -> new WeightedNoiseList());
        for (Pair<RegistryKey<Biome>, Integer> hill : hills) {
            list.add(hill.getFirst(), (Integer)hill.getSecond());
        }
    }

    public static synchronized void addEndBiome(RegistryKey<Biome> key, int weight) {
        END_BIOMES.add(key, weight);
    }

    public static synchronized void markEndBiomeCustomMusic(ResourceLocation biomeName) {
        CUSTOM_END_MUSIC_BIOMES.add(biomeName);
    }

    public static synchronized void addOceanBiome(OceanType type, RegistryKey<Biome> biome, @Nullable RegistryKey<Biome> deep, int weight) {
        OCEAN_BIOME_MAP.computeIfAbsent(type, key -> new WeightedNoiseList()).add(biome, weight);
        OCEAN_SET.add(biome);
        SHALLOW_OCEAN_SET.add(biome);
        if (deep != null) {
            DEEP_OCEAN_BIOME_MAP.put(biome, deep);
            OCEAN_SET.add(biome);
        }
    }

    public static synchronized void addEdgeBiome(RegistryKey<Biome> key, EdgeBiomeProvider provider, Priority priority) {
        EDGE_BIOME_PROVIDER_MAP.computeIfAbsent(key, k -> new PrioritizedNoiseList()).add(provider, priority);
    }

    public static synchronized void addNetherBiome(Biome.Attributes attributes, RegistryKey<Biome> biome) {
        NETHER_BIOMES.add((Pair<Biome.Attributes, RegistryKey<Biome>>)Pair.of((Object)attributes, biome));
    }

    @Nullable
    public static RegistryKey<Biome> getHillBiome(RegistryKey<Biome> biome, INoiseRandom random) {
        WeightedNoiseList<RegistryKey<Biome>> list = HILL_BIOME_MAP.get(biome);
        return list != null ? list.get(random) : null;
    }

    public static RegistryKey<Biome> getEndBiome(INoiseRandom random) {
        return END_BIOMES.get(random);
    }

    public static boolean shouldPlayCustomEndMusic(ResourceLocation biomeName) {
        return CUSTOM_END_MUSIC_BIOMES.contains(biomeName);
    }

    public static RegistryKey<Biome> getOceanBiome(OceanType type, INoiseRandom random) {
        return (RegistryKey)OCEAN_BIOME_MAP.getOrDefault((Object)type, new WeightedNoiseList()).get(random);
    }

    @Nullable
    public static RegistryKey<Biome> getDeepOceanBiome(RegistryKey<Biome> oceanBiome) {
        return DEEP_OCEAN_BIOME_MAP.get(oceanBiome);
    }

    public static boolean isOceanBiome(RegistryKey<Biome> biome) {
        return OCEAN_SET.contains(biome);
    }

    public static boolean isShallowOceanBiome(RegistryKey<Biome> biome) {
        return SHALLOW_OCEAN_SET.contains(biome);
    }

    @Nullable
    public static RegistryKey<Biome> getEdgeBiome(RegistryKey<Biome> biome, INoiseRandom random, RegistryKey<Biome> northBiome, RegistryKey<Biome> westBiome, RegistryKey<Biome> southBiome, RegistryKey<Biome> eastBiome) {
        Pair<EdgeBiomeProvider, RegistryKey> pair;
        PrioritizedNoiseList<EdgeBiomeProvider> edgeBiomeProviderList = EDGE_BIOME_PROVIDER_MAP.get(biome);
        if (edgeBiomeProviderList != null && (pair = edgeBiomeProviderList.getWithCallback(random, edgeBiomeProvider -> edgeBiomeProvider.getEdgeBiome(random, northBiome, westBiome, southBiome, eastBiome))) != null) {
            return (RegistryKey)pair.getSecond();
        }
        return null;
    }

    public static List<Pair<Biome.Attributes, Supplier<Biome>>> getModifiedNetherBiomes(List<Pair<Biome.Attributes, Supplier<Biome>>> baseBiomes, Registry<Biome> registry) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.addAll(baseBiomes);
        NETHER_BIOMES.forEach(registryKeyAttributesPair -> {
            RegistryKey biomeRegistryKey = (RegistryKey)registryKeyAttributesPair.getSecond();
            builder.add((Object)Pair.of((Object)registryKeyAttributesPair.getFirst(), () -> (Biome)registry.func_243576_d(biomeRegistryKey)));
        });
        return builder.build();
    }

    public static int getId(@Nonnull RegistryKey<Biome> biome) {
        return WorldGenRegistries.field_243657_i.func_148757_b(WorldGenRegistries.field_243657_i.func_230516_a_(biome));
    }

    static {
        BiomeUtil.addEndBiome((RegistryKey<Biome>)Biomes.field_201937_Q, 15);
        BiomeUtil.addOceanBiome(OceanType.FROZEN, (RegistryKey<Biome>)Biomes.field_76776_l, (RegistryKey<Biome>)Biomes.field_203620_Z, 15);
        BiomeUtil.addOceanBiome(OceanType.COLD, (RegistryKey<Biome>)Biomes.field_203616_V, (RegistryKey<Biome>)Biomes.field_203619_Y, 15);
        BiomeUtil.addOceanBiome(OceanType.NORMAL, (RegistryKey<Biome>)Biomes.field_76771_b, (RegistryKey<Biome>)Biomes.field_150575_M, 15);
        BiomeUtil.addOceanBiome(OceanType.LUKEWARM, (RegistryKey<Biome>)Biomes.field_203615_U, (RegistryKey<Biome>)Biomes.field_203618_X, 15);
        BiomeUtil.addOceanBiome(OceanType.WARM, (RegistryKey<Biome>)Biomes.field_203614_T, null, 15);
    }

    public static enum Priority {
        HIGHEST,
        HIGH,
        NORMAL,
        LOW,
        LOWEST;

    }

    public static enum OceanType {
        WARM,
        LUKEWARM,
        FROZEN,
        COLD,
        NORMAL;

    }

    public static final class PrioritizedNoiseList<T> {
        private static final Object DUMMY_CALLBACK = new Object();
        private final EnumMap<Priority, List<T>> priorityListMap = new EnumMap(Priority.class);

        public void add(T value, Priority priority) {
            this.priorityListMap.computeIfAbsent(priority, priority1 -> new ArrayList()).add(value);
        }

        @Nullable
        public T get(INoiseRandom random) {
            Pair<Object, Object> pair = this.getWithCallback(random, o -> DUMMY_CALLBACK);
            return (T)(pair != null ? pair.getFirst() : null);
        }

        @Nullable
        public <C> Pair<T, C> getWithCallback(INoiseRandom random, Function<T, C> callbackProcessor) {
            for (List<T> list : this.priorityListMap.values()) {
                int size = list.size();
                if (size <= 0) continue;
                ArrayList<T> copy = new ArrayList<T>(list);
                while (size > 0) {
                    int index = random.func_202696_a(size);
                    Object picked = copy.get(index);
                    C callback = callbackProcessor.apply(picked);
                    if (callback != null) {
                        return Pair.of(picked, callback);
                    }
                    copy.remove(index);
                    --size;
                }
            }
            return null;
        }

        @Nonnull
        public EnumMap<Priority, List<T>> getPriorityListMap() {
            return this.priorityListMap;
        }
    }

    public static final class WeightedNoiseList<T> {
        private final List<Pair<T, Integer>> entries = Lists.newArrayList();
        private int totalWeight;

        public void add(@Nonnull T value, int weight) {
            this.totalWeight += weight;
            this.entries.add(Pair.of(value, (Object)weight));
        }

        @Nonnull
        public T get(INoiseRandom random) {
            Object value;
            Pair<T, Integer> entry;
            Iterator<Pair<T, Integer>> iterator = this.entries.iterator();
            int randomTotal = random.func_202696_a(this.totalWeight);
            do {
                entry = iterator.next();
                value = entry.getFirst();
            } while ((randomTotal -= ((Integer)entry.getSecond()).intValue()) >= 0);
            return (T)value;
        }

        @Nonnull
        public List<Pair<T, Integer>> getEntries() {
            return this.entries;
        }
    }
}

