/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.lib.sonar.sonar.common.valuecontainer;

import com.minecraftabnormals.abnormals_core.lib.sonar.sonar.common.valuecontainer.NumberValueContainerEntry;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;

public class FloatValueContainerEntry
extends NumberValueContainerEntry<Float> {
    private final ITextComponent displayName;
    private boolean bounds;

    public FloatValueContainerEntry(ITextComponent displayName, String name, float value) {
        this(displayName, name, value, Float.MIN_VALUE, Float.MAX_VALUE);
        this.bounds = false;
    }

    public FloatValueContainerEntry(ITextComponent displayName, String name, float value, float minValue, float maxValue) {
        super(name, Float.valueOf(value), Float.valueOf(minValue), Float.valueOf(maxValue));
        this.displayName = displayName;
        this.bounds = true;
    }

    @Override
    protected Float getValue(Number number) {
        return Float.valueOf(number.floatValue());
    }

    @Override
    protected Float clamp(Float value, Float minValue, Float maxValue) {
        if (value.floatValue() < minValue.floatValue()) {
            value = minValue;
        }
        if (value.floatValue() > maxValue.floatValue()) {
            value = maxValue;
        }
        return value;
    }

    @Override
    protected boolean hasBounds() {
        return this.bounds;
    }

    @Override
    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    @Override
    public void write(CompoundNBT nbt) {
        nbt.func_74776_a(this.getName(), ((Float)this.value).floatValue());
    }

    @Override
    public void read(CompoundNBT nbt) {
        this.value = nbt.func_150297_b(this.getName(), 5) ? Float.valueOf(nbt.func_74760_g(this.getName())) : (Float)this.getPreviousValue();
    }

    @Override
    public boolean isDecimal() {
        return true;
    }
}

