/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.innovation.client.model;

import cofh.core.util.helpers.FluidHelper;
import cofh.lib.item.ICoFHItem;
import cofh.lib.item.IMultiModeItem;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ItemMultiLayerBakedModel;
import net.minecraftforge.client.model.ItemTextureQuadConverter;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelTransformComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;

public final class FluidReservoirItemModel
implements IModelGeometry<FluidReservoirItemModel> {
    private static final float NORTH_Z_FLUID = 0.468625f;
    private static final float SOUTH_Z_FLUID = 0.531375f;
    @Nonnull
    private final FluidStack fluidStack;
    private final int mode;
    private final boolean active;
    private final boolean color;

    public FluidReservoirItemModel(FluidStack fluidStack, int mode, boolean active, boolean color) {
        this.fluidStack = fluidStack;
        this.mode = mode;
        this.active = active;
        this.color = color;
    }

    public FluidReservoirItemModel withProperties(FluidStack newFluid, int mode, boolean active, boolean color) {
        return new FluidReservoirItemModel(newFluid, mode, active, color);
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        TextureAtlasSprite templateSprite;
        RenderMaterial frameLayer;
        RenderMaterial modeLayer;
        TextureAtlasSprite particleSprite;
        RenderMaterial particleLocation = owner.isTexturePresent("particle") ? owner.resolveTexture("particle") : null;
        RenderMaterial fluidMaskLocation = owner.isTexturePresent("fluid_mask") ? owner.resolveTexture("fluid_mask") : null;
        RenderMaterial[] inactiveLocations = new RenderMaterial[2];
        RenderMaterial[] activeLocations = new RenderMaterial[2];
        RenderMaterial[] baseLocations = new RenderMaterial[2];
        RenderMaterial[] colorLocations = new RenderMaterial[2];
        inactiveLocations[0] = owner.isTexturePresent("mode_0") ? owner.resolveTexture("mode_0") : null;
        inactiveLocations[1] = owner.isTexturePresent("mode_1") ? owner.resolveTexture("mode_1") : null;
        activeLocations[0] = owner.isTexturePresent("active_0") ? owner.resolveTexture("active_0") : null;
        activeLocations[1] = owner.isTexturePresent("active_1") ? owner.resolveTexture("active_1") : null;
        baseLocations[0] = owner.isTexturePresent("base_0") ? owner.resolveTexture("base_0") : null;
        baseLocations[1] = owner.isTexturePresent("base_1") ? owner.resolveTexture("base_1") : null;
        colorLocations[0] = owner.isTexturePresent("color_0") ? owner.resolveTexture("color_0") : null;
        colorLocations[1] = owner.isTexturePresent("color_1") ? owner.resolveTexture("color_1") : null;
        IModelTransform transformsFromModel = owner.getCombinedTransform();
        Fluid fluid = this.fluidStack.getFluid();
        TextureAtlasSprite fluidSprite = fluid != Fluids.field_204541_a ? spriteGetter.apply(ForgeHooksClient.getBlockMaterial((ResourceLocation)fluid.getAttributes().getStillTexture())) : null;
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((IModelTransform)new ModelTransformComposition(transformsFromModel, modelTransform));
        TextureAtlasSprite textureAtlasSprite = particleSprite = particleLocation != null ? spriteGetter.apply(particleLocation) : null;
        if (particleSprite == null) {
            particleSprite = fluidSprite;
        }
        TransformationMatrix transform = modelTransform.func_225615_b_();
        ItemMultiLayerBakedModel.Builder builder = ItemMultiLayerBakedModel.builder((IModelConfiguration)owner, (TextureAtlasSprite)particleSprite, (ItemOverrideList)new ContainedFluidOverrideHandler(bakery, owner, this), (ImmutableMap)transformMap);
        RenderMaterial renderMaterial = modeLayer = this.active ? activeLocations[this.mode % 2] : inactiveLocations[this.mode % 2];
        if (modeLayer != null) {
            builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)false), (Collection)ItemLayerModel.getQuadsForSprite((int)0, (TextureAtlasSprite)spriteGetter.apply(modeLayer), (TransformationMatrix)transform));
        }
        RenderMaterial renderMaterial2 = frameLayer = this.color ? colorLocations[this.mode % 2] : baseLocations[this.mode % 2];
        if (frameLayer != null) {
            builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)false), (Collection)ItemLayerModel.getQuadsForSprite((int)1, (TextureAtlasSprite)spriteGetter.apply(frameLayer), (TransformationMatrix)transform));
        }
        if (fluidMaskLocation != null && fluidSprite != null && (templateSprite = spriteGetter.apply(fluidMaskLocation)) != null) {
            int luminosity = fluid.getAttributes().getLuminosity(this.fluidStack);
            int color = fluid.getAttributes().getColor(this.fluidStack);
            builder.addQuads(ItemLayerModel.getLayerRenderType((luminosity > 0 ? 1 : 0) != 0), (Collection)ItemTextureQuadConverter.convertTexture((TransformationMatrix)transform, (TextureAtlasSprite)templateSprite, (TextureAtlasSprite)fluidSprite, (float)0.468625f, (Direction)Direction.NORTH, (int)color, (int)2, (int)luminosity));
            builder.addQuads(ItemLayerModel.getLayerRenderType((luminosity > 0 ? 1 : 0) != 0), (Collection)ItemTextureQuadConverter.convertTexture((TransformationMatrix)transform, (TextureAtlasSprite)templateSprite, (TextureAtlasSprite)fluidSprite, (float)0.531375f, (Direction)Direction.SOUTH, (int)color, (int)2, (int)luminosity));
        }
        builder.setParticle(particleSprite);
        return builder.build();
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet texs = Sets.newHashSet();
        if (owner.isTexturePresent("particle")) {
            texs.add(owner.resolveTexture("particle"));
        }
        if (owner.isTexturePresent("fluid_mask")) {
            texs.add(owner.resolveTexture("fluid_mask"));
        }
        if (owner.isTexturePresent("base_0")) {
            texs.add(owner.resolveTexture("base_0"));
        }
        if (owner.isTexturePresent("base_1")) {
            texs.add(owner.resolveTexture("base_1"));
        }
        if (owner.isTexturePresent("color_0")) {
            texs.add(owner.resolveTexture("color_0"));
        }
        if (owner.isTexturePresent("color_1")) {
            texs.add(owner.resolveTexture("color_1"));
        }
        if (owner.isTexturePresent("mode_0")) {
            texs.add(owner.resolveTexture("mode_0"));
        }
        if (owner.isTexturePresent("mode_1")) {
            texs.add(owner.resolveTexture("mode_1"));
        }
        if (owner.isTexturePresent("active_0")) {
            texs.add(owner.resolveTexture("active_0"));
        }
        if (owner.isTexturePresent("active_1")) {
            texs.add(owner.resolveTexture("active_1"));
        }
        return texs;
    }

    private static final class ContainedFluidOverrideHandler
    extends ItemOverrideList {
        private final Map<List<Integer>, IBakedModel> cache = new Object2ObjectOpenHashMap();
        private final ModelBakery bakery;
        private final IModelConfiguration owner;
        private final FluidReservoirItemModel parent;

        private ContainedFluidOverrideHandler(ModelBakery bakery, IModelConfiguration owner, FluidReservoirItemModel parent) {
            this.bakery = bakery;
            this.owner = owner;
            this.parent = parent;
        }

        public IBakedModel func_239290_a_(IBakedModel originalModel, ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
            int mode = ((IMultiModeItem)stack.func_77973_b()).getMode(stack);
            boolean active = ((ICoFHItem)stack.func_77973_b()).isActive(stack);
            CompoundNBT nbt = stack.func_179543_a("display");
            boolean color = nbt != null && nbt.func_150297_b("color", 99);
            FluidStack fluidStack = FluidHelper.getFluidContainedInItem((ItemStack)stack).orElse(FluidStack.EMPTY);
            List<Integer> fluidHash = Arrays.asList(mode + (active ? 2 : 0) + (color ? 4 : 0), FluidHelper.fluidHashcode((FluidStack)fluidStack));
            if (!this.cache.containsKey(fluidHash)) {
                FluidReservoirItemModel unbaked = this.parent.withProperties(fluidStack, mode, active, color);
                IBakedModel bakedModel = unbaked.bake(this.owner, this.bakery, ModelLoader.defaultTextureGetter(), (IModelTransform)ModelRotation.X0_Y0, this, new ResourceLocation("cofh_core", "reservoir_override"));
                this.cache.put(fluidHash, bakedModel);
                return bakedModel;
            }
            return this.cache.get(fluidHash);
        }
    }

    public static class Loader
    implements IModelLoader<FluidReservoirItemModel> {
        public IResourceType getResourceType() {
            return VanillaResourceType.MODELS;
        }

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        }

        public FluidReservoirItemModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            ResourceLocation fluidName;
            Fluid fluid;
            FluidStack stack = FluidStack.EMPTY;
            if (modelContents.has("fluid") && (fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidName = new ResourceLocation(modelContents.get("fluid").getAsString()))) != null) {
                stack = new FluidStack(fluid, 1000);
            }
            return new FluidReservoirItemModel(stack, 0, false, false);
        }
    }
}

