/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.AbstractNumberListEntry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
public class DoubleListEntry
extends AbstractNumberListEntry<Double> {
    @Deprecated
    @ApiStatus.Internal
    public DoubleListEntry(ITextComponent fieldName, Double value, ITextComponent resetButtonKey, Supplier<Double> defaultValue, Consumer<Double> saveConsumer) {
        super(fieldName, value, resetButtonKey, defaultValue);
        this.saveCallback = saveConsumer;
    }

    @Deprecated
    @ApiStatus.Internal
    public DoubleListEntry(ITextComponent fieldName, Double value, ITextComponent resetButtonKey, Supplier<Double> defaultValue, Consumer<Double> saveConsumer, Supplier<Optional<ITextComponent[]>> tooltipSupplier) {
        this(fieldName, value, resetButtonKey, defaultValue, saveConsumer, tooltipSupplier, false);
    }

    @Deprecated
    @ApiStatus.Internal
    public DoubleListEntry(ITextComponent fieldName, Double value, ITextComponent resetButtonKey, Supplier<Double> defaultValue, Consumer<Double> saveConsumer, Supplier<Optional<ITextComponent[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, value, resetButtonKey, defaultValue, tooltipSupplier, requiresRestart);
        this.saveCallback = saveConsumer;
    }

    @Override
    protected Map.Entry<Double, Double> getDefaultRange() {
        return new AbstractMap.SimpleEntry<Double, Double>(-1.7976931348623157E308, (Double)Double.MAX_VALUE);
    }

    public DoubleListEntry setMinimum(double minimum) {
        this.minimum = minimum;
        return this;
    }

    public DoubleListEntry setMaximum(double maximum) {
        this.maximum = maximum;
        return this;
    }

    @Override
    public Double getValue() {
        try {
            return Double.valueOf(this.textFieldWidget.func_146179_b());
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    @Override
    public Optional<ITextComponent> getError() {
        try {
            double i = Double.parseDouble(this.textFieldWidget.func_146179_b());
            if (i > (Double)this.maximum) {
                return Optional.of(new TranslationTextComponent("text.cloth-config.error.too_large", new Object[]{this.maximum}));
            }
            if (i < (Double)this.minimum) {
                return Optional.of(new TranslationTextComponent("text.cloth-config.error.too_small", new Object[]{this.minimum}));
            }
        }
        catch (NumberFormatException ex) {
            return Optional.of(new TranslationTextComponent("text.cloth-config.error.not_valid_number_double"));
        }
        return super.getError();
    }
}

