/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.AbstractNumberListEntry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
public class IntegerListEntry
extends AbstractNumberListEntry<Integer> {
    @Deprecated
    @ApiStatus.Internal
    public IntegerListEntry(ITextComponent fieldName, Integer value, ITextComponent resetButtonKey, Supplier<Integer> defaultValue, Consumer<Integer> saveConsumer) {
        super(fieldName, value, resetButtonKey, defaultValue);
        this.saveCallback = saveConsumer;
    }

    @Deprecated
    @ApiStatus.Internal
    public IntegerListEntry(ITextComponent fieldName, Integer value, ITextComponent resetButtonKey, Supplier<Integer> defaultValue, Consumer<Integer> saveConsumer, Supplier<Optional<ITextComponent[]>> tooltipSupplier) {
        this(fieldName, value, resetButtonKey, defaultValue, saveConsumer, tooltipSupplier, false);
    }

    @Deprecated
    @ApiStatus.Internal
    public IntegerListEntry(ITextComponent fieldName, Integer value, ITextComponent resetButtonKey, Supplier<Integer> defaultValue, Consumer<Integer> saveConsumer, Supplier<Optional<ITextComponent[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, value, resetButtonKey, defaultValue, tooltipSupplier, requiresRestart);
        this.saveCallback = saveConsumer;
    }

    @Override
    protected Map.Entry<Integer, Integer> getDefaultRange() {
        return new AbstractMap.SimpleEntry<Integer, Integer>(-2147483647, Integer.MAX_VALUE);
    }

    public IntegerListEntry setMaximum(int maximum) {
        this.maximum = maximum;
        return this;
    }

    public IntegerListEntry setMinimum(int minimum) {
        this.minimum = minimum;
        return this;
    }

    @Override
    public Integer getValue() {
        try {
            return Integer.valueOf(this.textFieldWidget.func_146179_b());
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public Optional<ITextComponent> getError() {
        try {
            int i = Integer.parseInt(this.textFieldWidget.func_146179_b());
            if (i > (Integer)this.maximum) {
                return Optional.of(new TranslationTextComponent("text.cloth-config.error.too_large", new Object[]{this.maximum}));
            }
            if (i < (Integer)this.minimum) {
                return Optional.of(new TranslationTextComponent("text.cloth-config.error.too_small", new Object[]{this.minimum}));
            }
        }
        catch (NumberFormatException ex) {
            return Optional.of(new TranslationTextComponent("text.cloth-config.error.not_valid_number_int"));
        }
        return super.getError();
    }
}

