/*
 * Decompiled with CFR 0.152.
 */
package codechicken.mixin.api;

import codechicken.asm.ASMHelper;
import codechicken.mixin.api.MixinCompiler;
import codechicken.mixin.util.ClassInfo;
import codechicken.mixin.util.ClassNodeInfo;
import codechicken.mixin.util.JavaTraitGenerator;
import codechicken.mixin.util.MixinInfo;
import codechicken.mixin.util.ReflectionClassInfo;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.objectweb.asm.tree.ClassNode;

public interface MixinLanguageSupport {
    public Optional<ClassInfo> obtainInfo(String var1, @Nullable ClassNode var2);

    public Optional<MixinInfo> buildMixinTrait(ClassNode var1);

    @LanguageName(value="java")
    @SortingIndex(value=0x7FFFFFFF)
    public static class JavaMixinLanguageSupport
    implements MixinLanguageSupport {
        protected final MixinCompiler mixinCompiler;
        private BiFunction<MixinCompiler, ClassNode, JavaTraitGenerator> traitGeneratorFactory = JavaTraitGenerator::new;

        public JavaMixinLanguageSupport(MixinCompiler mixinCompiler) {
            this.mixinCompiler = mixinCompiler;
        }

        public void setTraitGeneratorFactory(BiFunction<MixinCompiler, ClassNode, JavaTraitGenerator> factory) {
            this.traitGeneratorFactory = factory;
        }

        @Override
        public Optional<ClassInfo> obtainInfo(String name, ClassNode cNode) {
            if (cNode != null) {
                return Optional.of(new ClassNodeInfo(this.mixinCompiler, cNode));
            }
            Class<?> clazz = this.mixinCompiler.getMixinBackend().loadClass(name.replace("/", "."));
            if (clazz != null) {
                return Optional.of(new ReflectionClassInfo(this.mixinCompiler, clazz));
            }
            return Optional.empty();
        }

        @Override
        public Optional<MixinInfo> buildMixinTrait(ClassNode cNode) {
            JavaTraitGenerator generator = this.traitGeneratorFactory.apply(this.mixinCompiler, cNode);
            generator.getStaticNode().ifPresent(node -> this.mixinCompiler.defineClass(node.name, ASMHelper.createBytes(node, 3)));
            ClassNode tNode = generator.getTraitNode();
            MixinInfo info = generator.getMixinInfo();
            this.mixinCompiler.defineClass(tNode.name, ASMHelper.createBytes(tNode, 3));
            return Optional.of(info);
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface SortingIndex {
        public int value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface LanguageName {
        public String value();
    }
}

