/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.block;

import codechicken.lib.capability.CapabilityCache;
import codechicken.lib.data.MCDataByteBuf;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.lib.world.IChunkLoadTile;
import codechicken.multipart.api.part.TMultiPart;
import codechicken.multipart.init.CBMultipartModContent;
import codechicken.multipart.init.MultiPartRegistries;
import codechicken.multipart.network.MultiPartSPH;
import codechicken.multipart.util.FilteredCollectionView;
import codechicken.multipart.util.MergedVoxelShapeHolder;
import codechicken.multipart.util.MultiPartGenerator;
import codechicken.multipart.util.MultiPartHelper;
import codechicken.multipart.util.MultipartVoxelShape;
import codechicken.multipart.util.PartRayTraceResult;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileMultiPart
extends TileEntity
implements IChunkLoadTile {
    private List<TMultiPart> partList = new CopyOnWriteArrayList<TMultiPart>();
    private CapabilityCache capabilityCache = new CapabilityCache();
    private final MergedVoxelShapeHolder<TMultiPart> outlineShapeHolder = new MergedVoxelShapeHolder().setPostProcessHook(e -> new MultipartVoxelShape((VoxelShape)e, this));
    private final MergedVoxelShapeHolder<TMultiPart> collisionShapeHolder = new MergedVoxelShapeHolder().setPostProcessHook(e -> new MultipartVoxelShape((VoxelShape)e, this));
    private final MergedVoxelShapeHolder<TMultiPart> occlusionShapeHolder = new MergedVoxelShapeHolder().setPostProcessHook(e -> new MultipartVoxelShape((VoxelShape)e, this));
    private final MergedVoxelShapeHolder<TMultiPart> interactionShapeHolder = new MergedVoxelShapeHolder().setPostProcessHook(e -> new MultipartVoxelShape((VoxelShape)e, this));
    private final MergedVoxelShapeHolder<TMultiPart> supportShapeHolder = new MergedVoxelShapeHolder().setPostProcessHook(e -> new MultipartVoxelShape((VoxelShape)e, this));
    private final MergedVoxelShapeHolder<TMultiPart> visualShapeHolder = new MergedVoxelShapeHolder().setPostProcessHook(e -> new MultipartVoxelShape((VoxelShape)e, this));

    public TileMultiPart() {
        super(CBMultipartModContent.tileMultipartType);
    }

    public List<TMultiPart> getPartList() {
        return this.partList;
    }

    public void from(TileMultiPart that) {
        this.copyFrom(that);
        this.loadFrom(that);
        that.loadTo(this);
    }

    public void copyFrom(TileMultiPart that) {
        this.partList = that.partList;
        this.markShapeChange();
    }

    public void loadFrom(TileMultiPart that) {
        this.partList.forEach(e -> e.bind(this));
    }

    public void loadTo(TileMultiPart that) {
    }

    public void clearParts() {
        this.partList = new CopyOnWriteArrayList<TMultiPart>();
        this.markShapeChange();
    }

    public void bindPart(TMultiPart part) {
    }

    public void partAdded(TMultiPart part) {
    }

    public void partRemoved(TMultiPart part, int p) {
    }

    public boolean getWeakChanges() {
        return false;
    }

    public void onNeighborTileChange(BlockPos neighborPos) {
    }

    public TMultiPart getSlottedPart(int slot) {
        return null;
    }

    public void onRemoved() {
    }

    public void operate(Consumer<TMultiPart> cons) {
        for (TMultiPart part : this.partList) {
            if (part.tile() == null) continue;
            cons.accept(part);
        }
    }

    public final CompoundNBT func_189515_b(CompoundNBT compound) {
        compound = super.func_189515_b(compound);
        ListNBT parts = new ListNBT();
        for (TMultiPart part : this.partList) {
            parts.add((Object)MultiPartRegistries.savePart(new CompoundNBT(), part));
        }
        compound.func_218657_a("parts", (INBT)parts);
        return compound;
    }

    public final CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        MCDataByteBuf desc = new MCDataByteBuf();
        this.writeDesc((MCDataOutput)desc);
        desc.writeToNBT(tag, "data");
        return tag;
    }

    public void writeDesc(MCDataOutput packet) {
        packet.writeByte(this.partList.size());
        for (TMultiPart part : this.partList) {
            MultiPartRegistries.writePart(packet, part);
        }
    }

    public boolean canAddPart(TMultiPart part) {
        return !this.partList.contains(part) && this.occlusionTest(this.partList, part);
    }

    public boolean canReplacePart(TMultiPart oPart, TMultiPart nPart) {
        if (oPart != nPart && this.partList.contains(nPart)) {
            return false;
        }
        return this.occlusionTest(new FilteredCollectionView<TMultiPart>(this.partList, e -> e != oPart), nPart);
    }

    public boolean occlusionTest(Collection<TMultiPart> parts, TMultiPart nPart) {
        return parts.stream().allMatch(part -> part.occlusionTest(nPart) && nPart.occlusionTest((TMultiPart)part));
    }

    public void addPart_impl(TMultiPart part) {
        if (!this.field_145850_b.field_72995_K) {
            MultiPartSPH.sendAddPart(this, part);
        }
        this.addPart_do(part);
        part.onAdded();
        this.partAdded(part);
        this.notifyPartChange(part);
        this.notifyTileChange();
        this.func_70296_d();
        this.markRender();
    }

    public void addPart_do(TMultiPart part) {
        this.partList.add(part);
        this.bindPart(part);
        this.markShapeChange();
        part.bind(this);
    }

    public TileMultiPart remPart(TMultiPart part) {
        Preconditions.checkArgument((!this.field_145850_b.field_72995_K ? 1 : 0) != 0, (Object)"Cannot remove MultiParts from a client tile.");
        return this.remPart_impl(part);
    }

    public TileMultiPart remPart_impl(TMultiPart part) {
        this.remPart_do(part, !this.field_145850_b.field_72995_K);
        if (!this.func_145837_r()) {
            TileMultiPart tile = TileMultiPart.partRemoved(this);
            tile.notifyPartChange(part);
            tile.func_70296_d();
            tile.markRender();
            return tile;
        }
        return null;
    }

    private int remPart_do(TMultiPart part, boolean sendPacket) {
        int idx = this.partList.indexOf(part);
        if (idx < 0) {
            throw new IllegalArgumentException("Tried to remove a non-existent part");
        }
        part.preRemove();
        this.partList.removeIf(e -> e == part);
        if (sendPacket) {
            MultiPartSPH.sendRemPart(this, idx);
        }
        this.partRemoved(part, idx);
        part.onRemoved();
        part.tile_$eq(null);
        this.markShapeChange();
        this.recalcLight(false, true);
        if (this.partList.isEmpty()) {
            this.field_145850_b.func_217377_a(this.field_174879_c, false);
        }
        return idx;
    }

    private void loadParts(Iterable<TMultiPart> parts) {
        this.clearParts();
        parts.forEach(this::addPart_do);
        if (this.field_145850_b != null) {
            if (this.field_145850_b.field_72995_K) {
                this.operate(TMultiPart::onWorldJoin);
            }
            this.notifyPartChange(null);
        }
    }

    public final void setValid(boolean b) {
        if (b) {
            this.func_145829_t();
        } else {
            this.func_145843_s();
        }
    }

    public void func_145843_s() {
        if (!this.func_145837_r()) {
            super.func_145843_s();
            this.onRemoved();
            if (this.field_145850_b != null) {
                this.partList.forEach(TMultiPart::onWorldSeparate);
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return super.getCapability(cap, side);
    }

    public VoxelShape getShape(ISelectionContext context) {
        return this.outlineShapeHolder.update(this.partList, part -> part.getShape(context));
    }

    public VoxelShape getCollisionShape(ISelectionContext context) {
        return this.collisionShapeHolder.update(this.partList, part -> part.getCollisionShape(context));
    }

    public VoxelShape getRenderOcclusionShape() {
        return this.occlusionShapeHolder.update(this.partList, TMultiPart::getRenderOcclusionShape);
    }

    public VoxelShape getInteractionShape() {
        return this.interactionShapeHolder.update(this.partList, TMultiPart::getInteractionShape);
    }

    public VoxelShape getBlockSupportShape() {
        return this.supportShapeHolder.update(this.partList, TMultiPart::getBlockSupportShape);
    }

    public VoxelShape getVisualShape(ISelectionContext context) {
        return this.visualShapeHolder.update(this.partList, part -> part.getVisualShape(context));
    }

    public void harvestPart(PartRayTraceResult hit, PlayerEntity player) {
        hit.part.harvest(player, hit);
    }

    public List<ItemStack> getDrops() {
        return this.partList.stream().map(TMultiPart::getDrops).flatMap(e -> StreamSupport.stream(e.spliterator(), false)).collect(Collectors.toList());
    }

    public ItemStack getPickBlock(PartRayTraceResult hit) {
        return hit.part.pickItem(hit);
    }

    public float getExplosionResistance(Explosion explosion) {
        return (float)this.partList.stream().mapToDouble(e -> e.getExplosionResistance(explosion)).max().orElse(0.0);
    }

    public int getLightValue() {
        return this.partList.stream().mapToInt(TMultiPart::getLightValue).max().orElse(0);
    }

    public float getDestroyProgress(PlayerEntity player, PartRayTraceResult hit) {
        return hit.part.getStrength(player, hit);
    }

    public void onChunkUnloaded() {
        this.operate(TMultiPart::onChunkUnload);
    }

    @Deprecated
    public void onChunkLoad() {
    }

    public void onChunkLoad(Chunk chunk) {
        this.operate(e -> e.onChunkLoad(chunk));
    }

    public void onMoved() {
        this.capabilityCache.setWorldPos(this.field_145850_b, this.field_174879_c);
        this.operate(TMultiPart::onMoved);
    }

    public ActionResultType use(PlayerEntity player, PartRayTraceResult hit, Hand hand) {
        return hit.part.activate(player, hit, player.func_184586_b(hand), hand);
    }

    public void attack(PlayerEntity player, PartRayTraceResult hit) {
        hit.part.click(player, hit, player.func_184614_ca());
    }

    public void func_226984_a_(World world, BlockPos pos) {
        super.func_226984_a_(world, pos);
        this.capabilityCache.setWorldPos(world, pos);
    }

    public void entityInside(Entity entity) {
        this.operate(e -> e.onEntityCollision(entity));
    }

    public void stepOn(Entity entity) {
        this.operate(e -> e.onEntityStanding(entity));
    }

    public void onNeighborBlockChanged(BlockPos pos) {
        this.capabilityCache.onNeighborChanged(pos);
        this.operate(e -> e.onNeighborBlockChanged(pos));
    }

    public boolean canConnectRedstone(int side) {
        return false;
    }

    public int getDirectSignal(int side) {
        return 0;
    }

    public int getSignal(int side) {
        return 0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        Cuboid6 c = Cuboid6.full.copy();
        this.operate(e -> c.enclose(e.getRenderBounds()));
        return c.add(this.field_174879_c).aabb();
    }

    public void animateTick(Random random) {
    }

    public boolean isClientTile() {
        return false;
    }

    public void notifyTileChange() {
        this.field_145850_b.func_195593_d(this.field_174879_c, (Block)CBMultipartModContent.blockMultipart);
    }

    public void notifyPartChange(TMultiPart part) {
        this.internalPartChange(part);
        BlockState state = CBMultipartModContent.blockMultipart.func_176223_P();
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        this.field_145850_b.func_195593_d(this.field_174879_c, (Block)CBMultipartModContent.blockMultipart);
        this.field_145850_b.func_72863_F().func_212863_j_().func_215568_a(this.field_174879_c);
    }

    public void internalPartChange(TMultiPart part) {
        this.operate(e -> {
            if (e != part) {
                e.onPartChanged(part);
            }
        });
    }

    public void multiPartChange(Collection<TMultiPart> parts) {
        this.operate(p -> {
            if (!parts.contains(p)) {
                parts.forEach(p::onPartChanged);
            }
        });
    }

    public void func_70296_d() {
        super.func_70296_d();
    }

    public void markRender() {
    }

    public void recalcLight(boolean sky, boolean block) {
        WorldLightManager lm = this.field_145850_b.func_225524_e_();
        if (sky && lm.field_215577_b != null) {
            lm.field_215577_b.func_215617_a(this.field_174879_c);
        }
        if (block && lm.field_215576_a != null) {
            lm.field_215576_a.func_215617_a(this.field_174879_c);
        }
    }

    public void markShapeChange() {
        this.outlineShapeHolder.clear();
        this.collisionShapeHolder.clear();
        this.occlusionShapeHolder.clear();
        this.interactionShapeHolder.clear();
    }

    public void notifyNeighborChange(Direction side) {
        this.field_145850_b.func_195593_d(this.field_174879_c.func_177972_a(side), (Block)CBMultipartModContent.blockMultipart);
    }

    public void notifyNeighborChange(int side) {
        this.notifyNeighborChange(Direction.func_82600_a((int)side));
    }

    public void dropItems(Iterable<ItemStack> items) {
        Vector3 pos = Vector3.fromTileCenter((TileEntity)this);
        items.forEach(e -> TileMultiPart.dropItem(e, this.field_145850_b, pos));
    }

    public CapabilityCache getCapCache() {
        return this.capabilityCache;
    }

    public static boolean canPlacePart(ItemUseContext context, TMultiPart part) {
        BlockPos pos;
        World world = context.func_195991_k();
        if (!TileMultiPart.isUnobstructed(world, pos = context.func_195995_a(), part)) {
            return false;
        }
        TileMultiPart tile = MultiPartHelper.getOrConvertTile(world, pos);
        if (tile != null) {
            return tile.canAddPart(part);
        }
        return TileMultiPart.replaceable(world, pos, context);
    }

    public static boolean isUnobstructed(World world, BlockPos pos, TMultiPart part) {
        return world.func_195585_a(null, part.getCollisionShape(ISelectionContext.func_216377_a()).func_197751_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()));
    }

    public static boolean replaceable(World world, BlockPos pos, ItemUseContext context) {
        BlockState state = world.func_180495_p(pos);
        return state.isAir((IBlockReader)world, pos) || state.func_196953_a(new BlockItemUseContext(context));
    }

    public static TileMultiPart addPart(World world, BlockPos pos, TMultiPart part) {
        return MultiPartHelper.addPart(world, pos, part);
    }

    public static void handleDescPacket(World world, BlockPos pos, MCDataInput packet) {
        ArrayList<TMultiPart> parts = new ArrayList<TMultiPart>();
        int nParts = packet.readUByte();
        for (int i = 0; i < nParts; ++i) {
            parts.add(MultiPartRegistries.readPart(packet));
        }
        if (parts.isEmpty()) {
            return;
        }
        TileEntity t = world.func_175625_s(pos);
        TileMultiPart tile = MultiPartGenerator.INSTANCE.generateCompositeTile(t, parts, true);
        if (tile != t) {
            world.func_175656_a(pos, CBMultipartModContent.blockMultipart.func_176223_P());
            MultiPartHelper.silentAddTile(world, pos, tile);
        }
        tile.loadParts(parts);
        tile.notifyTileChange();
        tile.markRender();
    }

    public static TileMultiPart fromNBT(CompoundNBT tag) {
        ListNBT partList = tag.func_150295_c("parts", 10);
        ArrayList<TMultiPart> parts = new ArrayList<TMultiPart>();
        for (int i = 0; i < partList.size(); ++i) {
            TMultiPart part = MultiPartRegistries.loadPart(partList.func_150305_b(i));
            if (part == null) continue;
            parts.add(part);
        }
        if (parts.isEmpty()) {
            return null;
        }
        TileMultiPart tile = MultiPartGenerator.INSTANCE.generateCompositeTile(null, parts, false);
        tile.func_230337_a_(CBMultipartModContent.blockMultipart.func_176223_P(), tag);
        tile.loadParts(parts);
        return tile;
    }

    public static void dropItem(ItemStack stack, World world, Vector3 pos) {
        ItemEntity item = new ItemEntity(world, pos.x, pos.y, pos.z, stack);
        item.func_213293_j(world.field_73012_v.nextGaussian() * 0.05, world.field_73012_v.nextGaussian() * 0.05 + 0.2, world.field_73012_v.nextGaussian() * 0.05);
        item.func_174867_a(10);
        world.func_217376_c((Entity)item);
    }

    private static TileMultiPart partRemoved(TileMultiPart tile) {
        TileMultiPart newTile = MultiPartGenerator.INSTANCE.generateCompositeTile(tile, tile.getPartList(), tile.func_145831_w().field_72995_K);
        if (tile != newTile) {
            tile.setValid(false);
            MultiPartHelper.silentAddTile(tile.func_145831_w(), tile.func_174877_v(), newTile);
            newTile.from(tile);
            newTile.notifyTileChange();
        }
        return newTile;
    }
}

