/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.trait;

import codechicken.lib.vec.Rotation;
import codechicken.multipart.api.RedstoneInteractions;
import codechicken.multipart.api.annotation.MultiPartTrait;
import codechicken.multipart.api.part.TEdgePart;
import codechicken.multipart.api.part.TFacePart;
import codechicken.multipart.api.part.TMultiPart;
import codechicken.multipart.api.part.redstone.IRedstonePart;
import codechicken.multipart.block.TileMultiPart;
import codechicken.multipart.trait.extern.IRedstoneTile;
import codechicken.multipart.util.PartMap;
import net.minecraft.world.IWorldReader;

@MultiPartTrait(value=IRedstonePart.class)
public class TRedstoneTile
extends TileMultiPart
implements IRedstoneTile {
    @Override
    public int getDirectSignal(int side) {
        int max = 0;
        for (TMultiPart part : this.getPartList()) {
            int l;
            if (!(part instanceof IRedstonePart) || (l = ((IRedstonePart)((Object)part)).strongPowerLevel(side)) <= max) continue;
            max = l;
        }
        return max;
    }

    @Override
    public int getSignal(int side) {
        return this.weakPowerLevel(side, RedstoneInteractions.otherConnectionMask((IWorldReader)this.func_145831_w(), this.func_174877_v(), side, true));
    }

    @Override
    public boolean canConnectRedstone(int side) {
        return (this.getConnectionMask(side) & RedstoneInteractions.otherConnectionMask((IWorldReader)this.func_145831_w(), this.func_174877_v(), side, true)) > 0;
    }

    @Override
    public int getConnectionMask(int side) {
        int mask = this.openConnections(side);
        int res = 0;
        for (TMultiPart part : this.getPartList()) {
            res |= RedstoneInteractions.connectionMask(part, side) & mask;
        }
        return res;
    }

    @Override
    public int weakPowerLevel(int side, int mask) {
        int tMask = this.openConnections(side) & mask;
        int max = 0;
        for (TMultiPart part : this.getPartList()) {
            int l;
            if ((RedstoneInteractions.connectionMask(part, side) & tMask) <= 0 || (l = ((IRedstonePart)((Object)part)).weakPowerLevel(side)) <= max) continue;
            max = l;
        }
        return max;
    }

    @Override
    public int openConnections(int side) {
        int m = 16;
        for (int i = 0; i < 4; ++i) {
            if (!this.redstoneConductionE(PartMap.edgeBetween(side, Rotation.rotateSide((int)(side & 6), (int)i)))) continue;
            m |= 1 << i;
        }
        return m &= this.redstoneConductionF(side);
    }

    private int redstoneConductionF(int i) {
        TMultiPart part = this.getSlottedPart(i);
        if (part instanceof TFacePart) {
            return ((TFacePart)((Object)part)).redstoneConductionMap();
        }
        return 31;
    }

    private boolean redstoneConductionE(int i) {
        TMultiPart part = this.getSlottedPart(i);
        if (part instanceof TEdgePart) {
            return ((TEdgePart)((Object)part)).conductsRedstone();
        }
        return true;
    }
}

