/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.trait;

import codechicken.multipart.api.annotation.MultiPartTrait;
import codechicken.multipart.api.part.ITickablePart;
import codechicken.multipart.api.part.TMultiPart;
import codechicken.multipart.block.TileMultiPart;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;

@MultiPartTrait(value=ITickablePart.class)
public class TTickableTile
extends TileMultiPart
implements ITickableTileEntity {
    private final List<ITickablePart> tickingParts = new ArrayList<ITickablePart>();
    private boolean doesTick;

    @Override
    public void copyFrom(TileMultiPart that) {
        super.copyFrom(that);
        if (that instanceof TTickableTile) {
            this.tickingParts.clear();
            this.tickingParts.addAll(((TTickableTile)that).tickingParts);
            this.doesTick = ((TTickableTile)that).doesTick;
        }
    }

    @Override
    public void bindPart(TMultiPart part) {
        super.bindPart(part);
        if (part instanceof ITickablePart) {
            this.tickingParts.add((ITickablePart)((Object)part));
            this.setTicking(true);
        }
    }

    @Override
    public void partRemoved(TMultiPart part, int p) {
        super.partRemoved(part, p);
        if (part instanceof ITickablePart) {
            this.tickingParts.remove(part);
        }
    }

    @Override
    public void clearParts() {
        super.clearParts();
        this.tickingParts.clear();
    }

    @Override
    public void loadFrom(TileMultiPart that) {
        super.loadFrom(that);
        if (this.doesTick) {
            this.func_145831_w().field_175730_i.add(this);
        }
    }

    @Override
    public void loadTo(TileMultiPart that) {
        super.loadTo(that);
        if (this.doesTick) {
            this.func_145831_w().field_175730_i.remove((Object)this);
        }
    }

    public void func_73660_a() {
        this.getCapCache().tick();
        int tickingPartsSize = this.tickingParts.size();
        for (int i = 0; i < tickingPartsSize; ++i) {
            ITickablePart part = this.tickingParts.get(i);
            if (((TMultiPart)((Object)part)).tile() == null) continue;
            part.tick();
        }
    }

    private void setTicking(boolean tick) {
        if (this.doesTick == tick) {
            return;
        }
        this.doesTick = tick;
        if (this.func_145831_w() != null && this.func_145831_w().func_175625_s(this.func_174877_v()) == this) {
            if (tick) {
                this.func_145831_w().func_175700_a((TileEntity)this);
            } else {
                this.func_145831_w().field_175730_i.remove((Object)this);
            }
        }
    }
}

