/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client;

import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.client.manual.ManualElementMultiblock;
import blusunrize.immersiveengineering.client.models.ModelCoresample;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.metal.MetalScaffoldingType;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.gui.GuiHandler;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.lib.manual.ManualElementCrafting;
import blusunrize.lib.manual.ManualElementTable;
import blusunrize.lib.manual.ManualEntry;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.SpecialManualElement;
import blusunrize.lib.manual.TextSplitter;
import blusunrize.lib.manual.Tree;
import com.electronwill.nightconfig.core.Config;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.api.crafting.DistillationRecipe;
import flaxbeard.immersivepetroleum.api.crafting.FlarestackHandler;
import flaxbeard.immersivepetroleum.api.crafting.pumpjack.PumpjackHandler;
import flaxbeard.immersivepetroleum.api.energy.FuelHandler;
import flaxbeard.immersivepetroleum.client.ClientEventHandler;
import flaxbeard.immersivepetroleum.client.gui.CokerUnitScreen;
import flaxbeard.immersivepetroleum.client.gui.DistillationTowerScreen;
import flaxbeard.immersivepetroleum.client.gui.HydrotreaterScreen;
import flaxbeard.immersivepetroleum.client.gui.ProjectorScreen;
import flaxbeard.immersivepetroleum.client.render.AutoLubricatorRenderer;
import flaxbeard.immersivepetroleum.client.render.MotorboatRenderer;
import flaxbeard.immersivepetroleum.client.render.MultiblockDistillationTowerRenderer;
import flaxbeard.immersivepetroleum.client.render.MultiblockPumpjackRenderer;
import flaxbeard.immersivepetroleum.client.render.debugging.DebugRenderHandler;
import flaxbeard.immersivepetroleum.common.CommonProxy;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.IPTileTypes;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.PumpjackTileEntity;
import flaxbeard.immersivepetroleum.common.cfg.IPServerConfig;
import flaxbeard.immersivepetroleum.common.crafting.RecipeReloadListener;
import flaxbeard.immersivepetroleum.common.entity.MotorboatEntity;
import flaxbeard.immersivepetroleum.common.multiblocks.CokerUnitMultiblock;
import flaxbeard.immersivepetroleum.common.multiblocks.DistillationTowerMultiblock;
import flaxbeard.immersivepetroleum.common.multiblocks.HydroTreaterMultiblock;
import flaxbeard.immersivepetroleum.common.multiblocks.PumpjackMultiblock;
import flaxbeard.immersivepetroleum.common.util.MCUtil;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="immersivepetroleum")
public class ClientProxy
extends CommonProxy {
    private static final Logger log = LogManager.getLogger((String)"immersivepetroleum/ClientProxy");
    public static final String CAT_IP = "ip";
    public static final KeyBinding keybind_preview_flip = new KeyBinding("key.immersivepetroleum.projector.flip", InputMappings.Type.KEYSYM, 77, "key.categories.immersivepetroleum");
    private static Tree.InnerNode<ResourceLocation, ManualEntry> IP_CATEGORY;
    static final DecimalFormat FORMATTER;
    static ManualEntry entry;

    @Override
    public void setup() {
        RenderingRegistry.registerEntityRenderingHandler(MotorboatEntity.TYPE, MotorboatRenderer::new);
    }

    @Override
    public void registerContainersAndScreens() {
        super.registerContainersAndScreens();
        this.registerScreen(ResourceUtils.ip("distillationtower"), DistillationTowerScreen::new);
        this.registerScreen(ResourceUtils.ip("cokerunit"), CokerUnitScreen::new);
        this.registerScreen(ResourceUtils.ip("hydrotreater"), HydrotreaterScreen::new);
    }

    public <C extends Container, S extends Screen> void registerScreen(ResourceLocation name, ScreenManager.IScreenFactory<C, S> factory) {
        ContainerType type = GuiHandler.getContainerType((ResourceLocation)name);
        ScreenManager.func_216911_a((ContainerType)type, factory);
    }

    @Override
    public void completed() {
        DeferredWorkQueue.runLater(() -> ManualHelper.addConfigGetter(str -> {
            switch (str) {
                case "distillationtower_operationcost": {
                    return (int)(2048.0 * (Double)IPServerConfig.REFINING.distillationTower_energyModifier.get());
                }
                case "coker_operationcost": {
                    return (int)(1024.0 * (Double)IPServerConfig.REFINING.cokerUnit_energyModifier.get());
                }
                case "hydrotreater_operationcost": {
                    return (int)(512.0 * (Double)IPServerConfig.REFINING.hydrotreater_energyModifier.get());
                }
                case "pumpjack_consumption": {
                    return IPServerConfig.EXTRACTION.pumpjack_consumption.get();
                }
                case "pumpjack_speed": {
                    return IPServerConfig.EXTRACTION.pumpjack_speed.get();
                }
                case "pumpjack_days": {
                    int oil_min = 1000000;
                    int oil_max = 5000000;
                    for (PumpjackHandler.ReservoirType type : PumpjackHandler.reservoirs.values()) {
                        if (!type.name.equals("oil")) continue;
                        oil_min = type.minSize;
                        oil_max = type.maxSize;
                        break;
                    }
                    float averageSize = (float)(oil_min + oil_max) / 2.0f;
                    float pumpspeed = ((Integer)IPServerConfig.EXTRACTION.pumpjack_speed.get()).intValue();
                    return MathHelper.func_76141_d((float)(averageSize / pumpspeed / 24000.0f));
                }
                case "autolubricant_speedup": {
                    return 1.25;
                }
                case "portablegenerator_flux": {
                    return FuelHandler.getFluxGeneratedPerTick(IPContent.Fluids.gasoline.getFluid());
                }
            }
            Config cfg = IPServerConfig.getRawConfig();
            if (cfg.contains(str)) {
                return cfg.get(str);
            }
            return null;
        }));
        this.setupManualPages();
    }

    @Override
    public void preInit() {
    }

    @Override
    public void preInitEnd() {
    }

    @Override
    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new RecipeReloadListener(null));
        MinecraftForge.EVENT_BUS.register((Object)new DebugRenderHandler());
        keybind_preview_flip.setKeyConflictContext((IKeyConflictContext)KeyConflictContext.IN_GAME);
        ClientRegistry.registerKeyBinding((KeyBinding)keybind_preview_flip);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)IPTileTypes.TOWER.get()), MultiblockDistillationTowerRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)IPTileTypes.PUMP.get()), MultiblockPumpjackRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)IPTileTypes.AUTOLUBE.get()), AutoLubricatorRenderer::new);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onModelBakeEvent(ModelBakeEvent event) {
        ModelResourceLocation mLoc = new ModelResourceLocation(IEBlocks.StoneDecoration.coresample.getRegistryName(), "inventory");
        IBakedModel model = (IBakedModel)event.getModelRegistry().get(mLoc);
        if (model instanceof ModelCoresample) {
            // empty if block
        }
    }

    @Override
    public void renderTile(TileEntity te, IVertexBuilder iVertexBuilder, MatrixStack transform, IRenderTypeBuffer buffer) {
        TileEntityRenderer tesr = TileEntityRendererDispatcher.field_147556_a.func_147547_b(te);
        if (te instanceof PumpjackTileEntity) {
            transform.func_227860_a_();
            transform.func_227863_a_(new Quaternion(0.0f, -90.0f, 0.0f, true));
            transform.func_227861_a_(1.0, 1.0, -2.0);
            float pt = 0.0f;
            if (MCUtil.getPlayer() != null) {
                ((PumpjackTileEntity)te).activeTicks = MCUtil.getPlayer().field_70173_aa;
                pt = Minecraft.func_71410_x().func_184121_ak();
            }
            tesr.func_225616_a_(te, pt, transform, buffer, 0xF000F0, 0);
            transform.func_227865_b_();
        } else {
            transform.func_227860_a_();
            transform.func_227863_a_(new Quaternion(0.0f, -90.0f, 0.0f, true));
            transform.func_227861_a_(0.0, 1.0, -4.0);
            tesr.func_225616_a_(te, 0.0f, transform, buffer, 0xF000F0, 0);
            transform.func_227865_b_();
        }
    }

    @Override
    public void drawUpperHalfSlab(MatrixStack transform, ItemStack stack) {
        BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
        BlockState state = ((Block)IEBlocks.MetalDecoration.steelScaffolding.get(MetalScaffoldingType.STANDARD)).func_176223_P();
        IBakedModel model = blockRenderer.func_175023_a().func_178125_b(state);
        IRenderTypeBuffer.Impl buffers = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        transform.func_227860_a_();
        transform.func_227861_a_(0.0, 0.5, 1.0);
        blockRenderer.func_175019_b().renderModel(transform.func_227866_c_(), buffers.getBuffer(RenderType.func_228639_c_()), state, model, 1.0f, 1.0f, 1.0f, -1, -1, (IModelData)EmptyModelData.INSTANCE);
        transform.func_227865_b_();
    }

    @Override
    public void openProjectorGui(Hand hand, ItemStack held) {
        Minecraft.func_71410_x().func_147108_a((Screen)new ProjectorScreen(hand, held));
    }

    @Override
    public World getClientWorld() {
        return MCUtil.getWorld();
    }

    @Override
    public PlayerEntity getClientPlayer() {
        return MCUtil.getPlayer();
    }

    @Override
    public void handleEntitySound(SoundEvent soundEvent, Entity entity, boolean active, float volume, float pitch) {
    }

    @Override
    public void handleTileSound(SoundEvent soundEvent, TileEntity te, boolean active, float volume, float pitch) {
    }

    public void setupManualPages() {
        ManualInstance man = ManualHelper.getManual();
        IP_CATEGORY = man.getRoot().getOrCreateSubnode((Comparable)ResourceUtils.ip("main"), 100);
        int priority = 0;
        ClientProxy.pumpjack(ResourceUtils.ip("pumpjack"), priority++);
        ClientProxy.distillation(ResourceUtils.ip("distillationtower"), priority++);
        ClientProxy.coker(ResourceUtils.ip("cokerunit"), priority++);
        ClientProxy.hydrotreater(ResourceUtils.ip("hydrotreater"), priority++);
        ClientProxy.handleReservoirManual(ResourceUtils.ip("reservoir"), priority++);
        ClientProxy.lubricant(ResourceUtils.ip("lubricant"), priority++);
        man.addEntry(IP_CATEGORY, ResourceUtils.ip("asphalt"), priority++);
        ClientProxy.projector(ResourceUtils.ip("projector"), priority++);
        ClientProxy.speedboat(ResourceUtils.ip("speedboat"), priority++);
        man.addEntry(IP_CATEGORY, ResourceUtils.ip("napalm"), priority++);
        ClientProxy.generator(ResourceUtils.ip("portablegenerator"), priority++);
        ClientProxy.autolube(ResourceUtils.ip("automaticlubricator"), priority++);
        ClientProxy.flarestack(ResourceUtils.ip("flarestack"), priority++);
    }

    private static void flarestack(ResourceLocation location, int priority) {
        ManualInstance man = ManualHelper.getManual();
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(man);
        builder.addSpecialElement("flarestack0", 0, (SpecialManualElement)new ManualElementCrafting(man, new Object[]{new ItemStack((IItemProvider)IPContent.Blocks.flarestack)}));
        builder.addSpecialElement("flarestack1", 0, () -> {
            Set<ITag<Fluid>> fluids = FlarestackHandler.getSet();
            ArrayList<ITextComponent[]> list = new ArrayList<ITextComponent[]>();
            for (ITag<Fluid> tag : fluids) {
                if (!(tag instanceof ITag.INamedTag)) continue;
                List fl = ((ITag.INamedTag)tag).func_230236_b_();
                for (Fluid f : fl) {
                    ITextComponent[] entry = new ITextComponent[]{StringTextComponent.field_240750_d_, new FluidStack(f, 1).getDisplayName()};
                    list.add(entry);
                }
            }
            return new ManualElementTable(man, (ITextComponent[][])list.toArray((T[])new ITextComponent[0][]), false);
        });
        builder.readFromFile(location);
        man.addEntry(IP_CATEGORY, builder.create(), priority);
    }

    private static void autolube(ResourceLocation location, int priority) {
        ManualInstance man = ManualHelper.getManual();
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(man);
        builder.addSpecialElement("automaticlubricator0", 0, (SpecialManualElement)new ManualElementCrafting(man, new Object[]{new ItemStack((IItemProvider)IPContent.Blocks.auto_lubricator)}));
        builder.readFromFile(location);
        man.addEntry(IP_CATEGORY, builder.create(), priority);
    }

    private static void generator(ResourceLocation location, int priority) {
        ManualInstance man = ManualHelper.getManual();
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(man);
        builder.addSpecialElement("portablegenerator0", 0, (SpecialManualElement)new ManualElementCrafting(man, new Object[]{new ItemStack((IItemProvider)IPContent.Blocks.gas_generator)}));
        builder.readFromFile(location);
        man.addEntry(IP_CATEGORY, builder.create(), priority);
    }

    private static void speedboat(ResourceLocation location, int priority) {
        ManualInstance man = ManualHelper.getManual();
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(man);
        builder.addSpecialElement("speedboat0", 0, (SpecialManualElement)new ManualElementCrafting(man, new Object[]{new ItemStack((IItemProvider)IPContent.Items.speedboat)}));
        builder.addSpecialElement("speedboat1", 0, (SpecialManualElement)new ManualElementCrafting(man, new Object[]{new ItemStack((IItemProvider)IPContent.BoatUpgrades.tank)}));
        builder.addSpecialElement("speedboat2", 0, (SpecialManualElement)new ManualElementCrafting(man, new Object[]{new ItemStack((IItemProvider)IPContent.BoatUpgrades.rudders)}));
        builder.addSpecialElement("speedboat3", 0, (SpecialManualElement)new ManualElementCrafting(man, new Object[]{new ItemStack((IItemProvider)IPContent.BoatUpgrades.ice_breaker)}));
        builder.addSpecialElement("speedboat4", 0, (SpecialManualElement)new ManualElementCrafting(man, new Object[]{new ItemStack((IItemProvider)IPContent.BoatUpgrades.reinforced_hull)}));
        builder.addSpecialElement("speedboat5", 0, (SpecialManualElement)new ManualElementCrafting(man, new Object[]{new ItemStack((IItemProvider)IPContent.BoatUpgrades.paddles)}));
        builder.readFromFile(location);
        man.addEntry(IP_CATEGORY, builder.create(), priority);
    }

    private static void lubricant(ResourceLocation location, int priority) {
        ManualInstance man = ManualHelper.getManual();
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(man);
        builder.addSpecialElement("lubricant1", 0, (SpecialManualElement)new ManualElementCrafting(man, new Object[]{new ItemStack((IItemProvider)IPContent.Items.oil_can)}));
        builder.readFromFile(location);
        man.addEntry(IP_CATEGORY, builder.create(), priority);
    }

    private static void pumpjack(ResourceLocation location, int priority) {
        ManualInstance man = ManualHelper.getManual();
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(man);
        builder.addSpecialElement("pumpjack0", 0, () -> new ManualElementMultiblock(man, (MultiblockHandler.IMultiblock)PumpjackMultiblock.INSTANCE));
        builder.readFromFile(location);
        man.addEntry(IP_CATEGORY, builder.create(), priority);
    }

    private static void distillation(ResourceLocation location, int priority) {
        ManualInstance man = ManualHelper.getManual();
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(man);
        builder.addSpecialElement("distillationtower0", 0, () -> new ManualElementMultiblock(man, (MultiblockHandler.IMultiblock)DistillationTowerMultiblock.INSTANCE));
        builder.addSpecialElement("distillationtower1", 0, () -> {
            Collection<DistillationRecipe> recipeList = DistillationRecipe.recipes.values();
            ArrayList<ITextComponent[]> list = new ArrayList<ITextComponent[]>();
            for (DistillationRecipe recipe : recipeList) {
                boolean first = true;
                for (FluidStack output : recipe.getFluidOutputs()) {
                    ITextComponent outputName = output.getDisplayName();
                    ITextComponent[] entry = new ITextComponent[]{first ? new StringTextComponent(recipe.getInputFluid().getAmount() + "mB ").func_230529_a_(((FluidStack)recipe.getInputFluid().getMatchingFluidStacks().get(0)).getDisplayName()) : StringTextComponent.field_240750_d_, new StringTextComponent(output.getAmount() + "mB ").func_230529_a_(outputName)};
                    list.add(entry);
                    first = false;
                }
            }
            return new ManualElementTable(man, (ITextComponent[][])list.toArray((T[])new ITextComponent[0][]), false);
        });
        builder.readFromFile(location);
        man.addEntry(IP_CATEGORY, builder.create(), priority);
    }

    protected static void coker(ResourceLocation location, int priority) {
        ManualInstance man = ManualHelper.getManual();
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(man);
        builder.addSpecialElement("cokerunit0", 0, () -> new ManualElementMultiblock(man, (MultiblockHandler.IMultiblock)CokerUnitMultiblock.INSTANCE));
        builder.readFromFile(location);
        man.addEntry(IP_CATEGORY, builder.create(), priority);
    }

    protected static void hydrotreater(ResourceLocation location, int priority) {
        ManualInstance man = ManualHelper.getManual();
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(man);
        builder.addSpecialElement("hydrotreater0", 0, () -> new ManualElementMultiblock(man, (MultiblockHandler.IMultiblock)HydroTreaterMultiblock.INSTANCE));
        builder.readFromFile(location);
        man.addEntry(IP_CATEGORY, builder.create(), priority);
    }

    protected static void projector(ResourceLocation location, int priority) {
        ManualInstance man = ManualHelper.getManual();
        ItemStack projectorWithNBT = new ItemStack((IItemProvider)IPContent.Items.projector);
        ItemNBTHelper.putString((ItemStack)projectorWithNBT, (String)"multiblock", (String)IEMultiblocks.ARC_FURNACE.getUniqueName().toString());
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(man);
        builder.addSpecialElement("projector0", 0, (SpecialManualElement)new ManualElementCrafting(man, new Object[]{new ItemStack((IItemProvider)IPContent.Items.projector)}));
        builder.addSpecialElement("projector1", 0, (SpecialManualElement)new ManualElementCrafting(man, new Object[]{projectorWithNBT}));
        builder.readFromFile(location);
        man.addEntry(IP_CATEGORY, builder.create(), priority);
    }

    private static void handleReservoirManual(ResourceLocation location, int priority) {
        ManualInstance man = ManualHelper.getManual();
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(man);
        builder.setContent(ClientProxy::createContent);
        builder.setLocation(location);
        man.addEntry(IP_CATEGORY, builder.create(), priority);
    }

    protected static ManualEntry.EntryData createContentTest(TextSplitter splitter) {
        return new ManualEntry.EntryData("title", "subtext", "content");
    }

    protected static ManualEntry.EntryData createContent(TextSplitter splitter) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        PumpjackHandler.ReservoirType[] reservoirs = PumpjackHandler.reservoirs.values().toArray(new PumpjackHandler.ReservoirType[0]);
        StringBuilder contentBuilder = new StringBuilder();
        contentBuilder.append(I18n.func_135052_a((String)"ie.manual.entry.reservoirs.oil0", (Object[])new Object[0]));
        contentBuilder.append(I18n.func_135052_a((String)"ie.manual.entry.reservoirs.oil1", (Object[])new Object[0]));
        for (int i = 0; i < reservoirs.length; ++i) {
            Biome bio;
            char c;
            PumpjackHandler.ReservoirType type = reservoirs[i];
            ImmersivePetroleum.log.debug("Creating entry for " + (Object)((Object)type));
            String name = "desc.immersivepetroleum.info.reservoir." + type.name;
            String localizedName = I18n.func_135052_a((String)name, (Object[])new Object[0]);
            if (localizedName.equalsIgnoreCase(name)) {
                localizedName = type.name;
            }
            boolean isVowel = (c = localizedName.toLowerCase().charAt(0)) == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u';
            String aOrAn = I18n.func_135052_a((String)(isVowel ? "ie.manual.entry.reservoirs.vowel" : "ie.manual.entry.reservoirs.consonant"), (Object[])new Object[0]);
            String dimBLWL = "";
            if (type.dimWhitelist != null && type.dimWhitelist.size() > 0) {
                String validDims = "";
                for (ResourceLocation resourceLocation : type.dimWhitelist) {
                    validDims = validDims + (!validDims.isEmpty() ? ", " : "") + "<dim;" + resourceLocation + ">";
                }
                dimBLWL = I18n.func_135052_a((String)"ie.manual.entry.reservoirs.dim.valid", (Object[])new Object[]{localizedName, validDims, aOrAn});
            } else if (type.dimBlacklist != null && type.dimBlacklist.size() > 0) {
                String invalidDims = "";
                for (ResourceLocation resourceLocation : type.dimBlacklist) {
                    invalidDims = invalidDims + (!invalidDims.isEmpty() ? ", " : "") + "<dim;" + resourceLocation + ">";
                }
                dimBLWL = I18n.func_135052_a((String)"ie.manual.entry.reservoirs.dim.invalid", (Object[])new Object[]{localizedName, invalidDims, aOrAn});
            } else {
                dimBLWL = I18n.func_135052_a((String)"ie.manual.entry.reservoirs.dim.any", (Object[])new Object[]{localizedName, aOrAn});
            }
            String bioBLWL = "";
            if (type.bioWhitelist != null && type.bioWhitelist.size() > 0) {
                String validBiomes = "";
                for (ResourceLocation rl : type.bioWhitelist) {
                    bio = (Biome)ForgeRegistries.BIOMES.getValue(rl);
                    validBiomes = validBiomes + (!validBiomes.isEmpty() ? ", " : "") + (bio != null ? bio.toString() : rl);
                }
                bioBLWL = I18n.func_135052_a((String)"ie.manual.entry.reservoirs.bio.valid", (Object[])new Object[]{validBiomes});
            } else if (type.bioBlacklist != null && type.bioBlacklist.size() > 0) {
                String invalidBiomes = "";
                for (ResourceLocation rl : type.bioBlacklist) {
                    bio = (Biome)ForgeRegistries.BIOMES.getValue(rl);
                    invalidBiomes = invalidBiomes + (!invalidBiomes.isEmpty() ? ", " : "") + (bio != null ? bio.toString() : rl);
                }
                bioBLWL = I18n.func_135052_a((String)"ie.manual.entry.reservoirs.bio.invalid", (Object[])new Object[]{invalidBiomes});
            } else {
                bioBLWL = I18n.func_135052_a((String)"ie.manual.entry.reservoirs.bio.any", (Object[])new Object[0]);
            }
            String fluidName = "";
            Fluid fluid = type.getFluid();
            if (fluid != null) {
                fluidName = new FluidStack(fluid, 1).getDisplayName().getString();
            }
            String repRate = "";
            if (type.replenishRate > 0) {
                repRate = I18n.func_135052_a((String)"ie.manual.entry.reservoirs.replenish", (Object[])new Object[]{type.replenishRate, fluidName});
            }
            contentBuilder.append(I18n.func_135052_a((String)"ie.manual.entry.reservoirs.content", (Object[])new Object[]{dimBLWL, fluidName, FORMATTER.format(type.minSize), FORMATTER.format(type.maxSize), repRate, bioBLWL}));
            if (i < reservoirs.length - 1) {
                contentBuilder.append("<np>");
            }
            list.add(new ItemStack((IItemProvider)fluid.func_204524_b()));
        }
        String translatedTitle = I18n.func_135052_a((String)"ie.manual.entry.reservoirs.title", (Object[])new Object[0]);
        String tanslatedSubtext = I18n.func_135052_a((String)"ie.manual.entry.reservoirs.subtitle", (Object[])new Object[0]);
        String formattedContent = contentBuilder.toString().replaceAll("\r\n|\r|\n", "\n");
        return new ManualEntry.EntryData(translatedTitle, tanslatedSubtext, formattedContent);
    }

    static {
        FORMATTER = new DecimalFormat("#,###.##");
    }
}

