/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.entity;

import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.api.energy.FuelHandler;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.items.DebugItem;
import flaxbeard.immersivepetroleum.common.items.MotorboatItem;
import flaxbeard.immersivepetroleum.common.network.IPPacketHandler;
import flaxbeard.immersivepetroleum.common.network.MessageConsumeBoatFuel;
import flaxbeard.immersivepetroleum.common.util.IPItemStackHandler;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.client.CSteerBoatPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class MotorboatEntity
extends BoatEntity
implements IEntityAdditionalSpawnData {
    public static final EntityType<MotorboatEntity> TYPE = MotorboatEntity.createType();
    static final DataParameter<String> TANK_FLUID = EntityDataManager.func_187226_a(MotorboatEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    static final DataParameter<Integer> TANK_AMOUNT = EntityDataManager.func_187226_a(MotorboatEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    static final DataParameter<ItemStack> UPGRADE_0 = EntityDataManager.func_187226_a(MotorboatEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    static final DataParameter<ItemStack> UPGRADE_1 = EntityDataManager.func_187226_a(MotorboatEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    static final DataParameter<ItemStack> UPGRADE_2 = EntityDataManager.func_187226_a(MotorboatEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    static final DataParameter<ItemStack> UPGRADE_3 = EntityDataManager.func_187226_a(MotorboatEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    public boolean isFireproof = false;
    public boolean hasIcebreaker = false;
    public boolean hasTank = false;
    public boolean hasRudders = false;
    public boolean hasPaddles = false;
    public boolean isBoosting = false;
    public float lastMoving;
    public float propellerYRotation = 0.0f;
    public float propellerXRot = 0.0f;
    public float propellerXRotSpeed = 0.0f;

    private static EntityType<MotorboatEntity> createType() {
        EntityType ret = EntityType.Builder.func_220322_a(MotorboatEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(1.375f, 0.5625f).func_206830_a("immersivepetroleum:speedboat");
        ret.setRegistryName(ResourceUtils.ip("speedboat"));
        return ret;
    }

    public static DataParameter<Byte> getFlags() {
        return field_184240_ax;
    }

    public MotorboatEntity(World world) {
        this(TYPE, world);
    }

    public MotorboatEntity(World world, double x, double y, double z) {
        this(TYPE, world);
        this.func_70107_b(x, y, z);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    public MotorboatEntity(EntityType<MotorboatEntity> type, World world) {
        super(type, world);
        this.field_70156_m = true;
    }

    public EntityType<?> func_200600_R() {
        return TYPE;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TANK_FLUID, (Object)"");
        this.field_70180_af.func_187214_a(TANK_AMOUNT, (Object)0);
        this.field_70180_af.func_187214_a(UPGRADE_0, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(UPGRADE_1, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(UPGRADE_2, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(UPGRADE_3, (Object)ItemStack.field_190927_a);
    }

    public void setUpgrades(NonNullList<ItemStack> stacks) {
        if (stacks != null && stacks.size() > 0) {
            ItemStack o0 = stacks.get(0) == null ? ItemStack.field_190927_a : (ItemStack)stacks.get(0);
            ItemStack o1 = stacks.get(1) == null ? ItemStack.field_190927_a : (ItemStack)stacks.get(1);
            ItemStack o2 = stacks.get(2) == null ? ItemStack.field_190927_a : (ItemStack)stacks.get(2);
            ItemStack o3 = stacks.get(3) == null ? ItemStack.field_190927_a : (ItemStack)stacks.get(3);
            this.field_70180_af.func_187227_b(UPGRADE_0, (Object)o0);
            this.field_70180_af.func_187227_b(UPGRADE_1, (Object)o1);
            this.field_70180_af.func_187227_b(UPGRADE_2, (Object)o2);
            this.field_70180_af.func_187227_b(UPGRADE_3, (Object)o3);
        }
    }

    public boolean isLeftDown() {
        return this.field_184480_az;
    }

    public boolean isRightDown() {
        return this.field_184459_aA;
    }

    public boolean isForwardDown() {
        return this.field_184461_aB;
    }

    public boolean isBackDown() {
        return this.field_184463_aC;
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (key == UPGRADE_0 || key == UPGRADE_1 || key == UPGRADE_2 || key == UPGRADE_3) {
            NonNullList<ItemStack> upgrades = this.getUpgrades();
            this.isFireproof = false;
            this.hasIcebreaker = false;
            for (ItemStack upgrade : upgrades) {
                if (upgrade == null || upgrade == ItemStack.field_190927_a) continue;
                Item item = upgrade.func_77973_b();
                if (item == IPContent.BoatUpgrades.reinforced_hull) {
                    this.isFireproof = true;
                    continue;
                }
                if (item == IPContent.BoatUpgrades.ice_breaker) {
                    this.hasIcebreaker = true;
                    continue;
                }
                if (item == IPContent.BoatUpgrades.tank) {
                    this.hasTank = true;
                    continue;
                }
                if (item == IPContent.BoatUpgrades.rudders) {
                    this.hasRudders = true;
                    continue;
                }
                if (item != IPContent.BoatUpgrades.paddles) continue;
                this.hasPaddles = true;
            }
        }
    }

    public void setContainedFluid(FluidStack stack) {
        if (stack == null) {
            this.field_70180_af.func_187227_b(TANK_FLUID, (Object)"");
            this.field_70180_af.func_187227_b(TANK_AMOUNT, (Object)0);
        } else {
            this.field_70180_af.func_187227_b(TANK_FLUID, (Object)(stack.getFluid() == null ? "" : stack.getFluid().getRegistryName().toString()));
            this.field_70180_af.func_187227_b(TANK_AMOUNT, (Object)stack.getAmount());
        }
    }

    public FluidStack getContainedFluid() {
        String fluidName = (String)this.field_70180_af.func_187225_a(TANK_FLUID);
        int amount = (Integer)this.field_70180_af.func_187225_a(TANK_AMOUNT);
        if (fluidName == null || fluidName.isEmpty() || amount == 0) {
            return FluidStack.EMPTY;
        }
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidName));
        if (fluid == null) {
            return FluidStack.EMPTY;
        }
        return new FluidStack(fluid, amount);
    }

    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        String fluid = "";
        int amount = 0;
        ItemStack stack0 = ItemStack.field_190927_a;
        ItemStack stack1 = ItemStack.field_190927_a;
        ItemStack stack2 = ItemStack.field_190927_a;
        ItemStack stack3 = ItemStack.field_190927_a;
        if (compound.func_74764_b("tank")) {
            CompoundNBT tank = compound.func_74775_l("tank");
            fluid = tank.func_74779_i("fluid");
            amount = tank.func_74762_e("amount");
        }
        if (compound.func_74764_b("upgrades")) {
            CompoundNBT upgrades = compound.func_74775_l("upgrades");
            stack0 = ItemStack.func_199557_a((CompoundNBT)upgrades.func_74775_l("0"));
            stack1 = ItemStack.func_199557_a((CompoundNBT)upgrades.func_74775_l("1"));
            stack2 = ItemStack.func_199557_a((CompoundNBT)upgrades.func_74775_l("2"));
            stack3 = ItemStack.func_199557_a((CompoundNBT)upgrades.func_74775_l("3"));
        }
        this.field_70180_af.func_187227_b(TANK_FLUID, (Object)fluid);
        this.field_70180_af.func_187227_b(TANK_AMOUNT, (Object)amount);
        this.field_70180_af.func_187227_b(UPGRADE_0, (Object)stack0);
        this.field_70180_af.func_187227_b(UPGRADE_1, (Object)stack1);
        this.field_70180_af.func_187227_b(UPGRADE_2, (Object)stack2);
        this.field_70180_af.func_187227_b(UPGRADE_3, (Object)stack3);
    }

    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        String fluid = (String)this.field_70180_af.func_187225_a(TANK_FLUID);
        int amount = (Integer)this.field_70180_af.func_187225_a(TANK_AMOUNT);
        ItemStack stack0 = (ItemStack)this.field_70180_af.func_187225_a(UPGRADE_0);
        ItemStack stack1 = (ItemStack)this.field_70180_af.func_187225_a(UPGRADE_1);
        ItemStack stack2 = (ItemStack)this.field_70180_af.func_187225_a(UPGRADE_2);
        ItemStack stack3 = (ItemStack)this.field_70180_af.func_187225_a(UPGRADE_3);
        CompoundNBT tank = new CompoundNBT();
        tank.func_74778_a("fluid", fluid);
        tank.func_74768_a("amount", amount);
        compound.func_218657_a("tank", (INBT)tank);
        CompoundNBT upgrades = new CompoundNBT();
        upgrades.func_218657_a("0", (INBT)stack0.serializeNBT());
        upgrades.func_218657_a("1", (INBT)stack1.serializeNBT());
        upgrades.func_218657_a("2", (INBT)stack2.serializeNBT());
        upgrades.func_218657_a("3", (INBT)stack3.serializeNBT());
        compound.func_218657_a("upgrades", (INBT)upgrades);
    }

    public double func_70042_X() {
        return this.func_180799_ab() ? 0.14375000596046447 : -0.1;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source) || this.isFireproof && source.func_76347_k()) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            boolean isCreativePlayer;
            if (source instanceof IndirectEntityDamageSource && source.func_76364_f() != null && this.func_184196_w(source.func_76364_f())) {
                return false;
            }
            this.func_70269_c(-this.func_70267_i());
            this.func_70265_b(10);
            this.func_70266_a(this.func_70271_g() + amount * 10.0f);
            this.func_70018_K();
            boolean isPlayer = source.func_76364_f() instanceof PlayerEntity;
            boolean bl = isCreativePlayer = isPlayer && ((PlayerEntity)source.func_76364_f()).field_71075_bZ.field_75098_d;
            if ((isCreativePlayer || this.func_70271_g() > 40.0f) && (!this.isFireproof || isPlayer) || this.func_70271_g() > 240.0f) {
                if (!isCreativePlayer && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                    MotorboatItem item = (MotorboatItem)this.func_184455_j();
                    ItemStack stack = new ItemStack((IItemProvider)item, 1);
                    IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElse(null);
                    if (handler != null && handler instanceof IPItemStackHandler) {
                        NonNullList<ItemStack> upgrades = this.getUpgrades();
                        for (int i = 0; i < handler.getSlots(); ++i) {
                            handler.insertItem(i, (ItemStack)upgrades.get(i), false);
                        }
                    }
                    this.writeTank(stack.func_196082_o(), true);
                    if (isPlayer) {
                        PlayerEntity player = (PlayerEntity)source.func_76364_f();
                        if (!player.func_191521_c(stack)) {
                            ItemEntity itemEntity = new ItemEntity(this.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), stack);
                            itemEntity.func_174868_q();
                            this.field_70170_p.func_217376_c((Entity)itemEntity);
                        }
                    } else {
                        this.func_70099_a(stack, 0.0f);
                    }
                }
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    public void readTank(CompoundNBT nbt) {
        FluidTank tank = new FluidTank(this.getMaxFuel());
        if (nbt != null) {
            tank.readFromNBT(nbt.func_74775_l("tank"));
        }
        this.setContainedFluid(tank.getFluid());
    }

    public void writeTank(CompoundNBT nbt, boolean toItem) {
        boolean write;
        FluidTank tank = new FluidTank(this.getMaxFuel());
        tank.setFluid(this.getContainedFluid());
        boolean bl = write = tank.getFluidAmount() > 0;
        if (!toItem || write) {
            nbt.func_218657_a("tank", (INBT)tank.writeToNBT(new CompoundNBT()));
        }
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack != ItemStack.field_190927_a && stack.func_77973_b() instanceof DebugItem) {
            ((DebugItem)stack.func_77973_b()).onSpeedboatClick(this, player, stack);
            return ActionResultType.SUCCESS;
        }
        if (Utils.isFluidRelatedItemStack((ItemStack)stack)) {
            FluidStack fstack = FluidUtil.getFluidContained((ItemStack)stack).orElse(null);
            if (fstack != null) {
                FluidTank tank = new FluidTank(this.getMaxFuel()){

                    public boolean isFluidValid(FluidStack stack) {
                        return FuelHandler.isValidBoatFuel(stack.getFluid());
                    }
                };
                FluidStack fs = this.getContainedFluid();
                tank.setFluid(fs);
                FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (IFluidHandler)tank);
                this.setContainedFluid(tank.getFluid());
            }
            return ActionResultType.SUCCESS;
        }
        if (!this.field_70170_p.field_72995_K && !player.func_225608_bj_() && this.field_184474_h < 60.0f && !player.func_184223_x((Entity)this)) {
            player.func_184220_m((Entity)this);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public void func_184442_a(boolean p_184442_1_, boolean p_184442_2_, boolean p_184442_3_, boolean p_184442_4_) {
        super.func_184442_a(p_184442_1_, p_184442_2_, p_184442_3_, p_184442_4_);
        this.isBoosting = this.isEmergency() ? false : this.field_184461_aB && Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d();
    }

    public void func_70071_h_() {
        List list;
        this.field_184471_aG = this.field_184469_aF;
        this.field_184469_aF = this.func_184449_t();
        this.field_184474_h = this.field_184469_aF != BoatEntity.Status.UNDER_WATER && this.field_184469_aF != BoatEntity.Status.UNDER_FLOWING_WATER ? 0.0f : (this.field_184474_h += 1.0f);
        if (!this.field_70170_p.field_72995_K && this.field_184474_h >= 60.0f) {
            this.func_184226_ay();
        }
        if (this.func_70268_h() > 0) {
            this.func_70265_b(this.func_70268_h() - 1);
        }
        if (this.func_70271_g() > 0.0f) {
            this.func_70266_a(this.func_70271_g() - 1.0f);
        }
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_225510_bt_());
        }
        this.func_70030_z();
        this.func_184447_s();
        if (this.func_184186_bw()) {
            if (this.func_184188_bt().isEmpty() || !(this.func_184188_bt().get(0) instanceof PlayerEntity)) {
                this.func_184445_a(false, false);
            }
            this.func_184450_w();
            if (this.field_70170_p.field_72995_K) {
                this.func_184443_x();
                this.field_70170_p.func_184135_a((IPacket)new CSteerBoatPacket(this.func_184457_a(0), this.func_184457_a(1)));
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        } else {
            this.func_213317_d(Vector3d.field_186680_a);
        }
        this.func_203057_r();
        if (this.field_70170_p.field_72995_K) {
            if (!this.isEmergency()) {
                float yO;
                float zO;
                float xO;
                float moving;
                float f = this.field_184461_aB || this.field_184463_aC ? (this.isBoosting ? 0.9f : 0.7f) : (moving = 0.5f);
                if (this.lastMoving != moving) {
                    ImmersivePetroleum.proxy.handleEntitySound(IESounds.dieselGenerator, (Entity)this, false, 0.5f, 0.5f);
                }
                ImmersivePetroleum.proxy.handleEntitySound(IESounds.dieselGenerator, (Entity)this, this.func_184207_aI() && this.getContainedFluid() != FluidStack.EMPTY && this.getContainedFluid().getAmount() > 0, this.field_184461_aB || this.field_184463_aC ? 0.5f : 0.3f, moving);
                this.lastMoving = moving;
                if (this.field_184461_aB && this.field_70170_p.field_73012_v.nextInt(2) == 0) {
                    if (this.func_180799_ab()) {
                        if (this.field_70170_p.field_73012_v.nextInt(3) == 0) {
                            xO = MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) + (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.3f;
                            zO = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) + (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.3f;
                            yO = 0.4f + (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.3f;
                            Vector3d motion = this.func_213322_ci();
                            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197595_F, this.func_226277_ct_() - (double)(xO * 1.5f), this.func_226278_cu_() + (double)yO, this.func_226281_cx_() - (double)(zO * 1.5f), -2.0 * motion.func_82615_a(), 0.0, -2.0 * motion.func_82616_c());
                        }
                    } else {
                        xO = MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) + (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.3f;
                        zO = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) + (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.3f;
                        yO = 0.1f + (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.3f;
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_() - (double)(xO * 1.5f), this.func_226278_cu_() + (double)yO, this.func_226281_cx_() - (double)(zO * 1.5f), 0.0, 0.0, 0.0);
                    }
                }
                if (this.isBoosting && this.field_70170_p.field_73012_v.nextInt(2) == 0) {
                    xO = MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) + (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.3f;
                    zO = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) + (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.3f;
                    yO = 0.8f + (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.3f;
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_() - (double)(xO * 1.3f), this.func_226278_cu_() + (double)yO, this.func_226281_cx_() - (double)(zO * 1.3f), 0.0, 0.0, 0.0);
                }
            } else {
                ImmersivePetroleum.proxy.handleEntitySound(IESounds.dieselGenerator, (Entity)this, false, 0.5f, 0.5f);
            }
        }
        if (this.isEmergency()) {
            for (int i = 0; i <= 1; ++i) {
                this.field_184470_f[i] = this.func_184457_a(i) ? (float)((double)this.field_184470_f[i] + 0.7853981852531433) : 0.0f;
            }
        } else if (this.func_184457_a(0)) {
            this.field_184470_f[0] = (float)((double)this.field_184470_f[0] + (this.isBoosting ? 0.02 : 0.01));
        } else if (this.func_184457_a(1)) {
            this.field_184470_f[0] = (float)((double)this.field_184470_f[0] - 0.01);
        }
        float xO = MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180)));
        float zO = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
        Vector3f vec = this.normalizeVector(new Vector3f(xO, zO, 0.0f));
        if (!this.field_70170_p.field_72995_K && this.hasIcebreaker && !this.isEmergency()) {
            AxisAlignedBB bb = this.func_174813_aQ().func_186662_g(0.1);
            BlockPos.Mutable mutableBlockPos0 = new BlockPos.Mutable(bb.field_72340_a + 0.001, bb.field_72338_b + 0.001, bb.field_72339_c + 0.001);
            BlockPos.Mutable mutableBlockPos1 = new BlockPos.Mutable(bb.field_72336_d - 0.001, bb.field_72337_e - 0.001, bb.field_72334_f - 0.001);
            BlockPos.Mutable mutableBlockPos2 = new BlockPos.Mutable();
            if (this.field_70170_p.func_175707_a((BlockPos)mutableBlockPos0, (BlockPos)mutableBlockPos1)) {
                for (int i = mutableBlockPos0.func_177958_n(); i <= mutableBlockPos1.func_177958_n(); ++i) {
                    for (int j = mutableBlockPos0.func_177956_o(); j <= mutableBlockPos1.func_177956_o(); ++j) {
                        for (int k = mutableBlockPos0.func_177952_p(); k <= mutableBlockPos1.func_177952_p(); ++k) {
                            mutableBlockPos2.func_181079_c(i, j, k);
                            BlockState BlockState2 = this.field_70170_p.func_180495_p((BlockPos)mutableBlockPos2);
                            Vector3f vec2 = new Vector3f((float)((double)((float)i + 0.5f) - this.func_226277_ct_()), (float)((double)((float)k + 0.5f) - this.func_226281_cx_()), 0.0f);
                            this.normalizeVector(vec2);
                            float sim = this.dotVector(vec2, vec);
                            if (BlockState2.func_177230_c() != Blocks.field_150432_aD || !(sim > 0.3f)) continue;
                            this.field_70170_p.func_175655_b((BlockPos)mutableBlockPos2, false);
                            this.field_70170_p.func_175656_a((BlockPos)mutableBlockPos2, Blocks.field_150355_j.func_176223_P());
                        }
                    }
                }
            }
        }
        this.func_145775_I();
        if (!this.field_70170_p.field_72995_K && !(list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b((double)0.2f, (double)-0.01f, (double)0.2f), EntityPredicates.func_200823_a((Entity)this))).isEmpty()) {
            boolean flag = !(this.func_184179_bs() instanceof PlayerEntity);
            for (int j = 0; j < list.size(); ++j) {
                Entity entity = (Entity)list.get(j);
                if (entity.func_184196_w((Entity)this)) continue;
                if (flag && this.func_184188_bt().size() < 2 && !entity.func_184218_aH() && entity.func_213311_cf() < this.func_213311_cf() && entity instanceof LivingEntity && !(entity instanceof WaterMobEntity) && !(entity instanceof PlayerEntity)) {
                    entity.func_184220_m((Entity)this);
                    continue;
                }
                this.func_70108_f(entity);
                if (!this.hasIcebreaker || !(entity instanceof LivingEntity) || entity instanceof PlayerEntity || !(this.func_184179_bs() instanceof PlayerEntity)) continue;
                Vector3f vec2 = new Vector3f((float)(entity.func_226277_ct_() - this.func_226277_ct_()), (float)(entity.func_226281_cx_() - this.func_226281_cx_()), 0.0f);
                this.normalizeVector(vec2);
                float sim = this.dotVector(vec2, vec);
                if (!(sim > 0.5f)) continue;
                Vector3d motion = entity.func_213322_ci();
                entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)this.func_184179_bs())), 4.0f);
                entity.func_213317_d(new Vector3d(motion.field_72450_a + (double)(vec2.func_195899_a() * 0.75f), motion.field_72448_b, motion.field_72449_c + (double)(vec2.func_195900_b() * 0.75f)));
            }
        }
    }

    private Vector3f normalizeVector(Vector3f vec) {
        float f = vec.func_195899_a() * vec.func_195899_a() + vec.func_195900_b() * vec.func_195900_b() + vec.func_195902_c() * vec.func_195902_c();
        if (f >= 1.0E-5f) {
            f = 1.0f / MathHelper.func_76129_c((float)f);
            vec.setX(vec.func_195899_a() * f);
            vec.setY(vec.func_195900_b() * f);
            vec.setZ(vec.func_195902_c() * f);
        }
        return vec;
    }

    private float dotVector(Vector3f a, Vector3f b) {
        return a.func_195899_a() * b.func_195899_a() + a.func_195900_b() * b.func_195900_b() + a.func_195902_c() * b.func_195902_c();
    }

    protected void func_184443_x() {
        if (this.func_184207_aI()) {
            float f = 0.0f;
            if (this.isEmergency()) {
                if (this.field_184480_az) {
                    this.field_184475_as -= 1.0f;
                }
                if (this.field_184459_aA) {
                    this.field_184475_as += 1.0f;
                }
                if (this.field_184459_aA != this.field_184480_az && !this.field_184461_aB && !this.field_184463_aC) {
                    f += 0.005f;
                }
                this.field_70177_z += this.field_184475_as;
                if (this.field_184461_aB) {
                    f += 0.04f;
                }
                if (this.field_184463_aC) {
                    f -= 0.005f;
                }
                this.func_213317_d(this.func_213322_ci().func_72441_c((double)(MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) * f), 0.0, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * f)));
                this.func_184445_a(this.field_184459_aA && !this.field_184480_az || this.field_184461_aB, this.field_184480_az && !this.field_184459_aA || this.field_184461_aB);
            } else {
                FluidStack fluid = this.getContainedFluid();
                int consumeAmount = 0;
                if (fluid != FluidStack.EMPTY) {
                    consumeAmount = FuelHandler.getBoatFuelUsedPerTick(fluid.getFluid());
                }
                if (fluid != FluidStack.EMPTY && fluid.getAmount() >= consumeAmount && (this.field_184461_aB || this.field_184463_aC)) {
                    int toConsume = consumeAmount;
                    if (this.field_184461_aB) {
                        f += 0.05f;
                        if (this.isBoosting && fluid.getAmount() >= 3 * consumeAmount) {
                            f = (float)((double)f * 1.6);
                            toConsume *= 3;
                        }
                    }
                    if (this.field_184463_aC) {
                        f -= 0.01f;
                    }
                    fluid.setAmount(Math.max(0, fluid.getAmount() - toConsume));
                    this.setContainedFluid(fluid);
                    if (this.field_70170_p.field_72995_K) {
                        IPPacketHandler.sendToServer(new MessageConsumeBoatFuel(toConsume));
                    }
                    this.func_184445_a(this.field_184461_aB, this.field_184463_aC);
                } else {
                    this.func_184445_a(false, false);
                }
                Vector3d motion = this.func_213322_ci().func_72441_c((double)(MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) * f), 0.0, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * f));
                if (this.field_184480_az || this.field_184459_aA) {
                    float speed = MathHelper.func_76133_a((double)(motion.field_72450_a * motion.field_72450_a + motion.field_72449_c * motion.field_72449_c));
                    if (this.field_184459_aA) {
                        this.field_184475_as += 1.1f * speed * (this.hasRudders ? 1.5f : 1.0f) * (this.isBoosting ? 0.5f : 1.0f) * (this.field_184463_aC && !this.field_184461_aB ? 2.0f : 1.0f);
                        this.propellerYRotation = MathHelper.func_76131_a((float)(this.propellerYRotation - 0.2f), (float)-1.0f, (float)1.0f);
                    }
                    if (this.field_184480_az) {
                        this.field_184475_as -= 1.1f * speed * (this.hasRudders ? 1.5f : 1.0f) * (this.isBoosting ? 0.5f : 1.0f) * (this.field_184463_aC && !this.field_184461_aB ? 2.0f : 1.0f);
                        this.propellerYRotation = MathHelper.func_76131_a((float)(this.propellerYRotation + 0.2f), (float)-1.0f, (float)1.0f);
                    }
                }
                if (!this.field_184480_az && !this.field_184459_aA && this.propellerYRotation != 0.0f) {
                    this.propellerYRotation *= 0.7f;
                    if (this.propellerYRotation > -0.01f && this.propellerYRotation < 0.01f) {
                        this.propellerYRotation = 0.0f;
                    }
                }
                this.field_70177_z += this.field_184475_as;
                this.func_213317_d(motion);
                this.func_184445_a(this.field_184459_aA && !this.field_184480_az || this.field_184461_aB, this.field_184480_az && !this.field_184459_aA || this.field_184461_aB);
            }
        }
    }

    public int getMaxFuel() {
        return this.hasTank ? 16000 : 8000;
    }

    public Item func_184455_j() {
        return IPContent.Items.speedboat;
    }

    public boolean func_70027_ad() {
        if (this.isFireproof) {
            return false;
        }
        return super.func_70027_ad();
    }

    public boolean isEmergency() {
        FluidStack fluid = this.getContainedFluid();
        if (fluid != FluidStack.EMPTY) {
            int consumeAmount = FuelHandler.getBoatFuelUsedPerTick(fluid.getFluid());
            return fluid.getAmount() < consumeAmount && this.hasPaddles;
        }
        return this.hasPaddles;
    }

    public NonNullList<ItemStack> getUpgrades() {
        NonNullList stackList = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
        stackList.set(0, this.field_70180_af.func_187225_a(UPGRADE_0));
        stackList.set(1, this.field_70180_af.func_187225_a(UPGRADE_1));
        stackList.set(2, this.field_70180_af.func_187225_a(UPGRADE_2));
        stackList.set(3, this.field_70180_af.func_187225_a(UPGRADE_3));
        return stackList;
    }

    public String[] getOverlayText(PlayerEntity player, RayTraceResult mop) {
        if (Utils.isFluidRelatedItemStack((ItemStack)player.func_184586_b(Hand.MAIN_HAND))) {
            String s = null;
            FluidStack stack = this.getContainedFluid();
            s = stack != FluidStack.EMPTY ? stack.getDisplayName().getString() + ": " + stack.getAmount() + "mB" : I18n.func_135052_a((String)"gui.immersiveengineering.empty", (Object[])new Object[0]);
            return new String[]{s};
        }
        return null;
    }

    public float func_184451_k() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72337_e - this.field_184473_aH));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        block0: for (int k1 = k; k1 < l; ++k1) {
            float f = 0.0f;
            for (int l1 = i; l1 < j; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.func_181079_c(l1, k1, i2);
                    FluidState fluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$mutable);
                    if (fluidstate.func_206884_a((ITag)FluidTags.field_206959_a) || this.isFireproof && fluidstate.func_206884_a((ITag)FluidTags.field_206960_b)) {
                        f = Math.max(f, fluidstate.func_215679_a((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable));
                    }
                    if (f >= 1.0f) continue block0;
                }
            }
            if (!(f < 1.0f)) continue;
            return (float)blockpos$mutable.func_177956_o() + f;
        }
        return l + 1;
    }

    protected boolean func_184446_u() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72338_b + 0.001));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        this.field_184465_aD = Double.MIN_VALUE;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.func_181079_c(k1, l1, i2);
                    FluidState fluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$mutable);
                    if (!fluidstate.func_206884_a((ITag)FluidTags.field_206959_a) && (!this.isFireproof || !fluidstate.func_206884_a((ITag)FluidTags.field_206960_b))) continue;
                    float f = (float)l1 + fluidstate.func_215679_a((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable);
                    this.field_184465_aD = Math.max((double)f, this.field_184465_aD);
                    flag |= axisalignedbb.field_72338_b < (double)f;
                }
            }
        }
        return flag;
    }

    protected BoatEntity.Status func_184444_v() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        double d0 = axisalignedbb.field_72337_e + 0.001;
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int l = MathHelper.func_76143_f((double)d0);
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.func_181079_c(k1, l1, i2);
                    FluidState fluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$mutable);
                    if (!fluidstate.func_206884_a((ITag)FluidTags.field_206959_a) && (!this.isFireproof || !fluidstate.func_206884_a((ITag)FluidTags.field_206960_b)) || !(d0 < (double)((float)blockpos$mutable.func_177956_o() + fluidstate.func_215679_a((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable)))) continue;
                    if (!fluidstate.func_206889_d()) {
                        return BoatEntity.Status.UNDER_FLOWING_WATER;
                    }
                    flag = true;
                }
            }
        }
        return flag ? BoatEntity.Status.UNDER_WATER : null;
    }

    public boolean isLeftInDown() {
        return this.field_184480_az;
    }

    public boolean isRightInDown() {
        return this.field_184459_aA;
    }

    public boolean isForwardInDown() {
        return this.field_184461_aB;
    }

    public boolean isBackInDown() {
        return this.field_184463_aC;
    }

    public boolean func_70083_f(int flag) {
        return super.func_70083_f(flag);
    }

    public void func_70052_a(int flag, boolean set) {
        super.func_70052_a(flag, set);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void readSpawnData(PacketBuffer buffer) {
        String fluid = buffer.func_218666_n();
        int amount = buffer.readInt();
        ItemStack stack0 = buffer.func_150791_c();
        ItemStack stack1 = buffer.func_150791_c();
        ItemStack stack2 = buffer.func_150791_c();
        ItemStack stack3 = buffer.func_150791_c();
        this.field_70180_af.func_187227_b(TANK_FLUID, (Object)fluid);
        this.field_70180_af.func_187227_b(TANK_AMOUNT, (Object)amount);
        this.field_70180_af.func_187227_b(UPGRADE_0, (Object)stack0);
        this.field_70180_af.func_187227_b(UPGRADE_1, (Object)stack1);
        this.field_70180_af.func_187227_b(UPGRADE_2, (Object)stack2);
        this.field_70180_af.func_187227_b(UPGRADE_3, (Object)stack3);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        String fluid = (String)this.field_70180_af.func_187225_a(TANK_FLUID);
        int amount = (Integer)this.field_70180_af.func_187225_a(TANK_AMOUNT);
        ItemStack stack0 = (ItemStack)this.field_70180_af.func_187225_a(UPGRADE_0);
        ItemStack stack1 = (ItemStack)this.field_70180_af.func_187225_a(UPGRADE_1);
        ItemStack stack2 = (ItemStack)this.field_70180_af.func_187225_a(UPGRADE_2);
        ItemStack stack3 = (ItemStack)this.field_70180_af.func_187225_a(UPGRADE_3);
        buffer.func_180714_a(fluid);
        buffer.writeInt(amount);
        buffer.func_150788_a(stack0);
        buffer.func_150788_a(stack1);
        buffer.func_150788_a(stack2);
        buffer.func_150788_a(stack3);
    }
}

