/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.projector;

import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.api.utils.TemplateWorldCreator;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;

public class MultiblockProjection {
    final MultiblockHandler.IMultiblock multiblock;
    final World realWorld;
    final World templateWorld;
    final PlacementSettings settings = new PlacementSettings();
    final Int2ObjectMap<List<Template.BlockInfo>> layers = new Int2ObjectArrayMap();
    final BlockPos.Mutable offset = new BlockPos.Mutable();
    final int blockcount;
    boolean isDirty = true;

    public MultiblockProjection(@Nonnull World world, @Nonnull MultiblockHandler.IMultiblock multiblock) {
        Objects.requireNonNull(world, "World cannot be null!");
        Objects.requireNonNull(multiblock, "Multiblock cannot be null!");
        this.multiblock = multiblock;
        this.realWorld = world;
        List blocks = multiblock.getStructure(world);
        this.templateWorld = ((TemplateWorldCreator)TemplateWorldCreator.CREATOR.getValue()).makeWorld(blocks, pos -> true);
        this.blockcount = blocks.size();
        for (Template.BlockInfo info : blocks) {
            ArrayList<Template.BlockInfo> list = (ArrayList<Template.BlockInfo>)this.layers.get(info.field_186242_a.func_177956_o());
            if (list == null) {
                list = new ArrayList<Template.BlockInfo>();
                this.layers.put(info.field_186242_a.func_177956_o(), list);
            }
            list.add(info);
        }
    }

    public MultiblockProjection setRotation(Rotation rotation) {
        if (this.settings.func_186215_c() != rotation) {
            this.settings.func_186220_a(rotation);
            this.isDirty = true;
        }
        return this;
    }

    public MultiblockProjection setFlip(boolean mirror) {
        Mirror m;
        Mirror mirror2 = m = mirror ? Mirror.FRONT_BACK : Mirror.NONE;
        if (this.settings.func_186212_b() != m) {
            this.settings.func_186214_a(m);
            this.isDirty = true;
        }
        return this;
    }

    public void reset() {
        this.settings.func_186220_a(Rotation.NONE);
        this.settings.func_186214_a(Mirror.NONE);
        this.offset.func_181079_c(0, 0, 0);
    }

    public int getBlockCount() {
        return this.blockcount;
    }

    public int getLayerCount() {
        return this.layers.size();
    }

    public int getLayerSize(int layer) {
        if (layer < 0 || layer >= this.layers.size()) {
            return 0;
        }
        return ((List)this.layers.get(layer)).size();
    }

    public World getTemplateWorld() {
        return this.templateWorld;
    }

    public MultiblockHandler.IMultiblock getMultiblock() {
        return this.multiblock;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MultiblockProjection) {
            MultiblockProjection other = (MultiblockProjection)obj;
            return this.multiblock.getUniqueName().equals((Object)other.multiblock.getUniqueName()) && this.settings.func_186212_b() == other.settings.func_186212_b() && this.settings.func_186215_c() == other.settings.func_186215_c();
        }
        return false;
    }

    public boolean process(int layer, Predicate<Info> predicate) {
        this.updateData();
        List blocks = (List)this.layers.get(layer);
        for (Template.BlockInfo info : blocks) {
            if (!predicate.test(new Info(this, info))) continue;
            return true;
        }
        return false;
    }

    public boolean processAll(BiPredicate<Integer, Info> predicate) {
        this.updateData();
        for (int layer = 0; layer < this.getLayerCount(); ++layer) {
            List blocks = (List)this.layers.get(layer);
            for (Template.BlockInfo info : blocks) {
                if (!predicate.test(layer, new Info(this, info))) continue;
                return true;
            }
        }
        return false;
    }

    private void updateData() {
        if (!this.isDirty) {
            return;
        }
        this.isDirty = false;
        boolean mirrored = this.settings.func_186212_b() == Mirror.FRONT_BACK;
        Rotation rotation = this.settings.func_186215_c();
        Vector3i size = this.multiblock.getSize(this.realWorld);
        if (!mirrored) {
            switch (rotation) {
                case CLOCKWISE_90: {
                    this.offset.func_181079_c(1 - size.func_177952_p(), 0, 0);
                    break;
                }
                case CLOCKWISE_180: {
                    this.offset.func_181079_c(1 - size.func_177958_n(), 0, 1 - size.func_177952_p());
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    this.offset.func_181079_c(0, 0, 1 - size.func_177958_n());
                    break;
                }
                default: {
                    this.offset.func_181079_c(0, 0, 0);
                    break;
                }
            }
        } else {
            switch (rotation) {
                case NONE: {
                    this.offset.func_181079_c(1 - size.func_177958_n(), 0, 0);
                    break;
                }
                case CLOCKWISE_90: {
                    this.offset.func_181079_c(1 - size.func_177952_p(), 0, 1 - size.func_177958_n());
                    break;
                }
                case CLOCKWISE_180: {
                    this.offset.func_181079_c(0, 0, 1 - size.func_177952_p());
                    break;
                }
                default: {
                    this.offset.func_181079_c(0, 0, 0);
                }
            }
        }
        int x = (rotation.ordinal() % 2 == 0 ? size.func_177958_n() : size.func_177952_p()) / 2;
        int z = (rotation.ordinal() % 2 == 0 ? size.func_177952_p() : size.func_177958_n()) / 2;
        this.offset.func_239621_a_((Vector3i)this.offset, x, 0, z);
    }

    public static final class Info {
        public final PlacementSettings settings;
        public final MultiblockHandler.IMultiblock multiblock;
        public final BlockPos tPos;
        public final World templateWorld;
        public final Template.BlockInfo tBlockInfo;

        public Info(MultiblockProjection projection, Template.BlockInfo templateBlockInfo) {
            this.multiblock = projection.multiblock;
            this.templateWorld = projection.templateWorld;
            this.settings = projection.settings;
            this.tBlockInfo = templateBlockInfo;
            this.tPos = Template.func_186266_a((PlacementSettings)this.settings, (BlockPos)templateBlockInfo.field_186242_a).func_177973_b((Vector3i)projection.offset);
        }

        public BlockState getModifiedState(World realWorld, BlockPos realPos) {
            return this.templateWorld.func_180495_p(this.tBlockInfo.field_186242_a).func_185902_a(this.settings.func_186212_b()).rotate((IWorld)realWorld, realPos, this.settings.func_186215_c());
        }

        public BlockState getRawState() {
            return this.templateWorld.func_180495_p(this.tBlockInfo.field_186242_a);
        }
    }
}

