/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.operations;

import com.google.common.math.IntMath;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SphereOperationContext;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralOperation;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;

public enum SphereOperation implements IPeripheralOperation<SphereOperationContext>
{
    SCAN_BLOCKS(2000, 8, 16, 0.17),
    SCAN_ENTITIES(2000, 8, 16, 0.17);

    private final int defaultCooldown;
    private final int defaultMaxFreeRadius;
    private final int defaultMaxCostRadius;
    private final double defaultExtraBlockCost;
    private ForgeConfigSpec.IntValue cooldown;
    private ForgeConfigSpec.IntValue max_free_radius;
    private ForgeConfigSpec.IntValue max_cost_radius;
    private ForgeConfigSpec.DoubleValue extra_block_cost;

    private SphereOperation(int defaultCooldown, int defaultMaxFreeRadius, int defaultMaxCostRadius, double defaultExtraBlockCost) {
        this.defaultCooldown = defaultCooldown;
        this.defaultMaxFreeRadius = defaultMaxFreeRadius;
        this.defaultMaxCostRadius = defaultMaxCostRadius;
        this.defaultExtraBlockCost = defaultExtraBlockCost;
    }

    @Override
    public void addToConfig(ForgeConfigSpec.Builder builder) {
        this.cooldown = builder.defineInRange(this.settingsName() + "Cooldown", this.defaultCooldown, 1000, Integer.MAX_VALUE);
        this.max_free_radius = builder.defineInRange(this.settingsName() + "MaxFreeRadius", this.defaultMaxFreeRadius, 1, 64);
        this.max_cost_radius = builder.defineInRange(this.settingsName() + "MaxCostRadius", this.defaultMaxCostRadius, 1, 64);
        this.extra_block_cost = builder.defineInRange(this.settingsName() + "ExtraBlockCost", this.defaultExtraBlockCost, 0.1, Double.MAX_VALUE);
    }

    @Override
    public int getInitialCooldown() {
        return (Integer)this.cooldown.get();
    }

    @Override
    public int getCooldown(SphereOperationContext context) {
        return (Integer)this.cooldown.get();
    }

    @Override
    public int getCost(SphereOperationContext context) {
        if (context.getRadius() <= (Integer)this.max_free_radius.get()) {
            return 0;
        }
        int freeBlockCount = IntMath.pow((int)(2 * (Integer)this.max_free_radius.get() + 1), (int)3);
        int allBlockCount = IntMath.pow((int)(2 * context.getRadius() + 1), (int)3);
        return (int)Math.floor((double)(allBlockCount - freeBlockCount) * (Double)this.extra_block_cost.get());
    }

    public int getMaxFreeRadius() {
        return (Integer)this.max_free_radius.get();
    }

    public int getMaxCostRadius() {
        return (Integer)this.max_cost_radius.get();
    }

    @Override
    public Map<String, Object> computerDescription() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("name", this.settingsName());
        data.put("type", this.getClass().getName());
        data.put("cooldown", this.cooldown.get());
        data.put("maxFreeRadius", this.max_free_radius.get());
        data.put("maxCostRadius", this.max_cost_radius.get());
        data.put("extraBlockCost", this.extra_block_cost.get());
        return data;
    }

    public SphereOperationContext free() {
        return new SphereOperationContext(this.getMaxFreeRadius());
    }

    public SphereOperationContext cost() {
        return new SphereOperationContext(this.getMaxCostRadius());
    }
}

