/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import de.srendi.advancedperipherals.common.blocks.tileentity.NBTStorageTile;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.CountingWipingStream;
import de.srendi.advancedperipherals.common.util.NBTUtil;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import de.srendi.advancedperipherals.lib.peripherals.owner.TileEntityPeripheralOwner;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;

public class NBTStoragePeripheral
extends BasePeripheral<TileEntityPeripheralOwner<NBTStorageTile>> {
    public static final String TYPE = "nbtStorage";

    public NBTStoragePeripheral(NBTStorageTile tileEntity) {
        super(TYPE, new TileEntityPeripheralOwner<NBTStorageTile>(tileEntity));
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)APConfig.PERIPHERALS_CONFIG.ENABLE_NBT_STORAGE.get();
    }

    @Override
    public Map<String, Object> getPeripheralConfiguration() {
        Map<String, Object> data = super.getPeripheralConfiguration();
        data.put("maxSize", APConfig.PERIPHERALS_CONFIG.NBT_STORAGE_MAX_SIZE.get());
        return data;
    }

    @LuaFunction(mainThread=true)
    public final MethodResult read() {
        return MethodResult.of((Object)dan200.computercraft.shared.util.NBTUtil.toLua((INBT)((NBTStorageTile)((TileEntityPeripheralOwner)this.owner).tileEntity).getStored()));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult writeJson(String jsonData) {
        CompoundNBT parsedData;
        if (jsonData.length() > (Integer)APConfig.PERIPHERALS_CONFIG.NBT_STORAGE_MAX_SIZE.get()) {
            return MethodResult.of((Object[])new Object[]{null, "JSON size is bigger than allowed"});
        }
        try {
            parsedData = JsonToNBT.func_180713_a((String)jsonData);
        }
        catch (CommandSyntaxException ex) {
            return MethodResult.of((Object[])new Object[]{null, String.format("Cannot parse json: %s", ex.getMessage())});
        }
        ((NBTStorageTile)((TileEntityPeripheralOwner)this.owner).tileEntity).setStored(parsedData);
        return MethodResult.of((Object)true);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult writeTable(Map<?, ?> data) {
        CountingWipingStream countingStream = new CountingWipingStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(countingStream);
            objectOutputStream.writeObject(data);
            objectOutputStream.close();
        }
        catch (IOException e) {
            return MethodResult.of((Object[])new Object[]{null, String.format("No idea, how this happened, but java IO Exception appear %s", e.getMessage())});
        }
        if (countingStream.getWrittenBytes() > (Integer)APConfig.PERIPHERALS_CONFIG.NBT_STORAGE_MAX_SIZE.get()) {
            return MethodResult.of((Object[])new Object[]{null, "JSON size is bigger than allowed"});
        }
        CompoundNBT parsedData = (CompoundNBT)NBTUtil.toDirectNBT(data);
        ((NBTStorageTile)((TileEntityPeripheralOwner)this.owner).tileEntity).setStored(parsedData);
        return MethodResult.of((Object)true);
    }
}

