/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral.plugins;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SingleOperation;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.plugins.AutomataCorePlugin;
import de.srendi.advancedperipherals.lib.peripherals.AutomataCorePeripheral;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralOperation;
import de.srendi.advancedperipherals.lib.peripherals.owner.TurtlePeripheralOwner;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class AutomataItemSuckPlugin
extends AutomataCorePlugin {
    public AutomataItemSuckPlugin(AutomataCorePeripheral automataCore) {
        super(automataCore);
    }

    @Override
    public IPeripheralOperation<?>[] getOperations() {
        return new IPeripheralOperation[]{SingleOperation.SUCK};
    }

    protected AxisAlignedBB getBox(BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int interactionRadius = this.automataCore.getInteractionRadius();
        return new AxisAlignedBB((double)(x - interactionRadius), (double)(y - interactionRadius), (double)(z - interactionRadius), (double)(x + interactionRadius), (double)(y + interactionRadius), (double)(z + interactionRadius));
    }

    protected List<ItemEntity> getItems() {
        TurtlePeripheralOwner owner = (TurtlePeripheralOwner)this.automataCore.getPeripheralOwner();
        return owner.getWorld().func_217357_a(ItemEntity.class, this.getBox(owner.getPos()));
    }

    protected int suckItem(ItemEntity entity, int requiredQuantity) {
        ItemStack leaveStack;
        ItemStack storeStack;
        ItemStack stack = entity.func_92059_d().func_77946_l();
        if (stack.func_190916_E() > requiredQuantity) {
            storeStack = stack.func_77979_a(requiredQuantity);
            leaveStack = stack;
        } else {
            storeStack = stack;
            leaveStack = ItemStack.field_190927_a;
        }
        ItemStack remainder = ((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).storeItem(storeStack);
        if (remainder != storeStack) {
            if (remainder.func_190926_b() && leaveStack.func_190926_b()) {
                entity.func_70106_y();
            } else if (remainder.func_190926_b()) {
                entity.func_92058_a(leaveStack);
            } else if (leaveStack.func_190926_b()) {
                entity.func_92058_a(remainder);
            } else {
                leaveStack.func_190917_f(remainder.func_190916_E());
                entity.func_92058_a(leaveStack);
            }
        }
        return requiredQuantity -= storeStack.func_190916_E();
    }

    @LuaFunction(mainThread=true)
    public final MethodResult scanItems() {
        this.automataCore.addRotationCycle();
        List<ItemEntity> items = this.getItems();
        HashMap data = new HashMap();
        int index = 1;
        for (ItemEntity item : items) {
            HashMap<String, Object> itemData = new HashMap<String, Object>();
            itemData.put("entity_id", item.func_145782_y());
            itemData.put("name", item.func_92059_d().func_151000_E().getString());
            ResourceLocation itemName = item.func_92059_d().func_77973_b().getRegistryName();
            if (itemName != null) {
                itemData.put("technicalName", itemName.toString());
            }
            itemData.put("count", item.func_92059_d().func_190916_E());
            itemData.put("tags", item.func_92059_d().func_77973_b().getTags().stream().map(ResourceLocation::toString).collect(Collectors.toList()));
            data.put(index, itemData);
            ++index;
        }
        return MethodResult.of(data);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult collectSpecificItem(@Nonnull IArguments arguments) throws LuaException {
        String technicalName = arguments.getString(0);
        int requiredQuantityArg = arguments.optInt(1, Integer.MAX_VALUE);
        return this.automataCore.withOperation(SingleOperation.SUCK, context -> {
            List<ItemEntity> items = this.getItems();
            int requiredQuantity = requiredQuantityArg;
            for (ItemEntity item : items) {
                ResourceLocation itemName = item.func_92059_d().func_77973_b().getRegistryName();
                if (itemName == null) continue;
                if (itemName.toString().equals(technicalName)) {
                    requiredQuantity -= this.suckItem(item, requiredQuantity);
                }
                if (requiredQuantity > 0) continue;
                break;
            }
            return MethodResult.of((Object)true);
        });
    }

    @LuaFunction(mainThread=true)
    public final MethodResult collectItems(@Nonnull IArguments arguments) throws LuaException {
        int requiredQuantityArg = arguments.optInt(0, Integer.MAX_VALUE);
        return this.automataCore.withOperation(SingleOperation.SUCK, context -> {
            if (requiredQuantityArg == 0) {
                return MethodResult.of((Object)true);
            }
            List<ItemEntity> items = this.getItems();
            if (items.isEmpty()) {
                return MethodResult.of((Object[])new Object[]{null, "Nothing to take"});
            }
            int requiredQuantity = requiredQuantityArg;
            for (ItemEntity entity : items) {
                if ((requiredQuantity -= this.suckItem(entity, requiredQuantity)) <= 0) break;
            }
            return MethodResult.of((Object)true);
        });
    }
}

