/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral.plugins;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SingleOperation;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SingleOperationContext;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.plugins.AutomataCorePlugin;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.NBTUtil;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.lib.peripherals.AutomataCorePeripheral;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralOperation;
import de.srendi.advancedperipherals.lib.peripherals.owner.FuelAbility;
import de.srendi.advancedperipherals.lib.peripherals.owner.PeripheralOwnerAbility;
import de.srendi.advancedperipherals.lib.peripherals.owner.TurtlePeripheralOwner;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class AutomataWarpingPlugin
extends AutomataCorePlugin {
    private static final String POINT_DATA_MARK = "warp_points";
    private static final String WORLD_DATA_MARK = "warp_world";

    public AutomataWarpingPlugin(AutomataCorePeripheral automataCore) {
        super(automataCore);
    }

    @Override
    @Nullable
    public IPeripheralOperation<?>[] getOperations() {
        return new IPeripheralOperation[]{SingleOperation.WARP};
    }

    @Nonnull
    protected Pair<MethodResult, CompoundNBT> getPointData() {
        TurtlePeripheralOwner owner = (TurtlePeripheralOwner)this.automataCore.getPeripheralOwner();
        CompoundNBT settings = owner.getDataStorage();
        if (!settings.func_74764_b(WORLD_DATA_MARK)) {
            settings.func_74778_a(WORLD_DATA_MARK, owner.getWorld().func_234923_W_().func_240901_a_().toString());
        } else {
            String worldName = settings.func_74779_i(WORLD_DATA_MARK);
            if (!owner.getWorld().func_234923_W_().func_240901_a_().toString().equals(worldName)) {
                return Pair.onlyLeft(MethodResult.of((Object[])new Object[]{null, "Incorrect world for this upgrade"}));
            }
        }
        if (!settings.func_74764_b(POINT_DATA_MARK)) {
            settings.func_218657_a(POINT_DATA_MARK, (INBT)new CompoundNBT());
        }
        return Pair.onlyRight(settings.func_74775_l(POINT_DATA_MARK));
    }

    private int getWarpCost(SingleOperationContext context) {
        FuelAbility<?> fuelAbility = ((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).getAbility(PeripheralOwnerAbility.FUEL);
        Objects.requireNonNull(fuelAbility);
        return SingleOperation.WARP.getCost(context) * fuelAbility.getFuelConsumptionMultiply();
    }

    @LuaFunction(mainThread=true)
    public final MethodResult savePoint(String name) {
        this.automataCore.addRotationCycle();
        Pair<MethodResult, CompoundNBT> pairData = this.getPointData();
        if (pairData.leftPresent()) {
            return pairData.getLeft();
        }
        CompoundNBT data = pairData.getRight();
        if (data.func_150296_c().size() >= (Integer)APConfig.METAPHYSICS_CONFIG.END_AUTOMATA_CORE_WARP_POINT_LIMIT.get()) {
            return MethodResult.of((Object[])new Object[]{null, "Cannot add new point, limit reached"});
        }
        data.func_218657_a(name, (INBT)NBTUtil.toNBT(((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).getPos()));
        return MethodResult.of((Object)true);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult deletePoint(String name) {
        this.automataCore.addRotationCycle();
        Pair<MethodResult, CompoundNBT> pairData = this.getPointData();
        if (pairData.leftPresent()) {
            return pairData.getLeft();
        }
        CompoundNBT data = pairData.getRight();
        if (!data.func_74764_b(name)) {
            return MethodResult.of((Object[])new Object[]{null, "Cannot find point to delete"});
        }
        data.func_82580_o(name);
        return MethodResult.of((Object)true);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult points() {
        Pair<MethodResult, CompoundNBT> pairData = this.getPointData();
        if (pairData.leftPresent()) {
            return pairData.getLeft();
        }
        CompoundNBT data = pairData.getRight();
        return MethodResult.of((Object)data.func_150296_c());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult warpToPoint(String name) throws LuaException {
        Pair<MethodResult, CompoundNBT> pairData = this.getPointData();
        if (pairData.leftPresent()) {
            return pairData.getLeft();
        }
        TurtlePeripheralOwner owner = (TurtlePeripheralOwner)this.automataCore.getPeripheralOwner();
        World world = owner.getWorld();
        CompoundNBT data = pairData.getRight();
        BlockPos newPosition = NBTUtil.blockPosFromNBT(data.func_74775_l(name));
        return this.automataCore.withOperation(SingleOperation.WARP, this.automataCore.toDistance(newPosition), context -> {
            boolean result = owner.move(world, newPosition);
            if (!result) {
                return MethodResult.of((Object[])new Object[]{null, "Cannot teleport to location"});
            }
            return MethodResult.of((Object)true);
        }, context -> {
            if (!owner.isMovementPossible(world, newPosition)) {
                return MethodResult.of((Object[])new Object[]{null, "Move forbidden"});
            }
            return null;
        });
    }

    @LuaFunction(mainThread=true)
    public final MethodResult estimateWarpCost(String name) {
        Pair<MethodResult, CompoundNBT> pairData = this.getPointData();
        if (pairData.leftPresent()) {
            return pairData.getLeft();
        }
        CompoundNBT data = pairData.getRight();
        BlockPos newPosition = NBTUtil.blockPosFromNBT(data.func_74775_l(name));
        return MethodResult.of((Object)this.getWarpCost(this.automataCore.toDistance(newPosition)));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult distanceToPoint(String name) {
        Pair<MethodResult, CompoundNBT> pairData = this.getPointData();
        if (pairData.leftPresent()) {
            return pairData.getLeft();
        }
        CompoundNBT data = pairData.getRight();
        BlockPos newPosition = NBTUtil.blockPosFromNBT(data.func_74775_l(name));
        return MethodResult.of((Object)newPosition.func_218139_n((Vector3i)((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).getPos()));
    }
}

