/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.blocks.base;

import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.Capabilities;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.blocks.base.IInventoryBlock;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralTileEntity;
import java.util.Collections;
import java.util.List;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
public abstract class PeripheralTileEntity<T extends BasePeripheral>
extends LockableTileEntity
implements ISidedInventory,
INamedContainerProvider,
IPeripheralTileEntity {
    private static final String AP_SETTINGS_KEY = "AP_SETTINGS";
    protected CompoundNBT apSettings;
    protected NonNullList<ItemStack> items = this instanceof IInventoryBlock ? NonNullList.func_191197_a((int)((IInventoryBlock)((Object)this)).getInvSize(), (Object)ItemStack.field_190927_a) : NonNullList.func_191197_a((int)0, (Object)ItemStack.field_190927_a);
    @Nullable
    protected T peripheral = null;
    private LazyOptional<? extends IItemHandler> handler;
    private LazyOptional<IPeripheral> peripheralCap;

    public PeripheralTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.apSettings = new CompoundNBT();
    }

    @NotNull
    public <T1> LazyOptional<T1> getCapability(@NotNull Capability<T1> cap, @Nullable Direction direction) {
        if (cap == Capabilities.CAPABILITY_PERIPHERAL) {
            if (this.peripheral == null) {
                this.peripheral = this.createPeripheral();
            }
            if (this.peripheral.isEnabled()) {
                if (this.peripheralCap == null) {
                    this.peripheralCap = LazyOptional.of(() -> this.peripheral);
                } else if (!this.peripheralCap.isPresent()) {
                    this.peripheral = this.createPeripheral();
                    this.peripheralCap = LazyOptional.of(() -> this.peripheral);
                }
                return this.peripheralCap.cast();
            }
            AdvancedPeripherals.debug(((BasePeripheral)this.peripheral).getType() + " is disabled, you can enable it in the Configuration.");
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && !this.field_145846_f && direction != null && this instanceof IInventoryBlock) {
            if (this.handler == null || !this.handler.isPresent()) {
                this.handler = LazyOptional.of(() -> new SidedInvWrapper((ISidedInventory)this, Direction.NORTH));
            }
            return this.handler.cast();
        }
        return super.getCapability(cap, direction);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        if (this.peripheralCap != null) {
            this.peripheralCap.invalidate();
        }
        if (this.handler != null) {
            this.handler.invalidate();
        }
    }

    @NotNull
    protected abstract T createPeripheral();

    public List<IComputerAccess> getConnectedComputers() {
        if (this.peripheral == null) {
            return Collections.emptyList();
        }
        return ((BasePeripheral)this.peripheral).getConnectedComputers();
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.items);
        if (!this.apSettings.isEmpty()) {
            compound.func_218657_a(AP_SETTINGS_KEY, (INBT)this.apSettings);
        }
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        ItemStackHelper.func_191283_b((CompoundNBT)compound, this.items);
        this.apSettings = compound.func_74775_l(AP_SETTINGS_KEY);
        super.func_230337_a_(state, compound);
    }

    protected ITextComponent func_213907_g() {
        return this instanceof IInventoryBlock ? ((IInventoryBlock)((Object)this)).getDisplayName() : null;
    }

    @Nullable
    public Container createMenu(int id, @NotNull PlayerInventory inventory, @NotNull PlayerEntity playerEntity) {
        return this.func_213906_a(id, inventory);
    }

    protected Container func_213906_a(int id, @NotNull PlayerInventory player) {
        return this instanceof IInventoryBlock ? (Container)((IInventoryBlock)((Object)this)).createContainer(id, player, this.field_174879_c, this.field_145850_b) : null;
    }

    public int[] func_180463_a(Direction side) {
        return new int[]{0};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this instanceof IInventoryBlock;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return this instanceof IInventoryBlock;
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemStack : this.items) {
            if (!itemStack.func_190926_b()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public ItemStack func_70301_a(int index) {
        if (index < 0 || index >= this.items.size()) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)this.items.get(index);
    }

    @NotNull
    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.items, (int)index, (int)count);
    }

    @NotNull
    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.items, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.items.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public void func_174888_l() {
        this.items.clear();
    }

    @Override
    public CompoundNBT getPeripheralSettings() {
        return this.apSettings;
    }

    @Override
    public void markSettingsChanged() {
        this.func_70296_d();
    }
}

